/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.events;

import com.google.common.collect.ImmutableList;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.typings.Param;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.liopyu.entityjs.builders.living.BaseLivingEntityBuilder;
import net.liopyu.entityjs.util.EntityJSUtils;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_5132;
import net.minecraft.class_5135;
import net.minecraft.class_7923;

public class ModifyAttributeEventJS
extends EventJS {
    public static final Map<class_1299<? extends class_1309>, List<class_1320>> modifiedAttributesMap = new HashMap<class_1299<? extends class_1309>, List<class_1320>>();
    private final List<class_1299<? extends class_1309>> entityTypes = ImmutableList.copyOf((Collection)class_7923.field_41177.method_10220().filter(class_5135::method_26875).map(entityType -> entityType).collect(Collectors.toList()));

    @Info(value="Modifies the given entity type's attributes", params={@Param(name="entityType", value="The entity type whose default attributes are to be modified"), @Param(name="attributes", value="A consumer for setting the default attributes and their values")})
    public void modify(class_1299<? extends class_1309> entityType, Consumer<AttributeModificationHelper> attributes) {
        AttributeModificationHelper helper = new AttributeModificationHelper(entityType);
        attributes.accept(helper);
        class_5132 defaultAttributeSupplier = class_5135.method_26873(entityType);
        ArrayList<class_1320> existingAttributes = new ArrayList<class_1320>();
        HashMap<class_1320, Double> defaultValues = new HashMap<class_1320, Double>();
        for (class_1320 attribute : class_7923.field_41190) {
            if (!defaultAttributeSupplier.method_27310(attribute)) continue;
            existingAttributes.add(attribute);
            defaultValues.put(attribute, defaultAttributeSupplier.method_26862(attribute));
        }
        List<class_1320> newAttributes = helper.getNewAttributes();
        Map<class_1320, Double> newAttributeDefaultValues = helper.getDefaultValues();
        ArrayList<class_1320> mergedAttributes = new ArrayList<class_1320>(existingAttributes);
        mergedAttributes.addAll(newAttributes);
        BaseLivingEntityBuilder b = (BaseLivingEntityBuilder)((Object)EntityJSUtils.getEntityBuilder(entityType));
        if (b != null) {
            b.attributes(attrBuilder -> {
                for (class_1320 attribute : mergedAttributes) {
                    if (newAttributeDefaultValues.containsKey(attribute)) {
                        attrBuilder.method_26868(attribute, ((Double)newAttributeDefaultValues.get(attribute)).doubleValue());
                        continue;
                    }
                    if (defaultValues.containsKey(attribute)) {
                        attrBuilder.method_26868(attribute, ((Double)defaultValues.get(attribute)).doubleValue());
                        continue;
                    }
                    attrBuilder.method_26867(attribute);
                }
            });
        } else {
            EntityAttributeRegistry.register(() -> entityType, () -> {
                class_5132.class_5133 builder = class_5132.method_26861();
                for (class_1320 attribute : mergedAttributes) {
                    if (newAttributeDefaultValues.containsKey(attribute)) {
                        builder.method_26868(attribute, ((Double)newAttributeDefaultValues.get(attribute)).doubleValue());
                        continue;
                    }
                    if (defaultValues.containsKey(attribute)) {
                        builder.method_26868(attribute, ((Double)defaultValues.get(attribute)).doubleValue());
                        continue;
                    }
                    builder.method_26867(attribute);
                }
                return builder;
            });
        }
    }

    @Info(value="Returns a list of all entity types that can have their attributes modified by this event")
    public List<class_1299<? extends class_1309>> getAllTypes() {
        return this.entityTypes;
    }

    @Info(value="Returns a list of all attributes the given entity type has by default")
    public List<class_1320> getAttributes(class_1299<? extends class_1309> entityType) {
        class_5132 defaultAttributeSupplier = class_5135.method_26873(entityType);
        ArrayList<class_1320> defaultAttributes = new ArrayList<class_1320>();
        for (class_1320 attribute : class_7923.field_41190) {
            if (!defaultAttributeSupplier.method_27310(attribute)) continue;
            defaultAttributes.add(attribute);
        }
        return defaultAttributes;
    }

    public static class AttributeModificationHelper {
        private final class_1299<? extends class_1309> entityType;
        private final List<class_1320> newAttributes = new ArrayList<class_1320>();
        private final Map<class_1320, Double> defaultValues = new HashMap<class_1320, Double>();

        public AttributeModificationHelper(class_1299<? extends class_1309> entityType) {
            this.entityType = entityType;
        }

        @Info(value="Adds the given attribute to the entity type, using its default value\n\nIt is safe to add an attribute that an entity type already has\n")
        public void add(class_1320 attribute) {
            this.newAttributes.add(attribute);
            modifiedAttributesMap.put(this.entityType, (List<class_1320>)ImmutableList.copyOf(this.newAttributes));
        }

        @Info(value="Adds the given attribute to the entity type, using the provided default value\n\nIt is safe to add an attribute that an entity type already has\n", params={@Param(name="attribute", value="The attribute to add"), @Param(name="defaultValue", value="The default value of the attribute")})
        public void add(class_1320 attribute, double defaultValue) {
            this.newAttributes.add(attribute);
            this.defaultValues.put(attribute, defaultValue);
            modifiedAttributesMap.put(this.entityType, (List<class_1320>)ImmutableList.copyOf(this.newAttributes));
        }

        @Info(value="Gets a list of all attributes post-modification\n")
        private List<class_1320> getNewAttributes() {
            return this.newAttributes;
        }

        @Info(value="Gets a list of all default attribute values.\n")
        private Map<class_1320, Double> getDefaultValues() {
            return this.defaultValues;
        }
    }
}

