/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.item;

import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.function.Function;
import net.liopyu.entityjs.builders.nonliving.vanilla.EyeOfEnderJSBuilder;
import net.liopyu.entityjs.entities.nonliving.vanilla.EyeOfEnderEntityJS;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1672;
import net.minecraft.class_174;
import net.minecraft.class_1777;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5712;
import net.minecraft.class_7045;
import org.jetbrains.annotations.Nullable;

public class EyeOfEnderItemBuilder
extends ItemBuilder {
    public final transient EyeOfEnderJSBuilder parent;
    public transient boolean triggersCriteria;
    public transient class_1657 sPlayer;
    public transient class_3414 soundEvent;
    public transient class_3419 soundSource;
    public transient float soundVolume;
    public transient float soundPitch;
    public transient boolean overrideSound;
    public transient Function<ContextUtils.ItemUseContext, Object> signalTo;

    public EyeOfEnderItemBuilder(class_2960 i, EyeOfEnderJSBuilder parent) {
        super(i);
        this.parent = parent;
        this.texture = i.method_12836() + ":item/" + i.method_12832();
        this.triggersCriteria = true;
        this.overrideSound = false;
    }

    @Info(value="A function to determine where the thrown ender eye item will head towards.\n\nExample usage:\n```javascript\nbuilder.signalTo(context => {\n    const { level, player, hand } = context\n    return // Some BlockPos for the eye to navigate to when thrown\n});\n```\n")
    public EyeOfEnderItemBuilder signalTo(Function<ContextUtils.ItemUseContext, Object> f) {
        this.signalTo = f;
        return this;
    }

    @Info(value="Sets the sound to play when the eye item is thrown at the coordinates of the player\n\n@param sPlayer The player to play the sound to, can be null.\n@param soundEvent The sound to play when the eye item is thrown\n@param soundSource The source of the sound in the mixer.\n@param soundVolume The volume of the sound.\n@param soundPitch The pitch of the sound.\n\n```javascript\nitem.playSoundOverride(null,\"ambient.basalt_deltas.additions\",\"ambient\",1,1)\n```\n")
    public EyeOfEnderItemBuilder playSoundOverride(@Nullable class_1657 player, class_3414 soundEvent, class_3419 soundSource, float volume, float pitch) {
        this.sPlayer = player;
        this.soundEvent = soundEvent;
        this.soundSource = soundSource;
        this.soundVolume = volume;
        this.soundPitch = pitch;
        this.overrideSound = true;
        return this;
    }

    @Info(value="Sets if the eye of ender triggers the USED_ENDER_EYE Criteria")
    public EyeOfEnderItemBuilder triggersCriteria(boolean triggersCriteria) {
        this.triggersCriteria = triggersCriteria;
        return this;
    }

    public class_1792 createObject() {
        return new class_1777(this.createItemProperties()){

            public class_1271<class_1799> method_7836(class_1937 pLevel, class_1657 pPlayer, class_1268 pHand) {
                class_1799 $$3 = pPlayer.method_5998(pHand);
                class_3965 $$4 = 1.method_7872((class_1937)pLevel, (class_1657)pPlayer, (class_3959.class_242)class_3959.class_242.field_1348);
                if ($$4.method_17783() == class_239.class_240.field_1332 && pLevel.method_8320($$4.method_17777()).method_27852(class_2246.field_10398)) {
                    return class_1271.method_22430((Object)$$3);
                }
                pPlayer.method_6019(pHand);
                if (pLevel instanceof class_3218) {
                    class_3218 $$5 = (class_3218)pLevel;
                    class_2338 $$6 = $$5.method_8487(class_7045.field_37040, pPlayer.method_24515(), 100, false);
                    if (EyeOfEnderItemBuilder.this.signalTo != null) {
                        ContextUtils.ItemUseContext context = new ContextUtils.ItemUseContext(pLevel, pPlayer, pHand);
                        Object obj = EyeOfEnderItemBuilder.this.signalTo.apply(context);
                        if (!(obj instanceof class_2338)) {
                            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for signalTo in ender eye item builder: " + obj + ". Must be a BlockPos. Defaulting to null.");
                            return class_1271.method_22428((Object)$$3);
                        }
                        class_2338 b = (class_2338)obj;
                        EyeOfEnderEntityJS $$7 = new EyeOfEnderEntityJS(EyeOfEnderItemBuilder.this.parent, pLevel, (class_1299<? extends class_1672>)((class_1299)EyeOfEnderItemBuilder.this.parent.get()), pPlayer.method_23317(), pPlayer.method_23323(0.5), pPlayer.method_23321());
                        $$7.method_16933($$3);
                        $$7.method_7478(b);
                        pLevel.method_32888(class_5712.field_28161, $$7.method_19538(), class_5712.class_7397.method_43285((class_1297)pPlayer));
                        pLevel.method_8649((class_1297)$$7);
                        if (pPlayer instanceof class_3222 && EyeOfEnderItemBuilder.this.triggersCriteria) {
                            class_174.field_1186.method_9157((class_3222)pPlayer, $$6);
                        }
                        if (EyeOfEnderItemBuilder.this.overrideSound) {
                            pLevel.method_43128(EyeOfEnderItemBuilder.this.sPlayer, pPlayer.method_23317(), pPlayer.method_23318(), pPlayer.method_23321(), EyeOfEnderItemBuilder.this.soundEvent, EyeOfEnderItemBuilder.this.soundSource, EyeOfEnderItemBuilder.this.soundVolume, EyeOfEnderItemBuilder.this.soundPitch);
                        } else {
                            pLevel.method_43128((class_1657)null, pPlayer.method_23317(), pPlayer.method_23318(), pPlayer.method_23321(), class_3417.field_15155, class_3419.field_15254, 0.5f, 0.4f / (pLevel.method_8409().method_43057() * 0.4f + 0.8f));
                        }
                        pLevel.method_8444((class_1657)null, 1003, pPlayer.method_24515(), 0);
                        if (!pPlayer.method_31549().field_7477) {
                            $$3.method_7934(1);
                        }
                        pPlayer.method_7259(class_3468.field_15372.method_14956((Object)this));
                        pPlayer.method_23667(pHand, true);
                        return class_1271.method_22427((Object)$$3);
                    }
                    if ($$6 != null) {
                        EyeOfEnderEntityJS $$7 = new EyeOfEnderEntityJS(EyeOfEnderItemBuilder.this.parent, pLevel, (class_1299<? extends class_1672>)((class_1299)EyeOfEnderItemBuilder.this.parent.get()), pPlayer.method_23317(), pPlayer.method_23323(0.5), pPlayer.method_23321());
                        $$7.method_16933($$3);
                        $$7.method_7478($$6);
                        pLevel.method_32888(class_5712.field_28161, $$7.method_19538(), class_5712.class_7397.method_43285((class_1297)pPlayer));
                        pLevel.method_8649((class_1297)$$7);
                        if (pPlayer instanceof class_3222 && EyeOfEnderItemBuilder.this.triggersCriteria) {
                            class_174.field_1186.method_9157((class_3222)pPlayer, $$6);
                        }
                        if (EyeOfEnderItemBuilder.this.overrideSound) {
                            pLevel.method_43128(EyeOfEnderItemBuilder.this.sPlayer, pPlayer.method_23317(), pPlayer.method_23318(), pPlayer.method_23321(), EyeOfEnderItemBuilder.this.soundEvent, EyeOfEnderItemBuilder.this.soundSource, EyeOfEnderItemBuilder.this.soundVolume, EyeOfEnderItemBuilder.this.soundPitch);
                        } else {
                            pLevel.method_43128((class_1657)null, pPlayer.method_23317(), pPlayer.method_23318(), pPlayer.method_23321(), class_3417.field_15155, class_3419.field_15254, 0.5f, 0.4f / (pLevel.method_8409().method_43057() * 0.4f + 0.8f));
                        }
                        pLevel.method_8444((class_1657)null, 1003, pPlayer.method_24515(), 0);
                        if (!pPlayer.method_31549().field_7477) {
                            $$3.method_7934(1);
                        }
                        pPlayer.method_7259(class_3468.field_15372.method_14956((Object)this));
                        pPlayer.method_23667(pHand, true);
                        return class_1271.method_22427((Object)$$3);
                    }
                }
                return class_1271.method_22428((Object)$$3);
            }
        };
    }
}

