/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.util;

import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import software.bernie.geckolib.core.animation.Animation;

public class EntityJSHelperClass {
    public static final Set<String> errorMessagesLogged = new HashSet<String>();
    public static final Set<String> warningMessagesLogged = new HashSet<String>();

    public static void logErrorMessageOnce(String errorMessage) {
        if (!errorMessagesLogged.contains(errorMessage)) {
            ConsoleJS.STARTUP.error((Object)errorMessage);
            errorMessagesLogged.add(errorMessage);
        }
    }

    public static void logWarningMessageOnce(String errorMessage) {
        if (!warningMessagesLogged.contains(errorMessage)) {
            ConsoleJS.STARTUP.warn((Object)errorMessage);
            warningMessagesLogged.add(errorMessage);
        }
    }

    public static void logErrorMessageOnceCatchable(String errorMessage, Throwable e) {
        if (!errorMessagesLogged.contains(errorMessage)) {
            ConsoleJS.STARTUP.error(errorMessage, e);
            errorMessagesLogged.add(errorMessage);
        }
    }

    public static <T> boolean consumerCallback(Consumer<T> consumer, T value, String errorMessage) {
        try {
            consumer.accept(value);
        }
        catch (Throwable e) {
            EntityJSHelperClass.logErrorMessageOnceCatchable(errorMessage, e);
            return false;
        }
        return true;
    }

    public static Object convertObjectToDesired(Object input, String outputType) {
        return switch (outputType.toLowerCase()) {
            case "integer" -> EntityJSHelperClass.convertToInteger(input);
            case "double" -> EntityJSHelperClass.convertToDouble(input);
            case "float" -> EntityJSHelperClass.convertToFloat(input);
            case "boolean" -> EntityJSHelperClass.convertToBoolean(input);
            case "interactionresult" -> EntityJSHelperClass.convertToInteractionResult(input);
            case "resourcelocation" -> EntityJSHelperClass.convertToResourceLocation(input);
            case "looptype" -> EntityJSHelperClass.convertToLoopType(input);
            default -> input;
        };
    }

    private static Animation.LoopType convertToLoopType(Object input) {
        if (input instanceof Animation.LoopType) {
            return (Animation.LoopType)input;
        }
        if (input instanceof String) {
            String stringValue;
            return switch (stringValue = ((String)input).toUpperCase()) {
                case "LOOP" -> Animation.LoopType.LOOP;
                case "PLAY_ONCE" -> Animation.LoopType.PLAY_ONCE;
                case "HOLD_ON_LAST_FRAME" -> Animation.LoopType.HOLD_ON_LAST_FRAME;
                default -> Animation.LoopType.DEFAULT;
            };
        }
        return Animation.LoopType.DEFAULT;
    }

    private static class_2960 convertToResourceLocation(Object input) {
        if (input instanceof class_2960) {
            return (class_2960)input;
        }
        if (input instanceof String) {
            return new class_2960((String)input);
        }
        return null;
    }

    private static class_1269 convertToInteractionResult(Object input) {
        if (input instanceof class_1269) {
            return (class_1269)input;
        }
        if (input instanceof String) {
            String stringValue;
            switch (stringValue = ((String)input).toLowerCase()) {
                case "success": {
                    return class_1269.field_5812;
                }
                case "consume": {
                    return class_1269.field_21466;
                }
                case "pass": {
                    return class_1269.field_5811;
                }
                case "fail": {
                    return class_1269.field_5814;
                }
                case "consume_partial": {
                    return class_1269.field_33562;
                }
            }
        }
        return null;
    }

    private static Boolean convertToBoolean(Object input) {
        if (input instanceof Boolean) {
            return (Boolean)input;
        }
        if (input instanceof String) {
            String stringValue = ((String)input).toLowerCase();
            if ("true".equals(stringValue)) {
                return true;
            }
            if ("false".equals(stringValue)) {
                return false;
            }
        }
        return null;
    }

    private static Integer convertToInteger(Object input) {
        if (input instanceof Integer) {
            return (Integer)input;
        }
        if (input instanceof Double || input instanceof Float) {
            return ((Number)input).intValue();
        }
        return null;
    }

    private static Double convertToDouble(Object input) {
        if (input instanceof Double) {
            return (Double)input;
        }
        if (input instanceof Integer || input instanceof Float) {
            return ((Number)input).doubleValue();
        }
        return null;
    }

    private static Float convertToFloat(Object input) {
        if (input instanceof Float) {
            return (Float)input;
        }
        if (input instanceof Integer || input instanceof Double) {
            return Float.valueOf(((Number)input).floatValue());
        }
        return null;
    }

    public static class EntityMovementTracker {
        private double prevX = 0.0;
        private double prevY = 0.0;
        private double prevZ = 0.0;

        public boolean isMoving(class_1297 entity) {
            double currentX = entity.method_23317();
            double currentY = entity.method_23318();
            double currentZ = entity.method_23321();
            boolean moving = currentX != this.prevX || currentY != this.prevY || currentZ != this.prevZ;
            this.prevX = currentX;
            this.prevY = currentY;
            this.prevZ = currentZ;
            return moving;
        }
    }
}

