/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.util;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.latvian.mods.kubejs.event.EventGroup;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.event.Extra;
import dev.latvian.mods.kubejs.script.data.VirtualKubeJSDataPack;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.registry.DynamicRegistrySetupCallback;
import net.liopyu.entityjs.builders.living.BaseLivingEntityBuilder;
import net.liopyu.entityjs.events.AddGoalSelectorsEventJS;
import net.liopyu.entityjs.events.AddGoalTargetsEventJS;
import net.liopyu.entityjs.events.BuildBrainEventJS;
import net.liopyu.entityjs.events.BuildBrainProviderEventJS;
import net.liopyu.entityjs.events.EntityModificationEventJS;
import net.liopyu.entityjs.events.ModifyAttributeEventJS;
import net.minecraft.class_6861;

public class EventHandlers {
    public static final EventGroup EntityJSEvents = EventGroup.of((String)"EntityJSEvents");
    public static final EventHandler addGoalTargets = EntityJSEvents.server("addGoals", () -> AddGoalTargetsEventJS.class).extra(Extra.REQUIRES_ID);
    public static final EventHandler addGoalSelectors = EntityJSEvents.server("addGoalSelectors", () -> AddGoalSelectorsEventJS.class).extra(Extra.REQUIRES_ID);
    public static final EventHandler buildBrain = EntityJSEvents.server("buildBrain", () -> BuildBrainEventJS.class).extra(Extra.REQUIRES_ID);
    public static final EventHandler buildBrainProvider = EntityJSEvents.server("buildBrainProvider", () -> BuildBrainProviderEventJS.class).extra(Extra.REQUIRES_ID);
    public static final EventHandler editAttributes = EntityJSEvents.startup("attributes", () -> ModifyAttributeEventJS.class);
    public static final EventHandler modifyEntity = EntityJSEvents.startup("modifyEntity", () -> EntityModificationEventJS.class);

    public static void init() {
        DynamicRegistrySetupCallback.EVENT.register(Event.DEFAULT_PHASE, listener -> EventHandlers.attributeModification());
        ServerLifecycleEvents.SERVER_STARTING.register(server -> EventHandlers.registerServerAttributes());
    }

    public static void registerServerAttributes() {
        for (BaseLivingEntityBuilder<?> builder : BaseLivingEntityBuilder.thisList) {
            EntityAttributeRegistry.register(builder, builder::getAttributeBuilder);
        }
    }

    public static void registerClientAttributes() {
        for (BaseLivingEntityBuilder<?> builder : BaseLivingEntityBuilder.thisList) {
            EntityAttributeRegistry.register(builder, builder::getAttributeBuilder);
        }
    }

    public static void attributeModification() {
        if (editAttributes.hasListeners()) {
            editAttributes.post((EventJS)new ModifyAttributeEventJS());
        }
    }

    public static void postDataEvent(VirtualKubeJSDataPack pack, class_6861 multiManager) {
        if (pack == null || multiManager != null) {
            // empty if block
        }
    }
}

