/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.item;

import com.mojang.datafixers.util.Pair;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.Optional;
import java.util.function.Function;
import net.liopyu.entityjs.builders.nonliving.vanilla.EyeOfEnderJSBuilder;
import net.liopyu.entityjs.entities.nonliving.vanilla.EyeOfEnderEntityJS;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.item.EnderEyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class EyeOfEnderItemBuilder
extends ItemBuilder {
    public final transient EyeOfEnderJSBuilder parent;
    public transient boolean triggersCriteria;
    public transient Player sPlayer;
    public transient SoundEvent soundEvent;
    public transient SoundSource soundSource;
    public transient float soundVolume;
    public transient float soundPitch;
    public transient boolean overrideSound;
    public transient Function<ContextUtils.ItemUseContext, Object> signalTo;
    public transient ResourceLocation structure;
    public transient ResourceLocation structureTag;
    public transient int chunkRadius;

    public EyeOfEnderItemBuilder(ResourceLocation i, EyeOfEnderJSBuilder parent) {
        super(i);
        this.parent = parent;
        this.texture = i.m_135827_() + ":item/" + i.m_135815_();
        this.triggersCriteria = true;
        this.overrideSound = false;
    }

    @Info(value="A function to determine where the thrown ender eye item will head towards.\n\nExample usage:\n```javascript\nbuilder.signalTo(context => {\n    const { level, player, hand } = context\n    return // Some BlockPos for the eye to navigate to when thrown\n});\n```\n")
    public EyeOfEnderItemBuilder signalTo(Function<ContextUtils.ItemUseContext, Object> f) {
        this.signalTo = f;
        return this;
    }

    @Info(value="A function to determine which structure tag the thrown ender eye item will head towards in a certain chunk radius.\n\nExample usage:\n```javascript\nbuilder.signalToStructureTag(\"minecraft:village\", 100);\n```\n")
    public EyeOfEnderItemBuilder signalToStructureTag(ResourceLocation resourceLocation, int chunkRadius) {
        this.structureTag = resourceLocation;
        this.chunkRadius = chunkRadius;
        return this;
    }

    @Info(value="A function to determine which structure tag the thrown ender eye item will head towards in a 100 chunk radius.\n\nExample usage:\n```javascript\nbuilder.signalToStructureTag(\"minecraft:village\");\n```\n")
    public EyeOfEnderItemBuilder signalToStructureTag(ResourceLocation resourceLocation) {
        this.structureTag = resourceLocation;
        this.chunkRadius = 100;
        return this;
    }

    @Info(value="A function to determine structure the thrown ender eye item will head towards in a certain chunk radius.\n\nExample usage:\n```javascript\nbuilder.signalToStructure(\"minecraft:village_plains\", 100);\n```\n")
    public EyeOfEnderItemBuilder signalToStructure(ResourceLocation resourceLocation, int chunkRadius) {
        this.structure = resourceLocation;
        this.chunkRadius = chunkRadius;
        return this;
    }

    @Info(value="A function to determine structure the thrown ender eye item will head towards in a 100 chunk radius.\n\nExample usage:\n```javascript\nbuilder.signalToStructure(\"minecraft:village_plains\");\n```\n")
    public EyeOfEnderItemBuilder signalToStructure(ResourceLocation resourceLocation) {
        this.structure = resourceLocation;
        this.chunkRadius = 100;
        return this;
    }

    @Info(value="Sets the sound to play when the eye item is thrown at the coordinates of the player\n\n@param sPlayer The player to play the sound to, can be null.\n@param soundEvent The sound to play when the eye item is thrown\n@param soundSource The source of the sound in the mixer.\n@param soundVolume The volume of the sound.\n@param soundPitch The pitch of the sound.\n\n```javascript\nitem.playSoundOverride(null,\"ambient.basalt_deltas.additions\",\"ambient\",1,1)\n```\n")
    public EyeOfEnderItemBuilder playSoundOverride(@Nullable Player player, SoundEvent soundEvent, SoundSource soundSource, float volume, float pitch) {
        this.sPlayer = player;
        this.soundEvent = soundEvent;
        this.soundSource = soundSource;
        this.soundVolume = volume;
        this.soundPitch = pitch;
        this.overrideSound = true;
        return this;
    }

    @Info(value="Sets if the eye of ender triggers the USED_ENDER_EYE Criteria")
    public EyeOfEnderItemBuilder triggersCriteria(boolean triggersCriteria) {
        this.triggersCriteria = triggersCriteria;
        return this;
    }

    public Item createObject() {
        return new EnderEyeItem(this.createItemProperties()){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
                if (EyeOfEnderItemBuilder.this.use != null && EyeOfEnderItemBuilder.this.use.use(pLevel, pPlayer, pHand)) {
                    ItemUtils.m_150959_((Level)pLevel, (Player)pPlayer, (InteractionHand)pHand);
                }
                ItemStack $$3 = pPlayer.m_21120_(pHand);
                BlockHitResult $$4 = 1.m_41435_((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)ClipContext.Fluid.NONE);
                if ($$4.m_6662_() == HitResult.Type.BLOCK && pLevel.m_8055_($$4.m_82425_()).m_60713_(Blocks.f_50258_)) {
                    return InteractionResultHolder.m_19098_((Object)$$3);
                }
                pPlayer.m_6672_(pHand);
                if (!(pLevel instanceof ServerLevel)) return InteractionResultHolder.m_19096_((Object)$$3);
                ServerLevel $$5 = (ServerLevel)pLevel;
                BlockPos $$6 = $$5.m_215011_(StructureTags.f_215882_, pPlayer.m_20183_(), 100, false);
                if (EyeOfEnderItemBuilder.this.signalTo != null || EyeOfEnderItemBuilder.this.structure != null || EyeOfEnderItemBuilder.this.structureTag != null) {
                    if (EyeOfEnderItemBuilder.this.signalTo != null) {
                        ContextUtils.ItemUseContext context = new ContextUtils.ItemUseContext(pLevel, pPlayer, pHand);
                        Object obj = EyeOfEnderItemBuilder.this.signalTo.apply(context);
                        if (obj == null) return InteractionResultHolder.m_19096_((Object)$$3);
                        EyeOfEnderEntityJS $$7 = new EyeOfEnderEntityJS(EyeOfEnderItemBuilder.this.parent, pLevel, (EntityType<? extends EyeOfEnder>)((EntityType)EyeOfEnderItemBuilder.this.parent.get()), pPlayer.m_20185_(), pPlayer.m_20227_(0.5), pPlayer.m_20189_());
                        $$7.m_36972_($$3);
                        if (obj instanceof BlockPos) {
                            BlockPos b = (BlockPos)obj;
                            if (b == null) return InteractionResultHolder.m_19096_((Object)$$3);
                            $$7.m_36967_(b);
                            pLevel.m_214171_(GameEvent.f_157778_, $$7.m_20182_(), GameEvent.Context.m_223717_((Entity)pPlayer));
                            pLevel.m_7967_((Entity)$$7);
                        }
                        pLevel.m_214171_(GameEvent.f_157778_, $$7.m_20182_(), GameEvent.Context.m_223717_((Entity)pPlayer));
                        pLevel.m_7967_((Entity)$$7);
                    } else if (EyeOfEnderItemBuilder.this.structureTag != null) {
                        EyeOfEnderEntityJS $$7 = new EyeOfEnderEntityJS(EyeOfEnderItemBuilder.this.parent, pLevel, (EntityType<? extends EyeOfEnder>)((EntityType)EyeOfEnderItemBuilder.this.parent.get()), pPlayer.m_20185_(), pPlayer.m_20227_(0.5), pPlayer.m_20189_());
                        $$7.m_36972_($$3);
                        TagKey structureTagKey = TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)EyeOfEnderItemBuilder.this.structureTag);
                        BlockPos searchOrigin = pPlayer.m_20183_();
                        BlockPos location = ((ServerLevel)pLevel).m_215011_(structureTagKey, searchOrigin, EyeOfEnderItemBuilder.this.chunkRadius, false);
                        if (location == null) return InteractionResultHolder.m_19096_((Object)$$3);
                        $$7.m_36967_(location);
                        pLevel.m_214171_(GameEvent.f_157778_, $$7.m_20182_(), GameEvent.Context.m_223717_((Entity)pPlayer));
                        pLevel.m_7967_((Entity)$$7);
                    } else if (EyeOfEnderItemBuilder.this.structure != null) {
                        ResourceLocation structureId = EyeOfEnderItemBuilder.this.structure;
                        Registry structureRegistry = pLevel.m_9598_().m_175515_(Registries.f_256944_);
                        Optional holder = structureRegistry.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)structureId));
                        if (holder.isPresent()) {
                            HolderSet.Direct holderSet = HolderSet.m_205809_((Holder[])new Holder[]{(Holder)holder.get()});
                            BlockPos origin = pPlayer.m_20183_();
                            Pair result = ((ServerLevel)pLevel).m_7726_().m_8481_().m_223037_((ServerLevel)pLevel, (HolderSet)holderSet, origin, EyeOfEnderItemBuilder.this.chunkRadius, false);
                            if (result == null) return InteractionResultHolder.m_19096_((Object)$$3);
                            BlockPos location = (BlockPos)result.getFirst();
                            EyeOfEnderEntityJS eye = new EyeOfEnderEntityJS(EyeOfEnderItemBuilder.this.parent, pLevel, (EntityType<? extends EyeOfEnder>)((EntityType)EyeOfEnderItemBuilder.this.parent.get()), pPlayer.m_20185_(), pPlayer.m_20227_(0.5), pPlayer.m_20189_());
                            eye.m_36972_($$3);
                            eye.m_36967_(location);
                            pLevel.m_214171_(GameEvent.f_157778_, eye.m_20182_(), GameEvent.Context.m_223717_((Entity)pPlayer));
                            pLevel.m_7967_((Entity)eye);
                        } else {
                            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Could not find registry for structure: " + structureId + " in method signalToStructure");
                            return InteractionResultHolder.m_19096_((Object)$$3);
                        }
                    }
                    if (pPlayer instanceof ServerPlayer && EyeOfEnderItemBuilder.this.triggersCriteria) {
                        CriteriaTriggers.f_10579_.m_73935_((ServerPlayer)pPlayer, $$6);
                    }
                    if (EyeOfEnderItemBuilder.this.overrideSound) {
                        pLevel.m_6263_(EyeOfEnderItemBuilder.this.sPlayer, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), EyeOfEnderItemBuilder.this.soundEvent, EyeOfEnderItemBuilder.this.soundSource, EyeOfEnderItemBuilder.this.soundVolume, EyeOfEnderItemBuilder.this.soundPitch);
                    } else {
                        pLevel.m_6263_((Player)null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_11898_, SoundSource.NEUTRAL, 0.5f, 0.4f / (pLevel.m_213780_().m_188501_() * 0.4f + 0.8f));
                    }
                    pLevel.m_5898_((Player)null, 1003, pPlayer.m_20183_(), 0);
                    if (!pPlayer.m_150110_().f_35937_) {
                        $$3.m_41774_(1);
                    }
                    pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    pPlayer.m_21011_(pHand, true);
                    return InteractionResultHolder.m_19090_((Object)$$3);
                }
                if ($$6 == null) return InteractionResultHolder.m_19096_((Object)$$3);
                EyeOfEnderEntityJS $$7 = new EyeOfEnderEntityJS(EyeOfEnderItemBuilder.this.parent, pLevel, (EntityType<? extends EyeOfEnder>)((EntityType)EyeOfEnderItemBuilder.this.parent.get()), pPlayer.m_20185_(), pPlayer.m_20227_(0.5), pPlayer.m_20189_());
                $$7.m_36972_($$3);
                $$7.m_36967_($$6);
                pLevel.m_214171_(GameEvent.f_157778_, $$7.m_20182_(), GameEvent.Context.m_223717_((Entity)pPlayer));
                pLevel.m_7967_((Entity)$$7);
                if (pPlayer instanceof ServerPlayer && EyeOfEnderItemBuilder.this.triggersCriteria) {
                    CriteriaTriggers.f_10579_.m_73935_((ServerPlayer)pPlayer, $$6);
                }
                if (EyeOfEnderItemBuilder.this.overrideSound) {
                    pLevel.m_6263_(EyeOfEnderItemBuilder.this.sPlayer, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), EyeOfEnderItemBuilder.this.soundEvent, EyeOfEnderItemBuilder.this.soundSource, EyeOfEnderItemBuilder.this.soundVolume, EyeOfEnderItemBuilder.this.soundPitch);
                } else {
                    pLevel.m_6263_((Player)null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_11898_, SoundSource.NEUTRAL, 0.5f, 0.4f / (pLevel.m_213780_().m_188501_() * 0.4f + 0.8f));
                }
                pLevel.m_5898_((Player)null, 1003, pPlayer.m_20183_(), 0);
                if (!pPlayer.m_150110_().f_35937_) {
                    $$3.m_41774_(1);
                }
                pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                pPlayer.m_21011_(pHand, true);
                return InteractionResultHolder.m_19090_((Object)$$3);
            }
        };
    }
}

