/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.entities.nonliving.vanilla;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import net.liopyu.entityjs.builders.nonliving.BaseEntityBuilder;
import net.liopyu.entityjs.builders.nonliving.vanilla.TridentJSBuilder;
import net.liopyu.entityjs.entities.nonliving.entityjs.IAnimatableJSNL;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TridentEntityJS
extends ThrownTrident
implements IAnimatableJSNL {
    public TridentJSBuilder builder;
    private final AnimatableInstanceCache getAnimatableInstanceCache;

    public TridentEntityJS(TridentJSBuilder builder, EntityType<? extends TridentEntityJS> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.builder = builder;
        this.getAnimatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    }

    public TridentEntityJS(TridentJSBuilder builder, EntityType<? extends TridentEntityJS> pEntityType, LivingEntity pShooter, Level pLevel, ItemStack pItemStack) {
        super(pEntityType, pLevel);
        this.builder = builder;
        this.getAnimatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
        this.setPos(pShooter.getX(), pShooter.getEyeY() - (double)0.1f, pShooter.getZ());
        this.setOwner((Entity)pShooter);
        if (pShooter instanceof Player) {
            this.pickup = AbstractArrow.Pickup.ALLOWED;
        }
        this.setPickupItemStack(pItemStack.copy());
        this.entityData.set(ID_LOYALTY, (Object)this.getLoyaltyFromItem(pItemStack));
        this.entityData.set(ID_FOIL, (Object)pItemStack.hasFoil());
    }

    @Override
    public BaseEntityBuilder<?> getBuilder() {
        return this.builder;
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.getAnimatableInstanceCache;
    }

    public String entityName() {
        return this.getType().toString();
    }

    public ItemStack getPickupItem() {
        return super.getPickupItem();
    }

    public void setPickupItemStack(ItemStack p_331486_) {
        super.setPickupItemStack(p_331486_);
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return this.builder == null ? super.getDefaultHitGroundSoundEvent() : this.builder.defaultHitGroundSoundEvent;
    }

    protected void onHitEntity(EntityHitResult result) {
        SoundEvent $$6;
        float f;
        if (this.builder != null && this.builder.onHitEntity != null) {
            ContextUtils.ProjectileEntityHitContext context = new ContextUtils.ProjectileEntityHitContext(result, (Projectile)this);
            EntityJSHelperClass.consumerCallback(this.builder.onHitEntity, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onHitEntity.");
        }
        Entity $$1 = result.getEntity();
        float $$2 = 8.0f;
        Entity $$4 = this.getOwner();
        float f2 = f = this.builder != null ? this.builder.attackDamage : 8.0f;
        DamageSource $$5 = this.builder.damageSource != null ? this.builder.damageSource : this.damageSources().trident((Entity)this, (Entity)($$4 == null ? this : $$4));
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (this.getWeaponItem() != null && $$4 != null) {
                $$2 += EnchantmentHelper.modifyDamage((ServerLevel)serverlevel, (ItemStack)this.getWeaponItem(), (Entity)$$4, (DamageSource)$$5, (float)f);
            }
        }
        this.dealtDamage = true;
        SoundEvent soundEvent = $$6 = this.builder == null ? SoundEvents.TRIDENT_HIT : this.builder.defaultTridentHitSound;
        if ($$1.hurt($$5, f)) {
            if ($$1.getType() == EntityType.ENDERMAN) {
                return;
            }
            Level level2 = this.level();
            if (level2 instanceof ServerLevel) {
                ServerLevel serverlevel1 = (ServerLevel)level2;
                EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverlevel1, (Entity)$$1, (DamageSource)$$5, (ItemStack)this.getWeaponItem());
            }
            if ($$1 instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)$$1;
                this.doKnockback(livingentity, $$5);
                this.doPostHurtEffects(livingentity);
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(-0.01, -0.1, -0.01));
        float $$8 = 1.0f;
        if (this.level() instanceof ServerLevel && (this.level().isThundering() || this.builder.alwaysThunder) && this.isChanneling()) {
            BlockPos $$9 = $$1.blockPosition();
            if (this.level().canSeeSky($$9)) {
                LightningBolt $$10 = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level());
                $$10.moveTo(Vec3.atBottomCenterOf((Vec3i)$$9));
                $$10.setCause($$4 instanceof ServerPlayer ? (ServerPlayer)$$4 : null);
                this.level().addFreshEntity((Entity)$$10);
                $$6 = this.builder == null ? SoundEvents.TRIDENT_HIT : this.builder.thunderHitSound;
                $$8 = this.builder == null ? 5.0f : this.builder.thunderHitVolume;
            }
        }
        this.playSound($$6, $$8, 1.0f);
    }

    public boolean isChanneling() {
        AtomicBoolean channeling = new AtomicBoolean(false);
        this.getWeaponItem().getEnchantments().keySet().forEach(e -> {
            if (e.unwrapKey().get() == Enchantments.CHANNELING) {
                channeling.set(true);
            }
        });
        if (this.builder != null && this.builder.isChanneling != null) {
            Boolean obj = this.builder.isChanneling.test(this);
            if (obj instanceof Boolean) {
                Boolean b = obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isChanneling from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + channeling.get());
        }
        return channeling.get();
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.builder != null && this.builder.onHurt != null) {
            ContextUtils.EntityHurtContext context = new ContextUtils.EntityHurtContext((Entity)this, pSource, pAmount);
            EntityJSHelperClass.consumerCallback(this.builder.onHurt, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onHurt.");
        }
        return super.hurt(pSource, pAmount);
    }

    public void lerpTo(double x, double y, double z, float yaw, float pitch, int posRotationIncrements) {
        super.lerpTo(x, y, z, yaw, pitch, posRotationIncrements);
        if (this.builder != null && this.builder.lerpTo != null) {
            ContextUtils.LerpToContext context = new ContextUtils.LerpToContext(x, y, z, yaw, pitch, posRotationIncrements, (Entity)this);
            EntityJSHelperClass.consumerCallback(this.builder.lerpTo, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: lerpTo.");
        }
    }

    public void tick() {
        super.tick();
        if (this.builder != null && this.builder.tick != null) {
            EntityJSHelperClass.consumerCallback(this.builder.tick, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: tick.");
        }
    }

    public void move(MoverType pType, Vec3 pPos) {
        super.move(pType, pPos);
        if (this.builder != null && this.builder.move != null) {
            ContextUtils.MovementContext context = new ContextUtils.MovementContext(pType, pPos, (Entity)this);
            EntityJSHelperClass.consumerCallback(this.builder.move, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: move.");
        }
    }

    public void playerTouch(Player player) {
        if (this.builder != null && this.builder.playerTouch != null) {
            ContextUtils.EntityPlayerContext context = new ContextUtils.EntityPlayerContext(player, (Entity)this);
            EntityJSHelperClass.consumerCallback(this.builder.playerTouch, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: playerTouch.");
        } else {
            super.playerTouch(player);
        }
    }

    public void onRemovedFromLevel() {
        if (this.builder != null && this.builder.onRemovedFromWorld != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onRemovedFromWorld, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onRemovedFromWorld.");
        }
        super.onRemovedFromLevel();
    }

    public void thunderHit(ServerLevel p_19927_, LightningBolt p_19928_) {
        if (this.builder != null && this.builder.thunderHit != null) {
            super.thunderHit(p_19927_, p_19928_);
            ContextUtils.EThunderHitContext context = new ContextUtils.EThunderHitContext(p_19927_, p_19928_, (Entity)this);
            EntityJSHelperClass.consumerCallback(this.builder.thunderHit, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: thunderHit.");
        }
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, DamageSource pSource) {
        if (this.builder != null && this.builder.onFall != null) {
            ContextUtils.EEntityFallDamageContext context = new ContextUtils.EEntityFallDamageContext((Entity)this, pMultiplier, pFallDistance, pSource);
            EntityJSHelperClass.consumerCallback(this.builder.onFall, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onLivingFall.");
        }
        return super.causeFallDamage(pFallDistance, pMultiplier, pSource);
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.builder != null && this.builder.onAddedToWorld != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onAddedToWorld, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onAddedToWorld.");
        }
    }

    public void setSprinting(boolean sprinting) {
        if (this.builder != null && this.builder.onSprint != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onSprint, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onSprint.");
        }
        super.setSprinting(sprinting);
    }

    public void stopRiding() {
        if (this.builder != null && this.builder.onStopRiding != null && this.isPassenger()) {
            EntityJSHelperClass.consumerCallback(this.builder.onStopRiding, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onStopRiding.");
        }
        super.stopRiding();
    }

    protected void removePassenger(Entity p_20352_) {
        if (this.builder.onRemovePassenger != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onRemovePassenger, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onRemovePassenger.");
        }
        super.removePassenger(p_20352_);
    }

    public void rideTick() {
        super.rideTick();
        if (this.builder != null && this.builder.rideTick != null) {
            EntityJSHelperClass.consumerCallback(this.builder.rideTick, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: rideTick.");
        }
    }

    public void onClientRemoval() {
        if (this.builder != null && this.builder.onClientRemoval != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onClientRemoval, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onClientRemoval.");
        }
        super.onClientRemoval();
    }

    public void lavaHurt() {
        if (this.builder != null && this.builder.lavaHurt != null) {
            EntityJSHelperClass.consumerCallback(this.builder.lavaHurt, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: lavaHurt.");
        }
        super.lavaHurt();
    }

    protected void onFlap() {
        if (this.builder != null && this.builder.onFlap != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onFlap, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onFlap.");
        }
        super.onFlap();
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        if (this.builder.shouldRenderAtSqrDistance != null) {
            ContextUtils.EntitySqrDistanceContext context = new ContextUtils.EntitySqrDistanceContext(distance, (Entity)this);
            Boolean obj = this.builder.shouldRenderAtSqrDistance.test(context);
            if (obj instanceof Boolean) {
                Boolean b = obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid shouldRenderAtSqrDistance for builder: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to super method: " + super.shouldRenderAtSqrDistance(distance));
        }
        return super.shouldRenderAtSqrDistance(distance);
    }

    public boolean isAttackable() {
        return this.builder.isAttackable != null ? this.builder.isAttackable.booleanValue() : super.isAttackable();
    }

    public boolean isPushable() {
        return true;
    }

    public void push(Entity pEntity) {
        if (this.builder.onEntityCollision != null) {
            ContextUtils.CollidingProjectileEntityContext context = new ContextUtils.CollidingProjectileEntityContext((Entity)this, pEntity);
            EntityJSHelperClass.consumerCallback(this.builder.onEntityCollision, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onEntityCollision.");
        }
        if (this.builder.isPushable) {
            super.push(pEntity);
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (this.builder != null && this.builder.onHitBlock != null) {
            ContextUtils.ProjectileBlockHitContext context = new ContextUtils.ProjectileBlockHitContext(result, (Projectile)this);
            EntityJSHelperClass.consumerCallback(this.builder.onHitBlock, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onHitBlock.");
        }
    }

    protected boolean canHitEntity(Entity entity) {
        if (this.builder != null && this.builder.canHitEntity != null) {
            Boolean obj = this.builder.canHitEntity.test(entity);
            if (obj instanceof Boolean) {
                Boolean b = obj;
                return super.canHitEntity(entity) && b != false;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid canHitEntity for arrow builder: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to super method: " + super.canHitEntity(entity));
        }
        return super.canHitEntity(entity);
    }

    public LivingEntity getControllingPassenger() {
        LivingEntity entity;
        Entity var2 = this.getFirstPassenger();
        LivingEntity var10000 = var2 instanceof LivingEntity ? (entity = (LivingEntity)var2) : null;
        return var10000;
    }

    public boolean canCollideWith(Entity pEntity) {
        if (this.builder.canCollideWith != null) {
            ContextUtils.ECollidingEntityContext context = new ContextUtils.ECollidingEntityContext((Entity)this, pEntity);
            Boolean obj = this.builder.canCollideWith.test(context);
            if (obj instanceof Boolean) {
                Boolean b = obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canCollideWith from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canCollideWith(pEntity));
        }
        return super.canCollideWith(pEntity);
    }

    protected float getBlockJumpFactor() {
        if (this.builder.setBlockJumpFactor == null) {
            return super.getBlockJumpFactor();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setBlockJumpFactor.apply(this), "float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setBlockJumpFactor from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.setBlockJumpFactor.apply(this)) + ". Must be a float. Defaulting to " + super.getBlockJumpFactor());
        return super.getBlockJumpFactor();
    }

    protected float getBlockSpeedFactor() {
        if (this.builder.blockSpeedFactor == null) {
            return super.getBlockSpeedFactor();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.blockSpeedFactor.apply(this), "float");
        if (this.builder.blockSpeedFactor == null) {
            return super.getBlockSpeedFactor();
        }
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for blockSpeedFactor from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.blockSpeedFactor.apply(this)) + ". Must be a float, defaulting to " + super.getBlockSpeedFactor());
        return super.getBlockSpeedFactor();
    }

    protected void positionRider(Entity pPassenger, Entity.MoveFunction pCallback) {
        if (this.builder.positionRider != null) {
            ContextUtils.PositionRiderContext context = new ContextUtils.PositionRiderContext((Entity)this, pPassenger, pCallback);
            EntityJSHelperClass.consumerCallback(this.builder.positionRider, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: positionRider.");
            return;
        }
        super.positionRider(pPassenger, pCallback);
    }

    protected boolean canAddPassenger(@NotNull Entity entity) {
        if (this.builder.canAddPassenger == null) {
            return super.canAddPassenger(entity);
        }
        ContextUtils.EPassengerEntityContext context = new ContextUtils.EPassengerEntityContext(entity, (Entity)this);
        Boolean obj = this.builder.canAddPassenger.test(context);
        if (obj instanceof Boolean) {
            return obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canAddPassenger from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean, defaulting to " + super.canAddPassenger(entity));
        return super.canAddPassenger(entity);
    }

    protected boolean isFlapping() {
        if (this.builder.isFlapping != null) {
            Boolean obj = this.builder.isFlapping.test(this);
            if (obj instanceof Boolean) {
                return obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFlapping from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isFlapping());
        }
        return super.isFlapping();
    }

    protected boolean repositionEntityAfterLoad() {
        return Objects.requireNonNullElseGet(this.builder.repositionEntityAfterLoad, () -> super.repositionEntityAfterLoad());
    }

    protected float nextStep() {
        if (this.builder.nextStep != null) {
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.nextStep.apply(this), "float");
            if (obj != null) {
                return ((Float)obj).floatValue();
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for nextStep from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.nextStep.apply(this)) + ". Must be a float, defaulting to " + super.nextStep());
        }
        return super.nextStep();
    }

    protected SoundEvent getSwimSplashSound() {
        if (this.builder.setSwimSplashSound == null) {
            return super.getSwimSplashSound();
        }
        return Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)this.builder.setSwimSplashSound));
    }

    protected SoundEvent getSwimSound() {
        if (this.builder.setSwimSound == null) {
            return super.getSwimSound();
        }
        return Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)this.builder.setSwimSound));
    }

    public boolean canFreeze() {
        if (this.builder.canFreeze != null) {
            Boolean obj = this.builder.canFreeze.test(this);
            if (obj instanceof Boolean) {
                return obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canFreeze from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canFreeze());
        }
        return super.canFreeze();
    }

    public boolean isFreezing() {
        if (this.builder.isFreezing != null) {
            Boolean obj = this.builder.isFreezing.test(this);
            if (obj instanceof Boolean) {
                return obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFreezing from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isFreezing());
        }
        return super.isFreezing();
    }

    public boolean isCurrentlyGlowing() {
        if (this.builder.isCurrentlyGlowing != null) {
            Boolean obj = this.builder.isCurrentlyGlowing.test(this);
            if (obj instanceof Boolean) {
                return obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isCurrentlyGlowing from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isCurrentlyGlowing());
        }
        return super.isCurrentlyGlowing();
    }

    public boolean dampensVibrations() {
        if (this.builder.dampensVibrations != null) {
            Boolean obj = this.builder.dampensVibrations.test(this);
            if (obj instanceof Boolean) {
                return obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for dampensVibrations from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.dampensVibrations());
        }
        return super.dampensVibrations();
    }

    public boolean showVehicleHealth() {
        if (this.builder.showVehicleHealth != null) {
            Boolean obj = this.builder.showVehicleHealth.test(this);
            if (obj instanceof Boolean) {
                return obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for showVehicleHealth from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.showVehicleHealth());
        }
        return super.showVehicleHealth();
    }

    public boolean isInvulnerableTo(DamageSource p_20122_) {
        if (this.builder.isInvulnerableTo != null) {
            ContextUtils.EDamageContext context = new ContextUtils.EDamageContext((Entity)this, p_20122_);
            Boolean obj = this.builder.isInvulnerableTo.test(context);
            if (obj instanceof Boolean) {
                return obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isInvulnerableTo from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isInvulnerableTo(p_20122_));
        }
        return super.isInvulnerableTo(p_20122_);
    }

    public boolean canChangeDimensions(Level to, Level from) {
        if (this.builder.canChangeDimensions != null) {
            ContextUtils.ChangeDimensionsContext context = new ContextUtils.ChangeDimensionsContext((Entity)this, to, from);
            Boolean obj = this.builder.canChangeDimensions.test(context);
            if (obj instanceof Boolean) {
                return obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canChangeDimensions from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canChangeDimensions(to, from));
        }
        return super.canChangeDimensions(to, from);
    }

    public boolean mayInteract(@NotNull Level p_146843_, @NotNull BlockPos p_146844_) {
        if (this.builder.mayInteract != null) {
            ContextUtils.EMayInteractContext context = new ContextUtils.EMayInteractContext(p_146843_, p_146844_, (Entity)this);
            Boolean obj = this.builder.mayInteract.test(context);
            if (obj instanceof Boolean) {
                return obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for mayInteract from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.mayInteract(p_146843_, p_146844_));
        }
        return super.mayInteract(p_146843_, p_146844_);
    }

    public boolean canTrample(@NotNull BlockState state, @NotNull BlockPos pos, float fallDistance) {
        if (this.builder.canTrample != null) {
            ContextUtils.ECanTrampleContext context = new ContextUtils.ECanTrampleContext(state, pos, fallDistance, (Entity)this);
            Boolean obj = this.builder.canTrample.test(context);
            if (obj instanceof Boolean) {
                return obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canTrample from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canTrample(state, pos, fallDistance));
        }
        return super.canTrample(state, pos, fallDistance);
    }

    public int getMaxFallDistance() {
        if (this.builder.setMaxFallDistance == null) {
            return super.getMaxFallDistance();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setMaxFallDistance.apply(this), "integer");
        if (obj != null) {
            return (Integer)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setMaxFallDistance from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.setMaxFallDistance.apply(this)) + ". Must be an integer. Defaulting to " + super.getMaxFallDistance());
        return super.getMaxFallDistance();
    }

    public boolean canBeCollidedWith() {
        if (this.builder.canBeCollidedWith == null) {
            return super.canBeCollidedWith();
        }
        Boolean obj = this.builder.canBeCollidedWith.test(this);
        if (obj instanceof Boolean) {
            return obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canBeCollidedWith from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canBeCollidedWith());
        return super.canBeCollidedWith();
    }
}

