/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.latvian.mods.kubejs.typings.Info;
import net.liopyu.entityjs.builders.nonliving.entityjs.PartBuilder;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;

public class ContextUtils {

    public static class EMayInteractContext {
        @Info(value="The level where the interaction may occur")
        public final Level level;
        @Info(value="The position where the interaction may occur")
        public final BlockPos pos;
        @Info(value="The entity involved in the interaction")
        public final Entity entity;

        public EMayInteractContext(Level level, BlockPos pos, Entity entity) {
            this.level = level;
            this.pos = pos;
            this.entity = entity;
        }
    }

    public static class EEntityFallDamageContext {
        @Info(value="The entity experiencing fall damage")
        public final Entity entity;
        @Info(value="The distance fallen by the living entity")
        public final float distance;
        @Info(value="The multiplier applied to calculate fall damage")
        public final float damageMultiplier;
        @Info(value="The source of the fall damage")
        public final DamageSource damageSource;

        public EEntityFallDamageContext(Entity entity, float damageMultiplier, float distance, DamageSource damageSource) {
            this.entity = entity;
            this.distance = distance;
            this.damageMultiplier = damageMultiplier;
            this.damageSource = damageSource;
        }
    }

    public static class EThunderHitContext {
        @Info(value="The server level where the lightning strike occurred")
        public final ServerLevel level;
        @Info(value="The lightning bolt that struck")
        public final LightningBolt lightningBolt;
        @Info(value="The entity affected by the lightning strike")
        public final Entity entity;

        public EThunderHitContext(ServerLevel level, LightningBolt lightningBolt, Entity entity) {
            this.level = level;
            this.lightningBolt = lightningBolt;
            this.entity = entity;
        }
    }

    public static class EDamageContext {
        @Info(value="The entity that is the target of the damage")
        public final Entity entity;
        @Info(value="The source of the damage")
        public final DamageSource damageSource;

        public EDamageContext(Entity entity, DamageSource damageSource) {
            this.entity = entity;
            this.damageSource = damageSource;
        }
    }

    public static class ECanTrampleContext {
        @Info(value="The block state at the position")
        public final BlockState state;
        @Info(value="The position of the block being considered for trampling")
        public final BlockPos pos;
        @Info(value="The distance fallen before trampling (if applicable)")
        public final float fallDistance;
        @Info(value="The entity attempting to trample the block")
        public final Entity entity;

        public ECanTrampleContext(BlockState state, BlockPos pos, float fallDistance, Entity entity) {
            this.state = state;
            this.pos = pos;
            this.fallDistance = fallDistance;
            this.entity = entity;
        }
    }

    public static class ECollidingEntityContext {
        @Info(value="The entity getting collided with")
        public final Entity entity;
        @Info(value="The entity colliding")
        public final Entity collidingEntity;

        public ECollidingEntityContext(Entity entity, Entity collidingEntity) {
            this.entity = entity;
            this.collidingEntity = collidingEntity;
        }
    }

    public static class EPassengerEntityContext {
        public final Entity passenger;
        public final Entity entity;

        public EPassengerEntityContext(Entity passenger, Entity entity) {
            this.passenger = passenger;
            this.entity = entity;
        }
    }

    public static class NLRenderContext<T extends Entity> {
        @Info(value="The animatable entity being rendered")
        public final T entity;
        @Info(value="The yaw of the entity")
        public final float entityYaw;
        @Info(value="The partial tick")
        public final float partialTick;
        @Info(value="The pose stack for transformations")
        public final PoseStack poseStack;
        @Info(value="The buffer source for rendering")
        public final MultiBufferSource bufferSource;
        @Info(value="The packed light information")
        public final int packedLight;

        public NLRenderContext(T entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
            this.entity = entity;
            this.entityYaw = entityYaw;
            this.partialTick = partialTick;
            this.poseStack = poseStack;
            this.bufferSource = bufferSource;
            this.packedLight = packedLight;
        }
    }

    public static class RenderContext<T extends LivingEntity> {
        public final GeoEntityRenderer<T> renderer;
        @Info(value="The animatable entity being rendered")
        public final T entity;
        @Info(value="The yaw of the entity")
        public final float entityYaw;
        @Info(value="The partial tick")
        public final float partialTick;
        @Info(value="The pose stack for transformations")
        public final PoseStack poseStack;
        @Info(value="The buffer source for rendering")
        public final MultiBufferSource bufferSource;
        @Info(value="The packed light information")
        public final int packedLight;

        public RenderContext(GeoEntityRenderer<T> renderer, T entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
            this.renderer = renderer;
            this.entity = entity;
            this.entityYaw = entityYaw;
            this.partialTick = partialTick;
            this.poseStack = poseStack;
            this.bufferSource = bufferSource;
            this.packedLight = packedLight;
        }
    }

    public static class ArrowPlayerContext {
        @Info(value="The abstract arrow entity")
        public final AbstractArrow entity;
        @Info(value="The player")
        public final Player player;

        public ArrowPlayerContext(Player player, AbstractArrow entity) {
            this.entity = entity;
            this.player = player;
        }
    }

    public static class ArrowBlockHitContext {
        @Info(value="The abstract arrow entity")
        public final AbstractArrow entity;
        @Info(value="The result of the hit on the block")
        public final BlockHitResult result;

        public ArrowBlockHitContext(BlockHitResult result, AbstractArrow entity) {
            this.entity = entity;
            this.result = result;
        }
    }

    public static class ArrowEntityHitContext {
        @Info(value="The abstract arrow entity")
        public final AbstractArrow entity;
        @Info(value="The result of the hit on the entity")
        public final EntityHitResult result;

        public ArrowEntityHitContext(EntityHitResult result, AbstractArrow entity) {
            this.entity = entity;
            this.result = result;
        }
    }

    public static class ProjectileBlockHitContext {
        @Info(value="The throwable item projectile that hit the block")
        public final Projectile entity;
        @Info(value="The result of the hit on the block")
        public final BlockHitResult result;

        public ProjectileBlockHitContext(BlockHitResult result, Projectile entity) {
            this.entity = entity;
            this.result = result;
        }
    }

    public static class ProjectileEntityHitContext {
        @Info(value="The projectile that was thrown")
        public final Projectile entity;
        @Info(value="The result of the hit")
        public final EntityHitResult result;

        public ProjectileEntityHitContext(EntityHitResult result, Projectile entity) {
            this.entity = entity;
            this.result = result;
        }
    }

    public static class EntityPlayerContext {
        @Info(value="The entity")
        public final Entity entity;
        @Info(value="The player")
        public final Player player;

        public EntityPlayerContext(Player player, Entity entity) {
            this.entity = entity;
            this.player = player;
        }
    }

    public static class EntityBlockPosLevelContext {
        @Info(value="The block position")
        public final BlockPos pos;
        @Info(value="The level reader")
        public final LevelReader levelReader;
        @Info(value="The living entity")
        public final LivingEntity entity;

        public EntityBlockPosLevelContext(BlockPos pos, LevelReader levelReader, LivingEntity entity) {
            this.pos = pos;
            this.levelReader = levelReader;
            this.entity = entity;
        }
    }

    public static class Vec3Context {
        @Info(value="The Travel Vector of the entity.")
        public final Vec3 vec3;
        @Info(value="The entity undergoing movement")
        public final LivingEntity entity;

        public Vec3Context(Vec3 vec3, LivingEntity entity) {
            this.vec3 = vec3;
            this.entity = entity;
        }
    }

    public static class MovementContext {
        @Info(value="The type of mover responsible for the movement")
        public final MoverType moverType;
        @Info(value="The position to which the entity is moving")
        public final Vec3 position;
        @Info(value="The entity undergoing movement")
        public final Entity entity;

        public MovementContext(MoverType moverType, Vec3 position, Entity entity) {
            this.moverType = moverType;
            this.position = position;
            this.entity = entity;
        }
    }

    public static class EntitySqrDistanceContext {
        @Info(value="The squared distance to the player")
        public final double distanceToPlayer;
        @Info(value="The entity")
        public final Entity entity;

        public EntitySqrDistanceContext(double distanceToPlayer, Entity entity) {
            this.distanceToPlayer = distanceToPlayer;
            this.entity = entity;
        }
    }

    public static class EntityDistanceToPlayerContext {
        @Info(value="The distance to the closest player")
        public final double distanceToClosestPlayer;
        @Info(value="The living entity")
        public final LivingEntity entity;

        public EntityDistanceToPlayerContext(double distanceToClosestPlayer, LivingEntity entity) {
            this.distanceToClosestPlayer = distanceToClosestPlayer;
            this.entity = entity;
        }
    }

    public static class LevelAnimalContext {
        @Info(value="The main animal entity")
        public final Animal entity;
        @Info(value="The mate animal entity")
        public final Animal mate;
        @Info(value="The server level where the animals reside")
        public final ServerLevel level;

        public LevelAnimalContext(Animal mate, Animal entity, ServerLevel level) {
            this.entity = entity;
            this.mate = mate;
            this.level = level;
        }
    }

    public static class LerpToContext {
        @Info(value="The target x-coordinate for lerping")
        public final double x;
        @Info(value="The target y-coordinate for lerping")
        public final double y;
        @Info(value="The target z-coordinate for lerping")
        public final double z;
        @Info(value="The target yaw for lerping")
        public final float yaw;
        @Info(value="The target pitch for lerping")
        public final float pitch;
        @Info(value="The number of position rotation increments")
        public final int posRotationIncrements;
        @Info(value="The entity to lerp")
        public final Entity entity;

        public LerpToContext(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, Entity entity) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.yaw = yaw;
            this.pitch = pitch;
            this.posRotationIncrements = posRotationIncrements;
            this.entity = entity;
        }
    }

    public static class VisualContext {
        @Info(value="The looking entity")
        public final Entity lookingEntity;
        @Info(value="Our entity which is looked at")
        public final LivingEntity entity;

        public VisualContext(Entity lookingEntity, LivingEntity entity) {
            this.lookingEntity = lookingEntity;
            this.entity = entity;
        }
    }

    public static class LineOfSightContext {
        @Info(value="The target entity")
        public final Entity targetEntity;
        @Info(value="The living entity associated with the target entity")
        public final LivingEntity entity;

        public LineOfSightContext(Entity targetEntity, LivingEntity entity) {
            this.targetEntity = targetEntity;
            this.entity = entity;
        }
    }

    public static class EntityAnimalContext {
        @Info(value="The main animal entity")
        public final Animal animal;
        @Info(value="The other animal entity")
        public final Animal otherAnimal;

        public EntityAnimalContext(Animal animal, Animal otherAnimal) {
            this.animal = animal;
            this.otherAnimal = otherAnimal;
        }
    }

    public static class EntityBlockPathTypeContext {
        @Info(value="The type of block pathfinding being considered")
        public final PathType blockPathType;
        @Info(value="The living entity associated with the block path type")
        public final LivingEntity entity;

        public EntityBlockPathTypeContext(PathType blockPathType, LivingEntity entity) {
            this.blockPathType = blockPathType;
            this.entity = entity;
        }
    }

    public static class EntityProjectileWeaponContext {
        @Info(value="The projectile weapon being used")
        public final ProjectileWeaponItem projectileWeapon;
        @Info(value="The living entity using the projectile weapon")
        public final LivingEntity entity;

        public EntityProjectileWeaponContext(ProjectileWeaponItem projectileWeapon, LivingEntity entity) {
            this.projectileWeapon = projectileWeapon;
            this.entity = entity;
        }
    }

    public static class EntityPoseDimensionsContext {
        @Info(value="The pose of the living entity")
        public final Pose pose;
        @Info(value="The dimensions of the living entity")
        public final EntityDimensions dimensions;
        @Info(value="The living entity associated with the pose and dimensions")
        public final LivingEntity entity;

        public EntityPoseDimensionsContext(Pose pose, EntityDimensions dimensions, LivingEntity entity) {
            this.pose = pose;
            this.dimensions = dimensions;
            this.entity = entity;
        }
    }

    public static class EntityEquipmentContext {
        @Info(value="The equipment slot being modified")
        public final EquipmentSlot slot;
        @Info(value="The item stack previously in the equipment slot")
        public final ItemStack previousStack;
        @Info(value="The item stack currently in the equipment slot")
        public final ItemStack currentStack;
        @Info(value="The living entity associated with the equipment change")
        public final LivingEntity entity;

        public EntityEquipmentContext(EquipmentSlot slot, ItemStack previousStack, ItemStack currentStack, LivingEntity entity) {
            this.slot = slot;
            this.previousStack = previousStack;
            this.currentStack = currentStack;
            this.entity = entity;
        }
    }

    public static class EntityLootContext {
        @Info(value="The source of the damage causing the loot")
        public final DamageSource damageSource;
        @Info(value="The server level")
        public final ServerLevel serverLevel;
        @Info(value="Whether the entity was hit by a player or not")
        public final boolean hitByPlayer;
        @Info(value="The living entity involved")
        public final LivingEntity entity;

        public EntityLootContext(ServerLevel serverLevel, DamageSource damageSource, boolean hitByPlayer, LivingEntity entity) {
            this.damageSource = damageSource;
            this.serverLevel = serverLevel;
            this.hitByPlayer = hitByPlayer;
            this.entity = entity;
        }
    }

    public static class EntityFallDamageContext {
        @Info(value="The living entity experiencing fall damage")
        public final LivingEntity entity;
        @Info(value="The distance fallen by the living entity")
        public final float distance;
        @Info(value="The multiplier applied to calculate fall damage")
        public final float damageMultiplier;
        @Info(value="The source of the fall damage")
        public final DamageSource damageSource;

        public EntityFallDamageContext(LivingEntity entity, float damageMultiplier, float distance, DamageSource damageSource) {
            this.entity = entity;
            this.distance = distance;
            this.damageMultiplier = damageMultiplier;
            this.damageSource = damageSource;
        }
    }

    public static class EntityFluidStateContext {
        @Info(value="The living entity")
        public final LivingEntity entity;
        @Info(value="The fluid state associated with the living entity")
        public final FluidState fluidState;

        public EntityFluidStateContext(LivingEntity entity, FluidState fluidState) {
            this.entity = entity;
            this.fluidState = fluidState;
        }
    }

    public static class EntityTypeEntityContext {
        @Info(value="The living entity")
        public final LivingEntity entity;
        @Info(value="The target entity type")
        public final EntityType<?> targetType;

        public EntityTypeEntityContext(LivingEntity entity, EntityType<?> targetType) {
            this.entity = entity;
            this.targetType = targetType;
        }
    }

    public static class EntityItemEntityContext {
        @Info(value="The living entity involved")
        public final LivingEntity entity;
        @Info(value="The item entity associated with the living entity")
        public final ItemEntity itemEntity;

        public EntityItemEntityContext(LivingEntity entity, ItemEntity itemEntity) {
            this.entity = entity;
            this.itemEntity = itemEntity;
        }
    }

    public static class EntityHealContext {
        @Info(value="The living entity being healed")
        public final LivingEntity entity;
        @Info(value="The amount of healing applied to the living entity")
        public final float healAmount;

        public EntityHealContext(LivingEntity entity, float healAmount) {
            this.entity = entity;
            this.healAmount = healAmount;
        }
    }

    public static class EntityItemStackContext {
        @Info(value="The item stack")
        public final ItemStack item;
        @Info(value="The living entity")
        public final LivingEntity entity;

        public EntityItemStackContext(ItemStack item, LivingEntity entity) {
            this.item = item;
            this.entity = entity;
        }
    }

    public static class CalculateFallDamageContext {
        @Info(value="The height from which the entity is falling")
        public final float fallHeight;
        @Info(value="The multiplier applied to calculate fall damage")
        public final float damageMultiplier;
        @Info(value="The living entity experiencing fall damage calculation")
        public final LivingEntity entity;

        public CalculateFallDamageContext(float fallHeight, float damageMultiplier, LivingEntity entity) {
            this.fallHeight = fallHeight;
            this.damageMultiplier = damageMultiplier;
            this.entity = entity;
        }
    }

    public static class AutoAttackContext {
        @Info(value="The target entity that is being attacked")
        public final LivingEntity target;
        @Info(value="The attacking entity")
        public final LivingEntity entity;

        public AutoAttackContext(LivingEntity target, LivingEntity entity) {
            this.target = target;
            this.entity = entity;
        }
    }

    public static class TargetChangeContext {
        @Info(value="The new target entity")
        public final LivingEntity target;
        @Info(value="The entity whose target is changing")
        public final Mob entity;

        public TargetChangeContext(LivingEntity target, Mob entity) {
            this.target = target;
            this.entity = entity;
        }
    }

    public static class ThunderHitContext {
        @Info(value="The server level where the lightning strike occurred")
        public final ServerLevel level;
        @Info(value="The lightning bolt that struck")
        public final LightningBolt lightningBolt;
        @Info(value="The living entity affected by the lightning strike")
        public final LivingEntity entity;

        public ThunderHitContext(ServerLevel level, LightningBolt lightningBolt, LivingEntity entity) {
            this.level = level;
            this.lightningBolt = lightningBolt;
            this.entity = entity;
        }
    }

    public static class EntityServerLevelContext {
        @Info(value="The server level of the entity")
        public final ServerLevel level;
        @Info(value="The living entity")
        public final LivingEntity entity;

        public EntityServerLevelContext(ServerLevel level, LivingEntity entity) {
            this.level = level;
            this.entity = entity;
        }
    }

    public static class ArrowLivingEntityContext {
        @Info(value="The living entity hit by the arrow.")
        public final LivingEntity entity;
        @Info(value="The arrow being fired.")
        public final AbstractArrow arrow;

        public ArrowLivingEntityContext(AbstractArrow arrow, LivingEntity entity) {
            this.entity = entity;
            this.arrow = arrow;
        }
    }

    public static class OnEffectContext {
        @Info(value="The living entity affected by the mob effect")
        public final LivingEntity entity;
        @Info(value="The mob effect instance applied to the living entity")
        public final MobEffectInstance effect;

        public OnEffectContext(MobEffectInstance effect, LivingEntity entity) {
            this.entity = entity;
            this.effect = effect;
        }
    }

    public static class MobInteractContext {
        @Info(value="The living entity being interacted with")
        public final LivingEntity entity;
        @Info(value="The player interacting with the living entity")
        public final Player player;
        @Info(value="The hand used for interaction")
        public final InteractionHand hand;

        public MobInteractContext(LivingEntity entity, Player player, InteractionHand hand) {
            this.entity = entity;
            this.player = player;
            this.hand = hand;
        }
    }

    public static class EntityInteractContext {
        @Info(value="The entity being interacted with")
        public final Entity entity;
        @Info(value="The player interacting with the entity")
        public final Player player;
        @Info(value="The hand used for interaction")
        public final InteractionHand hand;

        public EntityInteractContext(Entity entity, Player player, InteractionHand hand) {
            this.entity = entity;
            this.player = player;
            this.hand = hand;
        }
    }

    public static class ItemUseContext {
        @Info(value="The level of the entity using the item")
        public final Level level;
        @Info(value="The player interacting with the item")
        public final Player player;
        @Info(value="The hand used for interaction")
        public final InteractionHand hand;

        public ItemUseContext(Level level, Player player, InteractionHand hand) {
            this.level = level;
            this.player = player;
            this.hand = hand;
        }
    }

    public static class CanTrampleContext {
        @Info(value="The block state at the position")
        public final BlockState state;
        @Info(value="The position of the block being considered for trampling")
        public final BlockPos pos;
        @Info(value="The distance fallen before trampling (if applicable)")
        public final float fallDistance;
        @Info(value="The living entity attempting to trample the block")
        public final LivingEntity entity;

        public CanTrampleContext(BlockState state, BlockPos pos, float fallDistance, LivingEntity entity) {
            this.state = state;
            this.pos = pos;
            this.fallDistance = fallDistance;
            this.entity = entity;
        }
    }

    public static class MayInteractContext {
        @Info(value="The level where the interaction may occur")
        public final Level level;
        @Info(value="The position where the interaction may occur")
        public final BlockPos pos;
        @Info(value="The living entity involved in the interaction")
        public final LivingEntity entity;

        public MayInteractContext(Level level, BlockPos pos, LivingEntity entity) {
            this.level = level;
            this.pos = pos;
            this.entity = entity;
        }
    }

    public static class EntityDamageContext {
        @Info(value="The source of the damage")
        public final DamageSource damageSource;
        @Info(value="The amount of damage inflicted")
        public final float damageAmount;
        @Info(value="The living entity receiving the damage")
        public final LivingEntity entity;

        public EntityDamageContext(DamageSource damageSource, float damageAmount, LivingEntity entity) {
            this.damageSource = damageSource;
            this.damageAmount = damageAmount;
            this.entity = entity;
        }
    }

    public static class PartHurtContext<T extends LivingEntity> {
        @Info(value="The part of the entity that was hurt")
        public final PartEntity<T> part;
        @Info(value="The source of the damage")
        public final DamageSource source;
        @Info(value="The source of the damage")
        public final float amount;
        @Info(value="The parent of the part entity")
        public final LivingEntity entity;

        public PartHurtContext(PartEntity<T> part, DamageSource source, float amount, LivingEntity entity) {
            this.part = part;
            this.source = source;
            this.amount = amount;
            this.entity = entity;
        }
    }

    public static class EntityHurtContext {
        @Info(value="The entity that was hurt")
        public final Entity entity;
        @Info(value="The source of the damage")
        public final DamageSource damageSource;
        @Info(value="The source of the damage")
        public final float damageAmount;

        public EntityHurtContext(Entity entity, DamageSource damageSource, float damageAmount) {
            this.entity = entity;
            this.damageSource = damageSource;
            this.damageAmount = damageAmount;
        }
    }

    public static class HurtContext {
        @Info(value="The living entity that was hurt")
        public final LivingEntity entity;
        @Info(value="The source of the damage")
        public final DamageSource damageSource;

        public HurtContext(LivingEntity entity, DamageSource damageSource) {
            this.entity = entity;
            this.damageSource = damageSource;
        }
    }

    public static class DeathContext {
        @Info(value="The living entity that has died")
        public final LivingEntity entity;
        @Info(value="The source of the damage causing the death")
        public final DamageSource damageSource;

        public DeathContext(LivingEntity entity, DamageSource damageSource) {
            this.entity = entity;
            this.damageSource = damageSource;
        }
    }

    public static class DamageContext {
        @Info(value="The living entity that is the target of the damage")
        public final LivingEntity entity;
        @Info(value="The source of the damage")
        public final DamageSource damageSource;

        public DamageContext(LivingEntity entity, DamageSource damageSource) {
            this.entity = entity;
            this.damageSource = damageSource;
        }
    }

    public static class FoodItemLevelContext {
        @Info(value="The living entity")
        public final LivingEntity entity;
        @Info(value="The item stack")
        public final ItemStack itemStack;
        @Info(value="The level")
        public final Level level;
        @Info(value="The food properties of the itemStack being eaten")
        public final FoodProperties foodProperties;

        public FoodItemLevelContext(LivingEntity entity, ItemStack itemStack, Level level, FoodProperties properties) {
            this.entity = entity;
            this.itemStack = itemStack;
            this.level = level;
            this.foodProperties = properties;
        }
    }

    public static class EntityItemLevelContext {
        @Info(value="The living entity")
        public final LivingEntity entity;
        @Info(value="The item stack")
        public final ItemStack itemStack;
        @Info(value="The level")
        public final Level level;

        public EntityItemLevelContext(LivingEntity entity, ItemStack itemStack, Level level) {
            this.entity = entity;
            this.itemStack = itemStack;
            this.level = level;
        }
    }

    public static class LivingEntityContext {
        public final LivingEntity entity;
        public final LivingEntity target;

        public LivingEntityContext(LivingEntity entity, LivingEntity target) {
            this.entity = entity;
            this.target = target;
        }
    }

    public static class PassengerEntityContext {
        public final Entity passenger;
        public final LivingEntity entity;

        public PassengerEntityContext(Entity passenger, LivingEntity entity) {
            this.passenger = passenger;
            this.entity = entity;
        }
    }

    public static class EntityBlockPosContext {
        @Info(value="The living entity")
        public final LivingEntity entity;
        @Info(value="The block position")
        public final BlockPos blockPos;

        public EntityBlockPosContext(LivingEntity entity, BlockPos blockPos) {
            this.entity = entity;
            this.blockPos = blockPos;
        }
    }

    public static class BreedableEntityContext {
        @Info(value="The entity who mated.")
        public final AgeableMob entity;
        @Info(value="The other parent the entity mated with.")
        public final AgeableMob mate;
        @Info(value="The Server Level")
        public final ServerLevel level;

        public BreedableEntityContext(AgeableMob entity, AgeableMob mate, ServerLevel level) {
            this.entity = entity;
            this.mate = mate;
            this.level = level;
        }
    }

    public static class CollidingEntityContext {
        @Info(value="The entity getting collided with")
        public final LivingEntity entity;
        @Info(value="The entity colliding")
        public final Entity collidingEntity;

        public CollidingEntityContext(LivingEntity entity, Entity collidingEntity) {
            this.entity = entity;
            this.collidingEntity = collidingEntity;
        }
    }

    public static class CollidingProjectileEntityContext {
        @Info(value="The colliding entity")
        public final Entity entity;
        @Info(value="The the target being collided with")
        public final Entity target;

        public CollidingProjectileEntityContext(Entity entity, Entity target) {
            this.entity = entity;
            this.target = target;
        }
    }

    public static class EntityLevelContext {
        @Info(value="The living entity")
        public final LivingEntity entity;
        @Info(value="The level")
        public final Level level;

        public EntityLevelContext(Level level, LivingEntity entity) {
            this.entity = entity;
            this.level = level;
        }
    }

    public static class PlayerEntityContext {
        @Info(value="The living entity associated with the player")
        public final LivingEntity entity;
        @Info(value="The player entity")
        public final Player player;

        public PlayerEntityContext(Player player, LivingEntity entity) {
            this.entity = entity;
            this.player = player;
        }
    }

    public static class PartEntityParams<T extends LivingEntity> {
        public final String name;
        public final float width;
        public final float height;
        public final PartBuilder<T> builder;

        public PartEntityParams(String name, float width, float height, PartBuilder<T> builder) {
            this.name = name;
            this.width = width;
            this.height = height;
            this.builder = builder;
        }
    }

    public static class ScaleModelRenderContextNL<T extends Entity> {
        public final float widthScale;
        public final float heightScale;
        public final PoseStack poseStack;
        public final T entity;
        public final BakedGeoModel model;
        public final boolean isReRender;
        public final float partialTick;
        public final int packedLight;
        public final int packedOverlay;

        public ScaleModelRenderContextNL(float widthScale, float heightScale, PoseStack poseStack, T entity, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay) {
            this.widthScale = widthScale;
            this.heightScale = heightScale;
            this.poseStack = poseStack;
            this.entity = entity;
            this.model = model;
            this.isReRender = isReRender;
            this.partialTick = partialTick;
            this.packedLight = packedLight;
            this.packedOverlay = packedOverlay;
        }
    }

    public static class ScaleModelRenderContext {
        public final GeoEntityRenderer renderer;
        public final float widthScale;
        public final float heightScale;
        public final PoseStack poseStack;
        public final LivingEntity entity;
        public final BakedGeoModel model;
        public final boolean isReRender;
        public final float partialTick;
        public final int packedLight;
        public final int packedOverlay;

        public ScaleModelRenderContext(GeoEntityRenderer renderer, float widthScale, float heightScale, PoseStack poseStack, LivingEntity entity, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay) {
            this.renderer = renderer;
            this.widthScale = widthScale;
            this.heightScale = heightScale;
            this.poseStack = poseStack;
            this.entity = entity;
            this.model = model;
            this.isReRender = isReRender;
            this.partialTick = partialTick;
            this.packedLight = packedLight;
            this.packedOverlay = packedOverlay;
        }
    }

    public static class PreRenderContext<T> {
        @Info(value="The PoseStack")
        public final PoseStack poseStack;
        @Info(value="The animatable entity")
        public final T entity;
        @Info(value="The baked model")
        public final BakedGeoModel bakedModel;
        @Info(value="The render type")
        public final RenderType renderType;
        @Info(value="The buffer source")
        public final MultiBufferSource bufferSource;
        @Info(value="The vertex consumer buffer")
        public final VertexConsumer buffer;
        @Info(value="The partial tick")
        public final float partialTick;
        @Info(value="The packed light")
        public final int packedLight;
        @Info(value="The packed overlay")
        public final int packedOverlay;

        public PreRenderContext(PoseStack poseStack, T entity, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
            this.poseStack = poseStack;
            this.entity = entity;
            this.bakedModel = bakedModel;
            this.renderType = renderType;
            this.bufferSource = bufferSource;
            this.buffer = buffer;
            this.partialTick = partialTick;
            this.packedLight = packedLight;
            this.packedOverlay = packedOverlay;
        }
    }

    public static class PositionRiderContext {
        @Info(value="The vehicle entity")
        public final Entity entity;
        @Info(value="The passenger")
        public final Entity passenger;
        @Info(value="The move function")
        public final Entity.MoveFunction moveFunction;

        public PositionRiderContext(Entity entity, Entity passenger, Entity.MoveFunction moveFunction) {
            this.entity = entity;
            this.passenger = passenger;
            this.moveFunction = moveFunction;
        }
    }

    public static class GoalContext {
        @Info(value="The mob entity")
        public final Mob entity;
        @Info(value="The goal from the mob's current goal list")
        public final Goal goal;

        public GoalContext(Mob entity, Goal goal) {
            this.entity = entity;
            this.goal = goal;
        }
    }

    public static class ChangeDimensionsContext {
        public final Entity entity;
        public final Level to;
        public final Level from;

        public ChangeDimensionsContext(Entity entity, Level to, Level from) {
            this.entity = entity;
            this.to = to;
            this.from = from;
        }
    }

    public static class RendererModelContext {
        @Info(value="The entity")
        public final Entity entity;
        @Info(value="The entity's renderer")
        public final EntityRenderer<?> renderer;
        @Info(value="The entity's model")
        public final EntityModel<?> model;

        public RendererModelContext(Entity entity, EntityRenderer<?> renderer, EntityModel<?> model) {
            this.entity = entity;
            this.renderer = renderer;
            this.model = model;
        }
    }

    public static class RotationTowardsContext {
        public final float from;
        public final float to;
        public final float maxDelta;

        public RotationTowardsContext(float from, float to, float maxDelta) {
            this.from = from;
            this.to = to;
            this.maxDelta = maxDelta;
        }
    }

    public static class RotationContext {
        public final double wantedX;
        public final double wantedY;
        public final double wantedZ;
        public final Mob entity;

        public RotationContext(double wantedX, double wantedY, double wantedZ, Mob entity) {
            this.wantedX = wantedX;
            this.wantedY = wantedY;
            this.wantedZ = wantedZ;
            this.entity = entity;
        }
    }

    public static class StrafeContext {
        public final float forward;
        public final float strafe;

        public StrafeContext(float forward, float strafe) {
            this.forward = forward;
            this.strafe = strafe;
        }
    }

    public static class SetWantedPositionContext {
        public final double wantedX;
        public final double wantedY;
        public final double wantedZ;
        public final double speedModifier;

        public SetWantedPositionContext(double wantedX, double wantedY, double wantedZ, double speedModifier) {
            this.wantedX = wantedX;
            this.wantedY = wantedY;
            this.wantedZ = wantedZ;
            this.speedModifier = speedModifier;
        }
    }

    public static class RotLerpContext {
        public final float sourceAngle;
        public final float targetAngle;
        public final float maximumChange;

        public RotLerpContext(float sourceAngle, float targetAngle, float maximumChange) {
            this.sourceAngle = sourceAngle;
            this.targetAngle = targetAngle;
            this.maximumChange = maximumChange;
        }
    }

    public static class IsWalkableContext {
        public final float pRelativeX;
        public final float pRelativeZ;

        public IsWalkableContext(float pRelativeX, float pRelativeZ) {
            this.pRelativeX = pRelativeX;
            this.pRelativeZ = pRelativeZ;
        }
    }

    public static class RenderContextCustom<T extends LivingEntity> {
        @Info(value="The animatable entity being rendered")
        public final T entity;
        @Info(value="The yaw of the entity")
        public final float entityYaw;
        @Info(value="The partial tick")
        public final float partialTick;
        @Info(value="The pose stack for transformations")
        public final PoseStack poseStack;
        @Info(value="The buffer source for rendering")
        public final MultiBufferSource bufferSource;
        @Info(value="The packed light information")
        public final int packedLight;

        public RenderContextCustom(T entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
            this.entity = entity;
            this.entityYaw = entityYaw;
            this.partialTick = partialTick;
            this.poseStack = poseStack;
            this.bufferSource = bufferSource;
            this.packedLight = packedLight;
        }
    }

    public static class FinalRenderContext<T extends LivingEntity> {
        public final GeoEntityRenderer<T> renderer;
        public final PoseStack poseStack;
        public final T entity;
        public final BakedGeoModel model;
        public final MultiBufferSource bufferSource;
        public final VertexConsumer buffer;
        public final float partialTick;
        public final int packedLight;
        public final int packedOverlay;
        public final float colour;

        public FinalRenderContext(GeoEntityRenderer<T> renderer, PoseStack poseStack, T animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, float colour) {
            this.renderer = renderer;
            this.poseStack = poseStack;
            this.entity = animatable;
            this.model = model;
            this.bufferSource = bufferSource;
            this.buffer = buffer;
            this.partialTick = partialTick;
            this.packedLight = packedLight;
            this.packedOverlay = packedOverlay;
            this.colour = colour;
        }
    }

    public static class ApplyRotationsContext<T extends LivingEntity> {
        public final GeoEntityRenderer renderer;
        public final T entity;
        public final PoseStack poseStack;
        public final float ageInTicks;
        public final float rotationYaw;
        public final float partialTick;

        public ApplyRotationsContext(GeoEntityRenderer renderer, T animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick) {
            this.renderer = renderer;
            this.entity = animatable;
            this.poseStack = poseStack;
            this.ageInTicks = ageInTicks;
            this.rotationYaw = rotationYaw;
            this.partialTick = partialTick;
        }
    }

    public static class PassengerVehicleContext {
        public final Entity vehicle;
        public final LivingEntity entity;

        public PassengerVehicleContext(Entity vehicle, LivingEntity entity) {
            this.vehicle = vehicle;
            this.entity = entity;
        }
    }

    public static class ItemBoneRenderContext<T extends LivingEntity> {
        public final BlockAndItemGeoLayer<T> layer;
        public final PoseStack poseStack;
        public final GeoBone bone;
        public final ItemStack item;
        public final T entity;
        public final MultiBufferSource bufferSource;
        public final float partialTick;
        public final int packedLight;
        public final int packedOverlay;

        public ItemBoneRenderContext(BlockAndItemGeoLayer<T> layer, PoseStack poseStack, GeoBone bone, ItemStack stack, T animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
            this.layer = layer;
            this.poseStack = poseStack;
            this.bone = bone;
            this.item = stack;
            this.entity = animatable;
            this.bufferSource = bufferSource;
            this.partialTick = partialTick;
            this.packedLight = packedLight;
            this.packedOverlay = packedOverlay;
        }
    }

    public static class RenderBoneContext<T extends LivingEntity> {
        public final ItemArmorGeoLayer<T> renderer;
        public final PoseStack poseStack;
        public final T entity;
        public final GeoBone bone;
        public final RenderType renderType;
        public final MultiBufferSource bufferSource;
        public final VertexConsumer buffer;
        public final float partialTick;
        public final int packedLight;
        public final int packedOverlay;

        public RenderBoneContext(ItemArmorGeoLayer<T> renderer, PoseStack poseStack, T entity, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
            this.renderer = renderer;
            this.poseStack = poseStack;
            this.entity = entity;
            this.bone = bone;
            this.renderType = renderType;
            this.bufferSource = bufferSource;
            this.buffer = buffer;
            this.partialTick = partialTick;
            this.packedLight = packedLight;
            this.packedOverlay = packedOverlay;
        }
    }

    public static class VanillaArmorRenderContext<T extends LivingEntity> {
        public final ItemArmorGeoLayer<T> renderer;
        public final PoseStack poseStack;
        public final T entity;
        public final GeoBone bone;
        public final EquipmentSlot slot;
        public final ItemStack armorStack;
        public final ModelPart modelPart;
        public final MultiBufferSource bufferSource;
        public final float partialTick;
        public final int packedLight;
        public final int packedOverlay;

        public VanillaArmorRenderContext(ItemArmorGeoLayer<T> renderer, PoseStack poseStack, T animatable, GeoBone bone, EquipmentSlot slot, ItemStack armorStack, ModelPart modelPart, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
            this.renderer = renderer;
            this.poseStack = poseStack;
            this.entity = animatable;
            this.bone = bone;
            this.slot = slot;
            this.armorStack = armorStack;
            this.modelPart = modelPart;
            this.bufferSource = bufferSource;
            this.partialTick = partialTick;
            this.packedLight = packedLight;
            this.packedOverlay = packedOverlay;
        }
    }
}

