/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.util.data;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.liopyu.entityjs.util.EntitySerializerType;
import net.liopyu.entityjs.util.data.InitDecl;
import net.liopyu.entityjs.util.data.Net;
import net.liopyu.entityjs.util.data.SavedDataJS;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public final class ServerCache {
    public static Map<String, Tag> getAll(Entity e) {
        Level level = e.level();
        if (!(level instanceof ServerLevel)) {
            return Map.of();
        }
        ServerLevel sl = (ServerLevel)level;
        return SavedDataJS.get(sl).getAll(e.getUUID());
    }

    public static Map<String, Integer> getTypes(Entity e) {
        Level level = e.level();
        if (!(level instanceof ServerLevel)) {
            return Map.of();
        }
        ServerLevel sl = (ServerLevel)level;
        return SavedDataJS.get(sl).getTypes(e.getUUID());
    }

    public static Tag get(Entity e, String name) {
        Level level = e.level();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel sl = (ServerLevel)level;
        return SavedDataJS.get(sl).get(e.getUUID(), name);
    }

    public static boolean has(Entity e, String name) {
        Level level = e.level();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel sl = (ServerLevel)level;
        return SavedDataJS.get(sl).has(e.getUUID(), name);
    }

    public static void set(Entity e, String name, Tag v) {
        Level level = e.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        SavedDataJS.get(sl).put(e.getUUID(), name, v);
        Net.sendValueTracking(e, e.getUUID(), name, v);
    }

    public static void ensure(Entity e, String name, Tag v, EntitySerializerType type) {
        Level level = e.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        SavedDataJS data = SavedDataJS.get(sl);
        UUID id = e.getUUID();
        Optional<EntitySerializerType> prev = data.getType(id, name);
        if (prev.isEmpty()) {
            data.putWithType(id, name, v, type);
            Net.sendTypedValueTracking(e, id, name, type.ordinal(), v);
        } else if (prev.get() != type) {
            data.putWithType(id, name, v, type);
            Net.sendTypedValueTracking(e, id, name, type.ordinal(), v);
        }
        InitDecl.declare(e, name, type);
    }

    public static void migrateIfAbsent(Entity e, String name, Tag v, EntitySerializerType type) {
        Level level = e.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        SavedDataJS data = SavedDataJS.get(sl);
        UUID id = e.getUUID();
        if (data.getType(id, name).isEmpty()) {
            data.putWithType(id, name, v, type);
        }
    }
}

