/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lucaargolo.kibe.block.ConveyorBelt;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 @2\u00020\u0001:\u0001@B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\u000f\u0010\u0010J'\u0010\u0014\u001a\u00020\u00132\u0016\u0010\u0012\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0011H\u0014\u00a2\u0006\u0004\b\u0014\u0010\u0015J!\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0016H\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0019J!\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001aH\u0014\u00a2\u0006\u0004\b\u001b\u0010\u001cJ/\u0010!\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u001fH\u0014\u00a2\u0006\u0004\b!\u0010\"J\u0019\u0010%\u001a\u0004\u0018\u00010\b2\u0006\u0010$\u001a\u00020#H\u0016\u00a2\u0006\u0004\b%\u0010&J?\u0010,\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020*2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010+\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b,\u0010-J\u0019\u0010/\u001a\u00020.2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0014\u00a2\u0006\u0004\b/\u00100J\u0019\u00102\u001a\u0002012\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0014\u00a2\u0006\u0004\b2\u00103J7\u00107\u001a\u0002062\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\f2\b\u00105\u001a\u0004\u0018\u000104H\u0014\u00a2\u0006\u0004\b7\u00108J7\u00109\u001a\u0002062\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\f2\b\u00105\u001a\u0004\u0018\u000104H\u0014\u00a2\u0006\u0004\b9\u00108J-\u0010:\u001a\u0002062\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0014\u00a2\u0006\u0004\b:\u0010;J\u0015\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00000<H\u0014\u00a2\u0006\u0004\b=\u0010>R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010?\u00a8\u0006A"}, d2={"Lio/github/lucaargolo/kibe/block/ConveyorBelt;", "Lnet/minecraft/world/level/block/Block;", "", "speed", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "settings", "<init>", "(DLnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lnet/minecraft/world/level/BlockGetter;", "view", "Lnet/minecraft/core/BlockPos;", "pos", "", "getOpacity", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)I", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "stateManager", "", "appendProperties", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "Lnet/minecraft/world/level/block/Rotation;", "rotation", "rotate", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/Rotation;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/block/Mirror;", "mirror", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/Mirror;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/Entity;", "entity", "onEntityCollision", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/Entity;)V", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "ctx", "getPlacementState", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/core/Direction;", "facing", "neighborState", "Lnet/minecraft/world/level/LevelAccessor;", "neighborPos", "getStateForNeighborUpdate", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/block/RenderShape;", "getRenderType", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/RenderShape;", "", "hasSidedTransparency", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "ePos", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getOutlineShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;", "getCollisionShape", "getCullingShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lcom/mojang/serialization/MapCodec;", "getCodec", "()Lcom/mojang/serialization/MapCodec;", "D", "Companion", "kibe"})
@SourceDebugExtension(value={"SMAP\nConveyorBelt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConveyorBelt.kt\nio/github/lucaargolo/kibe/block/ConveyorBelt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1869#2,2:125\n*S KotlinDebug\n*F\n+ 1 ConveyorBelt.kt\nio/github/lucaargolo/kibe/block/ConveyorBelt\n*L\n47#1:125,2\n*E\n"})
public final class ConveyorBelt
extends Block {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double speed;
    @NotNull
    private static final MapCodec<ConveyorBelt> CODEC;
    private static final VoxelShape SHAPE;
    private static final VoxelShape EMPTY;

    public ConveyorBelt(double speed, @NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.speed = speed;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    protected int getLightBlock(@NotNull BlockState state, @NotNull BlockGetter view, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return 0;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> stateManager) {
        Intrinsics.checkNotNullParameter(stateManager, (String)"stateManager");
        Property[] propertyArray = new Property[]{BlockStateProperties.HORIZONTAL_FACING};
        stateManager.add(propertyArray);
        propertyArray = new Property[]{BlockStateProperties.NORTH};
        stateManager.add(propertyArray);
        propertyArray = new Property[]{BlockStateProperties.EAST};
        stateManager.add(propertyArray);
        propertyArray = new Property[]{BlockStateProperties.WEST};
        stateManager.add(propertyArray);
        propertyArray = new Property[]{BlockStateProperties.SOUTH};
        stateManager.add(propertyArray);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected BlockState rotate(@NotNull BlockState state, @NotNull Rotation rotation) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        Set mutedProperties = new LinkedHashSet();
        Object object = new Pair[]{new Pair((Object)BlockStateProperties.NORTH, (Object)Direction.NORTH), new Pair((Object)BlockStateProperties.EAST, (Object)Direction.EAST), new Pair((Object)BlockStateProperties.WEST, (Object)Direction.WEST), new Pair((Object)BlockStateProperties.SOUTH, (Object)Direction.SOUTH)};
        object = CollectionsKt.listOf((Object[])object);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            BooleanProperty property = (BooleanProperty)pair.component1();
            Direction direction = (Direction)pair.component2();
            if (!((Boolean)state.getValue((Property)property)).booleanValue()) continue;
            Direction direction2 = rotation.rotate(direction);
            Intrinsics.checkNotNullExpressionValue((Object)direction2, (String)"rotate(...)");
            mutedProperties.add(direction2);
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)))).setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(mutedProperties.contains(Direction.NORTH)))).setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(mutedProperties.contains(Direction.EAST)))).setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(mutedProperties.contains(Direction.WEST)))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(mutedProperties.contains(Direction.SOUTH)));
    }

    @Nullable
    protected BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirror) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)mirror, (String)"mirror");
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    protected void entityInside(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        Vec3 desiredPos = new Vec3((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
        double adjustmentFactor = 0.1;
        double adjustmentSpeed = this.speed * desiredPos.distanceTo(entity.position());
        Vec3 adjustmentVec3d = new Vec3(Math.abs(entity.position().x - desiredPos.x) > adjustmentFactor ? (double)Mth.sign((double)((entity.position().x - desiredPos.x) * (double)-1)) : 0.0, 0.0, Math.abs(entity.position().z - desiredPos.z) > adjustmentFactor ? (double)Mth.sign((double)((entity.position().z - desiredPos.z) * (double)-1)) : 0.0);
        if (entity.getY() - (double)pos.getY() > 0.3 || entity instanceof Player && ((Player)entity).isShiftKeyDown()) {
            return;
        }
        Vec3 finalVel = new Vec3(direction.getStepX() == 0 ? adjustmentVec3d.x * adjustmentSpeed : (double)direction.getStepX(), 0.0, direction.getStepZ() == 0 ? adjustmentVec3d.z * adjustmentSpeed : (double)direction.getStepZ());
        Vec3 currentVel = entity.getDeltaMovement();
        entity.setDeltaMovement(new Vec3(Mth.lerp((double)this.speed, (double)currentVel.x, (double)finalVel.x), 0.0, Mth.lerp((double)this.speed, (double)currentVel.z, (double)finalVel.z)));
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)CrossCollisionBlock.NORTH, (Comparable)Boolean.valueOf(ctx.getLevel().getBlockState(ctx.getClickedPos().south()).getBlock() instanceof ConveyorBelt))).setValue((Property)CrossCollisionBlock.SOUTH, (Comparable)Boolean.valueOf(ctx.getLevel().getBlockState(ctx.getClickedPos().north()).getBlock() instanceof ConveyorBelt))).setValue((Property)CrossCollisionBlock.EAST, (Comparable)Boolean.valueOf(ctx.getLevel().getBlockState(ctx.getClickedPos().west()).getBlock() instanceof ConveyorBelt))).setValue((Property)CrossCollisionBlock.WEST, (Comparable)Boolean.valueOf(ctx.getLevel().getBlockState(ctx.getClickedPos().east()).getBlock() instanceof ConveyorBelt))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)ctx.getHorizontalDirection());
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction facing, @NotNull BlockState neighborState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        if (facing.getAxis().getPlane() == Direction.Plane.HORIZONTAL) {
            Object object = ((BlockState)((BlockState)((BlockState)state.setValue((Property)CrossCollisionBlock.NORTH, (Comparable)Boolean.valueOf(world.getBlockState(pos.south()).getBlock() instanceof ConveyorBelt))).setValue((Property)CrossCollisionBlock.SOUTH, (Comparable)Boolean.valueOf(world.getBlockState(pos.north()).getBlock() instanceof ConveyorBelt))).setValue((Property)CrossCollisionBlock.EAST, (Comparable)Boolean.valueOf(world.getBlockState(pos.west()).getBlock() instanceof ConveyorBelt))).setValue((Property)CrossCollisionBlock.WEST, (Comparable)Boolean.valueOf(world.getBlockState(pos.east()).getBlock() instanceof ConveyorBelt));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"with(...)");
            blockState = (BlockState)object;
        } else {
            BlockState blockState2 = super.updateShape(state, facing, neighborState, world, pos, neighborPos);
            blockState = blockState2;
            Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"getStateForNeighborUpdate(...)");
        }
        return blockState;
    }

    @NotNull
    protected RenderShape getRenderShape(@Nullable BlockState state) {
        return RenderShape.MODEL;
    }

    protected boolean useShapeForLightOcclusion(@Nullable BlockState state) {
        return true;
    }

    @NotNull
    protected VoxelShape getShape(@Nullable BlockState state, @Nullable BlockGetter view, @Nullable BlockPos pos, @Nullable CollisionContext ePos) {
        VoxelShape voxelShape = SHAPE;
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"SHAPE");
        return voxelShape;
    }

    @NotNull
    protected VoxelShape getCollisionShape(@Nullable BlockState state, @Nullable BlockGetter view, @Nullable BlockPos pos, @Nullable CollisionContext ePos) {
        VoxelShape voxelShape;
        if (Intrinsics.areEqual((Object)ePos, (Object)CollisionContext.empty())) {
            VoxelShape voxelShape2 = EMPTY;
            voxelShape = voxelShape2;
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"EMPTY");
        } else {
            VoxelShape voxelShape3 = SHAPE;
            voxelShape = voxelShape3;
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape3, (String)"SHAPE");
        }
        return voxelShape;
    }

    @NotNull
    protected VoxelShape getOcclusionShape(@Nullable BlockState state, @Nullable BlockGetter view, @Nullable BlockPos pos) {
        VoxelShape voxelShape = EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"EMPTY");
        return voxelShape;
    }

    @NotNull
    protected MapCodec<ConveyorBelt> codec() {
        return CODEC;
    }

    private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
        return instance.group((App)Codec.DOUBLE.fieldOf("speed").forGetter(arg_0 -> ConveyorBelt.CODEC$lambda$0$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)Block.propertiesCodec()).apply((Applicative)instance, ConveyorBelt::new);
    }

    private static final Double CODEC$lambda$0$0(KProperty1 $tmp0, ConveyorBelt p0) {
        return (Double)((Function1)$tmp0).invoke((Object)p0);
    }

    public static final /* synthetic */ double access$getSpeed$p(ConveyorBelt $this) {
        return $this.speed;
    }

    static {
        MapCodec mapCodec = RecordCodecBuilder.mapCodec(ConveyorBelt::CODEC$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
        CODEC = mapCodec;
        SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
        EMPTY = Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R\u001c\u0010\n\u001a\n \t*\u0004\u0018\u00010\b0\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\n \t*\u0004\u0018\u00010\b0\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\u000b\u00a8\u0006\r"}, d2={"Lio/github/lucaargolo/kibe/block/ConveyorBelt$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/MapCodec;", "Lio/github/lucaargolo/kibe/block/ConveyorBelt;", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "kotlin.jvm.PlatformType", "SHAPE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "EMPTY", "kibe"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

