/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.block;

import com.mojang.serialization.MapCodec;
import io.github.lucaargolo.kibe.block.VacuumHopper;
import io.github.lucaargolo.kibe.blockentity.BlockEntityCompendium;
import io.github.lucaargolo.kibe.blockentity.VacuumHopperEntity;
import io.github.lucaargolo.kibe.utils.menu.BlockScreenHandlerFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 G2\u00020\u0001:\u0001GB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJG\u0010\u0013\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0012\"\n\b\u0000\u0010\r*\u0004\u0018\u00010\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J#\u0010\u0019\u001a\u00020\u00182\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0\u0015H\u0014\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0019\u0010\u001d\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJE\u0010%\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010 \u001a\u0004\u0018\u00010\u00062\b\u0010!\u001a\u0004\u0018\u00010\u00162\b\u0010\"\u001a\u0004\u0018\u00010\u00062\u0006\u0010$\u001a\u00020#H\u0014\u00a2\u0006\u0004\b%\u0010&J3\u0010*\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020'2\b\u0010 \u001a\u0004\u0018\u00010\u00062\b\u0010)\u001a\u0004\u0018\u00010(H\u0014\u00a2\u0006\u0004\b*\u0010+J7\u00101\u001a\u0002002\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010-\u001a\u00020,2\u0006\u0010/\u001a\u00020.H\u0014\u00a2\u0006\u0004\b1\u00102J9\u00104\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010 \u001a\u0004\u0018\u00010\u00062\u0006\u00103\u001a\u00020\b2\u0006\u0010$\u001a\u00020#H\u0014\u00a2\u0006\u0004\b4\u00105J/\u00106\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010)\u001a\u00020(H\u0016\u00a2\u0006\u0004\b6\u00107J\u0019\u00108\u001a\u00020#2\b\u0010\u001f\u001a\u0004\u0018\u00010\bH\u0014\u00a2\u0006\u0004\b8\u00109J'\u0010;\u001a\u00020:2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0006H\u0014\u00a2\u0006\u0004\b;\u0010<J-\u0010>\u001a\u00020#2\b\u0010\u001f\u001a\u0004\u0018\u00010\b2\b\u0010\u000f\u001a\u0004\u0018\u00010=2\b\u0010 \u001a\u0004\u0018\u00010\u0006H\u0014\u00a2\u0006\u0004\b>\u0010?J\u0019\u0010@\u001a\u00020#2\b\u0010\u001f\u001a\u0004\u0018\u00010\bH\u0014\u00a2\u0006\u0004\b@\u00109J\u0019\u0010B\u001a\u00020A2\b\u0010\u001f\u001a\u0004\u0018\u00010\bH\u0014\u00a2\u0006\u0004\bB\u0010CJ\u0015\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00000DH\u0014\u00a2\u0006\u0004\bE\u0010F\u00a8\u0006H"}, d2={"Lio/github/lucaargolo/kibe/block/VacuumHopper;", "Lnet/minecraft/world/level/block/BaseEntityBlock;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "settings", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "Lnet/minecraft/core/BlockPos;", "blockPos", "Lnet/minecraft/world/level/block/state/BlockState;", "blockState", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "createBlockEntity", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/entity/BlockEntity;", "T", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "blockEntityType", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "getTicker", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/BlockEntityType;)Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "builder", "", "appendProperties", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "ctx", "getPlacementState", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;", "state", "pos", "block", "fromPos", "", "notify", "neighborUpdate", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/Block;Lnet/minecraft/core/BlockPos;Z)V", "Lnet/minecraft/server/level/ServerLevel;", "Lnet/minecraft/util/RandomSource;", "random", "scheduledTick", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/phys/BlockHitResult;", "hit", "Lnet/minecraft/world/InteractionResult;", "onUse", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;", "newState", "onStateReplaced", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", "randomDisplayTick", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V", "hasComparatorOutput", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "", "getComparatorOutput", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)I", "Lnet/minecraft/world/level/BlockGetter;", "isTransparent", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)Z", "hasSidedTransparency", "Lnet/minecraft/world/level/block/RenderShape;", "getRenderType", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/RenderShape;", "Lcom/mojang/serialization/MapCodec;", "getCodec", "()Lcom/mojang/serialization/MapCodec;", "Companion", "kibe"})
public final class VacuumHopper
extends BaseEntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final MapCodec<VacuumHopper> CODEC;

    public VacuumHopper(@NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return new VacuumHopperEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@Nullable Level world, @Nullable BlockState blockState, @Nullable BlockEntityType<T> blockEntityType) {
        VacuumHopperEntity.Companion companion = VacuumHopperEntity.Companion;
        return BaseEntityBlock.createTickerHelper(blockEntityType, BlockEntityCompendium.INSTANCE.getVACUUM_HOPPER(), (BlockEntityTicker)new BlockEntityTicker(companion){
            final /* synthetic */ VacuumHopperEntity.Companion $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void tick(Level p0, BlockPos p1, BlockState p2, VacuumHopperEntity p3) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                Intrinsics.checkNotNullParameter((Object)((Object)p3), (String)"p3");
                this.$tmp0.tick(p0, p1, p2, p3);
            }
        });
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{BlockStateProperties.ENABLED};
        builder.add(propertyArray);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(!ctx.getLevel().hasNeighborSignal(ctx.getClickedPos())));
    }

    protected void neighborChanged(@NotNull BlockState state, @NotNull Level world, @Nullable BlockPos pos, @Nullable Block block, @Nullable BlockPos fromPos, boolean notify) {
        Boolean isEnabled;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        if (!world.isClientSide && Intrinsics.areEqual((Object)(isEnabled = (Boolean)state.getValue((Property)BlockStateProperties.ENABLED)), (Object)world.hasNeighborSignal(pos))) {
            if (isEnabled.booleanValue()) {
                world.scheduleTick(pos, (Block)this, 4);
            } else {
                world.setBlock(pos, (BlockState)state.cycle((Property)BlockStateProperties.ENABLED), 2);
            }
        }
    }

    protected void tick(@NotNull BlockState state, @NotNull ServerLevel world, @Nullable BlockPos pos, @Nullable RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        if (((Boolean)state.getValue((Property)BlockStateProperties.ENABLED)).booleanValue() && world.hasNeighborSignal(pos)) {
            world.setBlock(pos, (BlockState)state.cycle((Property)BlockStateProperties.ENABLED), 2);
        }
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        player.openMenu((MenuProvider)new BlockScreenHandlerFactory((Block)this, pos, onUse.1.INSTANCE));
        return InteractionResult.SUCCESS;
    }

    protected void onRemove(@NotNull BlockState state, @NotNull Level world, @Nullable BlockPos pos, @NotNull BlockState newState, boolean notify) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof Container) {
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)((Container)blockEntity));
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, notify);
        }
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (((Boolean)state.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
            int n = 4;
            for (int i = 0; i < n; ++i) {
                int it = i;
                boolean bl = false;
                double x = (double)pos.getX() + random.nextDouble();
                double y = (double)pos.getY() + random.nextDouble();
                double z = (double)pos.getZ() + random.nextDouble();
                double velocityX = ((double)random.nextFloat() - 0.5) * 0.5;
                double velocityY = ((double)random.nextFloat() - 0.5) * 0.5;
                double velocityZ = ((double)random.nextFloat() - 0.5) * 0.5;
                int k = random.nextInt(2) * 2 - 1;
                if (!world.getBlockState(pos.west()).is((Block)this) && !world.getBlockState(pos.east()).is((Block)this)) {
                    x = (double)pos.getX() + 0.5 + 0.25 * (double)k;
                    velocityX = random.nextFloat() * 2.0f * (float)k;
                } else {
                    z = (double)pos.getZ() + 0.5 + 0.25 * (double)k;
                    velocityZ = random.nextFloat() * 2.0f * (float)k;
                }
                world.addParticle((ParticleOptions)ParticleTypes.PORTAL, x, y, z, velocityX, velocityY, velocityZ);
            }
        }
    }

    protected boolean hasAnalogOutputSignal(@Nullable BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos) {
        int output;
        block1: {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            output = 0;
            BlockEntity blockEntity = world.getBlockEntity(pos);
            VacuumHopperEntity vacuumHopperEntity = blockEntity instanceof VacuumHopperEntity ? (VacuumHopperEntity)blockEntity : null;
            if (vacuumHopperEntity == null) break block1;
            VacuumHopperEntity entity = vacuumHopperEntity;
            boolean bl = false;
            int i = 0;
            float f = 0.0f;
            int n = 9;
            for (int j = 0; j < n; ++j) {
                int it = j;
                boolean bl2 = false;
                ItemStack itemStack = entity.getItem(it);
                if (itemStack.isEmpty()) continue;
                f += (float)itemStack.getCount() / (float)RangesKt.coerceAtMost((int)entity.getMaxStackSize(), (int)itemStack.getMaxStackSize());
                ++i;
            }
            output = Mth.floor((float)(f / 9.0f * 14.0f)) + (i > 0 ? 1 : 0);
        }
        return output;
    }

    protected boolean propagatesSkylightDown(@Nullable BlockState state, @Nullable BlockGetter world, @Nullable BlockPos pos) {
        return true;
    }

    protected boolean useShapeForLightOcclusion(@Nullable BlockState state) {
        return true;
    }

    @NotNull
    protected RenderShape getRenderShape(@Nullable BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    protected MapCodec<VacuumHopper> codec() {
        return CODEC;
    }

    static {
        MapCodec mapCodec = BaseEntityBlock.simpleCodec(VacuumHopper::new);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"createCodec(...)");
        CODEC = mapCodec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/github/lucaargolo/kibe/block/VacuumHopper$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/MapCodec;", "Lio/github/lucaargolo/kibe/block/VacuumHopper;", "CODEC", "Lcom/mojang/serialization/MapCodec;", "kibe"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

