/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.blockentity;

import io.github.lucaargolo.kibe.blockentity.BlockEntityCompendium;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u0011\u0010\u000fJ\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001bJ\u001f\u0010 \u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b \u0010!J\u000f\u0010\"\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010&\u001a\u00020\u00152\u0006\u0010%\u001a\u00020$H\u0016\u00a2\u0006\u0004\b&\u0010'R(\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00190(8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Lio/github/lucaargolo/kibe/blockentity/BreakerBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/world/Container;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Lnet/minecraft/nbt/CompoundTag;", "nbt", "Lnet/minecraft/core/HolderLookup$Provider;", "registryLookup", "", "writeNbt", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)V", "tag", "readNbt", "", "size", "()I", "", "isEmpty", "()Z", "slot", "Lnet/minecraft/world/item/ItemStack;", "getStack", "(I)Lnet/minecraft/world/item/ItemStack;", "amount", "removeStack", "(II)Lnet/minecraft/world/item/ItemStack;", "stack", "setStack", "(ILnet/minecraft/world/item/ItemStack;)V", "clear", "()V", "Lnet/minecraft/world/entity/player/Player;", "player", "canPlayerUse", "(Lnet/minecraft/world/entity/player/Player;)Z", "Lnet/minecraft/core/NonNullList;", "inventory", "Lnet/minecraft/core/NonNullList;", "getInventory", "()Lnet/minecraft/core/NonNullList;", "setInventory", "(Lnet/minecraft/core/NonNullList;)V", "kibe"})
@SourceDebugExtension(value={"SMAP\nBreakerBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BreakerBlockEntity.kt\nio/github/lucaargolo/kibe/blockentity/BreakerBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1740#2,3:51\n1#3:54\n*S KotlinDebug\n*F\n+ 1 BreakerBlockEntity.kt\nio/github/lucaargolo/kibe/blockentity/BreakerBlockEntity\n*L\n29#1:51,3\n*E\n"})
public final class BreakerBlockEntity
extends BlockEntity
implements Container {
    @NotNull
    private NonNullList<ItemStack> inventory;

    public BreakerBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(BlockEntityCompendium.INSTANCE.getBREAKER(), pos, state);
        NonNullList nonNullList = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"ofSize(...)");
        this.inventory = nonNullList;
    }

    @NotNull
    public final NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public final void setInventory(@NotNull NonNullList<ItemStack> nonNullList) {
        Intrinsics.checkNotNullParameter(nonNullList, (String)"<set-?>");
        this.inventory = nonNullList;
    }

    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)registryLookup);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        super.loadAdditional(tag, registryLookup);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)registryLookup);
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public boolean isEmpty() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = (Iterable)this.inventory;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ItemStack it = (ItemStack)element$iv;
                    boolean bl2 = false;
                    if (it.isEmpty()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public ItemStack getItem(int slot) {
        Object object = this.inventory.get(slot);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ItemStack)object;
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemStack = ContainerHelper.removeItem((List)((List)this.inventory), (int)slot, (int)amount);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"splitStack(...)");
        return itemStack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack itemStack = ContainerHelper.takeItem((List)((List)this.inventory), (int)slot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"removeStack(...)");
        return itemStack;
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.inventory.set(slot, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
    }

    public void clearContent() {
        this.inventory.clear();
    }

    public boolean stillValid(@NotNull Player player) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Level level = this.level;
        if (level != null && (level = level.getBlockEntity(this.worldPosition)) != null) {
            Level it = level;
            boolean bl2 = false;
            bl = Intrinsics.areEqual((Object)it, (Object)((Object)this)) && player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
        } else {
            bl = false;
        }
        return bl;
    }
}

