/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.client;

import io.github.lucaargolo.kibe.utils.ModIdentifier;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0013\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ)\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\rj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e`\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u001f\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR0\u0010 \u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\rj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n`\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0017\u0010\"\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R\u0017\u0010&\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b&\u0010#\u001a\u0004\b'\u0010%R\u0017\u0010(\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b(\u0010#\u001a\u0004\b)\u0010%R\u0017\u0010*\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b*\u0010#\u001a\u0004\b+\u0010%\u00a8\u0006,"}, d2={"Lio/github/lucaargolo/kibe/client/EntangledRenderer;", "", "", "parent", "<init>", "(Ljava/lang/String;)V", "", "idx", "Lnet/minecraft/world/item/DyeColor;", "col", "Lnet/minecraft/client/model/geom/ModelLayerLocation;", "getRuneLayer", "(ILnet/minecraft/world/item/DyeColor;)Lnet/minecraft/client/model/geom/ModelLayerLocation;", "Ljava/util/LinkedHashMap;", "Lnet/minecraft/client/model/geom/builders/LayerDefinition;", "Lkotlin/collections/LinkedHashMap;", "getEntries", "()Ljava/util/LinkedHashMap;", "setupBottomModel", "()Lnet/minecraft/client/model/geom/builders/LayerDefinition;", "setupTopModel", "runeId", "runeColor", "setupRuneModel", "(ILnet/minecraft/world/item/DyeColor;)Lnet/minecraft/client/model/geom/builders/LayerDefinition;", "", "diamond", "setupCoreModel", "(Z)Lnet/minecraft/client/model/geom/builders/LayerDefinition;", "Ljava/lang/String;", "getParent", "()Ljava/lang/String;", "runeModelLayers", "Ljava/util/LinkedHashMap;", "bottomModelLayer", "Lnet/minecraft/client/model/geom/ModelLayerLocation;", "getBottomModelLayer", "()Lnet/minecraft/client/model/geom/ModelLayerLocation;", "topModelLayer", "getTopModelLayer", "coreModelLayerGold", "getCoreModelLayerGold", "coreModelLayerDiamond", "getCoreModelLayerDiamond", "kibe"})
@SourceDebugExtension(value={"SMAP\nEntangledRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntangledRenderer.kt\nio/github/lucaargolo/kibe/client/EntangledRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,121:1\n1869#2:122\n1869#2,2:123\n1870#2:125\n216#3,2:126\n*S KotlinDebug\n*F\n+ 1 EntangledRenderer.kt\nio/github/lucaargolo/kibe/client/EntangledRenderer\n*L\n21#1:122\n22#1:123,2\n21#1:125\n43#1:126,2\n*E\n"})
public final class EntangledRenderer {
    @NotNull
    private final String parent;
    @NotNull
    private final LinkedHashMap<String, ModelLayerLocation> runeModelLayers;
    @NotNull
    private final ModelLayerLocation bottomModelLayer;
    @NotNull
    private final ModelLayerLocation topModelLayer;
    @NotNull
    private final ModelLayerLocation coreModelLayerGold;
    @NotNull
    private final ModelLayerLocation coreModelLayerDiamond;

    public EntangledRenderer(@NotNull String parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.parent = parent;
        this.runeModelLayers = new LinkedHashMap();
        Iterable $this$forEach$iv = (Iterable)new IntRange(1, 8);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int runeId = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            Iterable $this$forEach$iv2 = (Iterable)EntriesMappings.entries$0;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                DyeColor runeColor = (DyeColor)element$iv2;
                boolean bl2 = false;
                ((Map)this.runeModelLayers).put("rune" + runeId + "_" + runeColor.getName(), new ModelLayerLocation(ModIdentifier.INSTANCE.of(this.parent), "rune" + runeId + "_" + runeColor.getName()));
            }
        }
        this.bottomModelLayer = new ModelLayerLocation(ModIdentifier.INSTANCE.of(this.parent), "bottom");
        this.topModelLayer = new ModelLayerLocation(ModIdentifier.INSTANCE.of(this.parent), "top");
        this.coreModelLayerGold = new ModelLayerLocation(ModIdentifier.INSTANCE.of(this.parent), "core_gold");
        this.coreModelLayerDiamond = new ModelLayerLocation(ModIdentifier.INSTANCE.of(this.parent), "core_diamond");
    }

    @NotNull
    public final String getParent() {
        return this.parent;
    }

    @NotNull
    public final ModelLayerLocation getBottomModelLayer() {
        return this.bottomModelLayer;
    }

    @NotNull
    public final ModelLayerLocation getTopModelLayer() {
        return this.topModelLayer;
    }

    @NotNull
    public final ModelLayerLocation getCoreModelLayerGold() {
        return this.coreModelLayerGold;
    }

    @NotNull
    public final ModelLayerLocation getCoreModelLayerDiamond() {
        return this.coreModelLayerDiamond;
    }

    @Nullable
    public final ModelLayerLocation getRuneLayer(int idx, @NotNull DyeColor col) {
        Intrinsics.checkNotNullParameter((Object)col, (String)"col");
        return this.runeModelLayers.get("rune" + (idx + 1) + "_" + col.getName());
    }

    @NotNull
    public final LinkedHashMap<ModelLayerLocation, LayerDefinition> getEntries() {
        LinkedHashMap<ModelLayerLocation, LayerDefinition> map = new LinkedHashMap<ModelLayerLocation, LayerDefinition>();
        ((Map)map).put(this.bottomModelLayer, this.setupBottomModel());
        ((Map)map).put(this.topModelLayer, this.setupTopModel());
        Map $this$forEach$iv = this.runeModelLayers;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String string = (String)entry.getKey();
            ModelLayerLocation entityModelLayer = (ModelLayerLocation)entry.getValue();
            String[] stringArray = new String[]{"_"};
            List stringList = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)string, (String)"rune", (String)"", (boolean)false, (int)4, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            int runeId = Integer.parseInt((String)stringList.get(0));
            DyeColor dyeColor = DyeColor.byName((String)CollectionsKt.joinToString$default((Iterable)stringList.subList(1, stringList.size()), (CharSequence)"_", null, null, (int)0, null, null, (int)62, null), (DyeColor)DyeColor.WHITE);
            if (dyeColor == null) {
                dyeColor = DyeColor.WHITE;
            }
            DyeColor runeColor = dyeColor;
            ((Map)map).put(entityModelLayer, this.setupRuneModel(runeId, runeColor));
        }
        ((Map)map).put(this.coreModelLayerGold, this.setupCoreModel(false));
        ((Map)map).put(this.coreModelLayerDiamond, this.setupCoreModel(true));
        return map;
    }

    private final LayerDefinition setupBottomModel() {
        MeshDefinition lv = new MeshDefinition();
        PartDefinition lv2 = lv.getRoot();
        float ySize = Intrinsics.areEqual((Object)this.parent, (Object)"entangled_chest") ? 10.0f : 1.0f;
        lv2.addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, 0.0f, 1.0f, 14.0f, ySize, 14.0f), PartPose.ZERO);
        LayerDefinition layerDefinition = LayerDefinition.create((MeshDefinition)lv, (int)64, (int)64);
        Intrinsics.checkNotNullExpressionValue((Object)layerDefinition, (String)"of(...)");
        return layerDefinition;
    }

    private final LayerDefinition setupTopModel() {
        MeshDefinition lv = new MeshDefinition();
        PartDefinition lv2 = lv.getRoot();
        lv2.addOrReplaceChild("top1", CubeListBuilder.create().texOffs(32, 43).addBox(1.0f, 14.0f, 1.0f, 2.0f, 1.0f, 14.0f), PartPose.ZERO);
        lv2.addOrReplaceChild("top2", CubeListBuilder.create().texOffs(56, 0).addBox(3.0f, 14.0f, 1.0f, 2.0f, 1.0f, 2.0f), PartPose.ZERO);
        lv2.addOrReplaceChild("top3", CubeListBuilder.create().texOffs(56, 3).addBox(7.0f, 14.0f, 1.0f, 2.0f, 1.0f, 2.0f), PartPose.ZERO);
        lv2.addOrReplaceChild("top4", CubeListBuilder.create().texOffs(56, 6).addBox(11.0f, 14.0f, 1.0f, 2.0f, 1.0f, 2.0f), PartPose.ZERO);
        lv2.addOrReplaceChild("top5", CubeListBuilder.create().texOffs(56, 31).addBox(11.0f, 14.0f, 13.0f, 2.0f, 1.0f, 2.0f), PartPose.ZERO);
        lv2.addOrReplaceChild("top6", CubeListBuilder.create().texOffs(56, 28).addBox(7.0f, 14.0f, 13.0f, 2.0f, 1.0f, 2.0f), PartPose.ZERO);
        lv2.addOrReplaceChild("top7", CubeListBuilder.create().texOffs(56, 25).addBox(3.0f, 14.0f, 13.0f, 2.0f, 1.0f, 2.0f), PartPose.ZERO);
        lv2.addOrReplaceChild("top8", CubeListBuilder.create().texOffs(56, 17).addBox(3.0f, 14.0f, 9.0f, 2.0f, 1.0f, 2.0f), PartPose.ZERO);
        lv2.addOrReplaceChild("top9", CubeListBuilder.create().texOffs(56, 9).addBox(3.0f, 14.0f, 5.0f, 2.0f, 1.0f, 2.0f), PartPose.ZERO);
        lv2.addOrReplaceChild("top10", CubeListBuilder.create().texOffs(56, 14).addBox(11.0f, 14.0f, 5.0f, 2.0f, 1.0f, 2.0f), PartPose.ZERO);
        lv2.addOrReplaceChild("top11", CubeListBuilder.create().texOffs(58, 12).addBox(7.0f, 14.0f, 5.0f, 2.0f, 1.0f, 1.0f), PartPose.ZERO);
        lv2.addOrReplaceChild("top12", CubeListBuilder.create().texOffs(56, 22).addBox(11.0f, 14.0f, 9.0f, 2.0f, 1.0f, 2.0f), PartPose.ZERO);
        lv2.addOrReplaceChild("top13", CubeListBuilder.create().texOffs(58, 20).addBox(7.0f, 14.0f, 10.0f, 2.0f, 1.0f, 1.0f), PartPose.ZERO);
        lv2.addOrReplaceChild("top14", CubeListBuilder.create().texOffs(0, 43).addBox(13.0f, 14.0f, 1.0f, 2.0f, 1.0f, 14.0f), PartPose.ZERO);
        lv2.addOrReplaceChild("top15", CubeListBuilder.create().texOffs(16, 42).addBox(10.0f, 14.0f, 1.0f, 1.0f, 1.0f, 14.0f), PartPose.ZERO);
        lv2.addOrReplaceChild("top16", CubeListBuilder.create().texOffs(0, 0).addBox(9.0f, 14.0f, 1.0f, 1.0f, 1.0f, 6.0f), PartPose.ZERO);
        lv2.addOrReplaceChild("top17", CubeListBuilder.create().texOffs(0, 24).addBox(6.0f, 14.0f, 1.0f, 1.0f, 1.0f, 6.0f), PartPose.ZERO);
        lv2.addOrReplaceChild("top18", CubeListBuilder.create().texOffs(0, 31).addBox(6.0f, 14.0f, 9.0f, 1.0f, 1.0f, 6.0f), PartPose.ZERO);
        lv2.addOrReplaceChild("top19", CubeListBuilder.create().texOffs(0, 7).addBox(9.0f, 14.0f, 9.0f, 1.0f, 1.0f, 6.0f), PartPose.ZERO);
        lv2.addOrReplaceChild("top20", CubeListBuilder.create().texOffs(16, 42).addBox(5.0f, 14.0f, 1.0f, 1.0f, 1.0f, 14.0f), PartPose.ZERO);
        LayerDefinition layerDefinition = LayerDefinition.create((MeshDefinition)lv, (int)64, (int)64);
        Intrinsics.checkNotNullExpressionValue((Object)layerDefinition, (String)"of(...)");
        return layerDefinition;
    }

    private final LayerDefinition setupRuneModel(int runeId, DyeColor runeColor) {
        MeshDefinition lv = new MeshDefinition();
        PartDefinition lv2 = lv.getRoot();
        int runeTextureV = runeColor.getId() >= 8 ? (runeColor.getId() - 8) * 4 : runeColor.getId() * 4;
        int runeTextureU = runeColor.getId() >= 8 ? 8 : 0;
        switch (runeId) {
            case 1: {
                lv2.addOrReplaceChild("rune1_" + runeColor.getName(), CubeListBuilder.create().texOffs(runeTextureU, runeTextureV).addBox(11.0f, 13.0f, 11.0f, 2.0f, 2.0f, 2.0f), PartPose.ZERO);
                break;
            }
            case 2: {
                lv2.addOrReplaceChild("rune2_" + runeColor.getName(), CubeListBuilder.create().texOffs(runeTextureU, runeTextureV).addBox(7.0f, 13.0f, 11.0f, 2.0f, 2.0f, 2.0f), PartPose.ZERO);
                break;
            }
            case 3: {
                lv2.addOrReplaceChild("rune3_" + runeColor.getName(), CubeListBuilder.create().texOffs(runeTextureU, runeTextureV).addBox(3.0f, 13.0f, 11.0f, 2.0f, 2.0f, 2.0f), PartPose.ZERO);
                break;
            }
            case 4: {
                lv2.addOrReplaceChild("rune4_" + runeColor.getName(), CubeListBuilder.create().texOffs(runeTextureU, runeTextureV).addBox(3.0f, 13.0f, 7.0f, 2.0f, 2.0f, 2.0f), PartPose.ZERO);
                break;
            }
            case 5: {
                lv2.addOrReplaceChild("rune5_" + runeColor.getName(), CubeListBuilder.create().texOffs(runeTextureU, runeTextureV).addBox(3.0f, 13.0f, 3.0f, 2.0f, 2.0f, 2.0f), PartPose.ZERO);
                break;
            }
            case 6: {
                lv2.addOrReplaceChild("rune6_" + runeColor.getName(), CubeListBuilder.create().texOffs(runeTextureU, runeTextureV).addBox(7.0f, 13.0f, 3.0f, 2.0f, 2.0f, 2.0f), PartPose.ZERO);
                break;
            }
            case 7: {
                lv2.addOrReplaceChild("rune7_" + runeColor.getName(), CubeListBuilder.create().texOffs(runeTextureU, runeTextureV).addBox(11.0f, 13.0f, 3.0f, 2.0f, 2.0f, 2.0f), PartPose.ZERO);
                break;
            }
            case 8: {
                lv2.addOrReplaceChild("rune8_" + runeColor.getName(), CubeListBuilder.create().texOffs(runeTextureU, runeTextureV).addBox(11.0f, 13.0f, 7.0f, 2.0f, 2.0f, 2.0f), PartPose.ZERO);
            }
        }
        LayerDefinition layerDefinition = LayerDefinition.create((MeshDefinition)lv, (int)32, (int)32);
        Intrinsics.checkNotNullExpressionValue((Object)layerDefinition, (String)"of(...)");
        return layerDefinition;
    }

    private final LayerDefinition setupCoreModel(boolean diamond) {
        MeshDefinition lv = new MeshDefinition();
        PartDefinition lv2 = lv.getRoot();
        int upUv = diamond ? -10 : 0;
        lv2.addOrReplaceChild("core1", CubeListBuilder.create().texOffs(58, 50 + upUv).addBox(9.0f, 14.0f, 7.0f, 1.0f, 2.0f, 2.0f), PartPose.ZERO);
        lv2.addOrReplaceChild("core2", CubeListBuilder.create().texOffs(52, 44 + upUv).addBox(7.0f, 14.0f, 6.0f, 2.0f, 2.0f, 4.0f), PartPose.ZERO);
        lv2.addOrReplaceChild("core3", CubeListBuilder.create().texOffs(52, 50 + upUv).addBox(6.0f, 14.0f, 7.0f, 1.0f, 2.0f, 2.0f), PartPose.ZERO);
        LayerDefinition layerDefinition = LayerDefinition.create((MeshDefinition)lv, (int)64, (int)64);
        Intrinsics.checkNotNullExpressionValue((Object)layerDefinition, (String)"of(...)");
        return layerDefinition;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<DyeColor> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])DyeColor.values()));
        }
    }
}

