/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.github.lucaargolo.kibe.menu.BlockGeneratorScreenHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ/\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J'\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J/\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0019J/\u0010\u001e\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ/\u0010\"\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010!\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b\"\u0010#J7\u0010'\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b'\u0010(J_\u00101\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u00020\u00122\u0006\u00100\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b1\u00102R\u001c\u00105\u001a\n 4*\u0004\u0018\u000103038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106R\u001c\u00107\u001a\n 4*\u0004\u0018\u000103038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00106R\u0016\u00108\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00109R\u0016\u0010:\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b:\u00109\u00a8\u0006;"}, d2={"Lio/github/lucaargolo/kibe/client/screen/BlockGeneratorScreen;", "Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;", "Lio/github/lucaargolo/kibe/menu/BlockGeneratorScreenHandler;", "handler", "Lnet/minecraft/world/entity/player/Inventory;", "inventory", "Lnet/minecraft/network/chat/Component;", "title", "<init>", "(Lio/github/lucaargolo/kibe/menu/BlockGeneratorScreenHandler;Lnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/network/chat/Component;)V", "", "init", "()V", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "", "mouseX", "mouseY", "", "delta", "render", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "drawForeground", "(Lnet/minecraft/client/gui/GuiGraphics;II)V", "drawBackground", "(Lnet/minecraft/client/gui/GuiGraphics;FII)V", "Lnet/minecraft/world/level/block/Block;", "block", "", "left", "drawBlockBar", "(Lnet/minecraft/client/gui/GuiGraphics;FLnet/minecraft/world/level/block/Block;Z)V", "Lnet/minecraft/world/level/material/Fluid;", "fluid", "drawFluidBar", "(Lnet/minecraft/client/gui/GuiGraphics;FLnet/minecraft/world/level/material/Fluid;Z)V", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "sprite", "color", "drawBar", "(Lnet/minecraft/client/gui/GuiGraphics;FLnet/minecraft/client/renderer/texture/TextureAtlasSprite;IZ)V", "x0", "x1", "y0", "y1", "u0", "u1", "v0", "v1", "drawColoredTextureQuad", "(Lnet/minecraft/client/gui/GuiGraphics;FFFFFFFFI)V", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "texture", "Lnet/minecraft/resources/ResourceLocation;", "atlas", "atlasWidth", "F", "atlasHeight", "kibe"})
public final class BlockGeneratorScreen
extends AbstractContainerScreen<BlockGeneratorScreenHandler> {
    private final ResourceLocation texture;
    private final ResourceLocation atlas;
    private float atlasWidth;
    private float atlasHeight;

    public BlockGeneratorScreen(@NotNull BlockGeneratorScreenHandler handler, @NotNull Inventory inventory2, @NotNull Component title) {
        Intrinsics.checkNotNullParameter((Object)((Object)handler), (String)"handler");
        Intrinsics.checkNotNullParameter((Object)inventory2, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        super((AbstractContainerMenu)handler, inventory2, title);
        this.texture = ResourceLocation.parse((String)"kibe:textures/gui/block_generator.png");
        this.atlas = InventoryMenu.BLOCK_ATLAS;
    }

    protected void init() {
        super.init();
        this.imageHeight = 186;
        this.leftPos = this.width / 2 - this.imageWidth / 2;
        this.topPos = this.height / 2 - this.imageHeight / 2;
        Minecraft minecraft = this.minecraft;
        if (minecraft != null && (minecraft = minecraft.getTextureManager()) != null) {
            minecraft.bindForSetup(this.atlas);
        }
        this.atlasWidth = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        this.atlasHeight = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
    }

    public void render(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.renderBackground(context, mouseX, mouseY, delta);
        super.render(context, mouseX, mouseY, delta);
        this.renderTooltip(context, mouseX, mouseY);
    }

    protected void renderLabels(@NotNull GuiGraphics context, int mouseX, int mouseY) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.drawString(this.font, this.title, 8, 6, 0x404040, false);
        context.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 96 + 4, 0x404040, false);
    }

    protected void renderBg(@NotNull GuiGraphics context, float delta, int mouseX, int mouseY) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.blit(this.texture, this.leftPos, this.topPos, 0, 0, 176, 186);
        context.renderItem(new ItemStack((ItemLike)((BlockGeneratorScreenHandler)this.menu).getEntity().getBlock()), this.leftPos + 80, this.topPos + 18);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.atlas);
        if (Intrinsics.areEqual((Object)((BlockGeneratorScreenHandler)this.menu).getEntity().getBlock(), (Object)Blocks.BASALT)) {
            Block block = Blocks.BLUE_ICE;
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"BLUE_ICE");
            this.drawBlockBar(context, delta, block, true);
        } else {
            FlowingFluid flowingFluid = Fluids.WATER;
            Intrinsics.checkNotNullExpressionValue((Object)flowingFluid, (String)"WATER");
            this.drawFluidBar(context, delta, (Fluid)flowingFluid, true);
        }
        FlowingFluid flowingFluid = Fluids.LAVA;
        Intrinsics.checkNotNullExpressionValue((Object)flowingFluid, (String)"LAVA");
        this.drawFluidBar(context, delta, (Fluid)flowingFluid, false);
    }

    private final void drawBlockBar(GuiGraphics context, float delta, Block block, boolean left) {
        ResourceLocation resourceLocation = BuiltInRegistries.BLOCK.getKey((Object)block);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getId(...)");
        ResourceLocation blockId = resourceLocation;
        Material supposedBlockSpriteId = new Material(this.atlas, ResourceLocation.fromNamespaceAndPath((String)blockId.getNamespace(), (String)("block/" + blockId.getPath())));
        TextureAtlasSprite sprite = supposedBlockSpriteId.sprite();
        Intrinsics.checkNotNull((Object)sprite);
        this.drawBar(context, delta, sprite, -1, left);
    }

    private final void drawFluidBar(GuiGraphics context, float delta, Fluid fluid, boolean left) {
        FluidRenderHandler fluidRenderHandler = FluidRenderHandlerRegistry.INSTANCE.get(fluid);
        if (fluidRenderHandler == null) {
            return;
        }
        FluidRenderHandler fluidRenderHandler2 = fluidRenderHandler;
        TextureAtlasSprite sprite = fluidRenderHandler2.getFluidSprites((BlockAndTintGetter)((BlockGeneratorScreenHandler)this.menu).getEntity().getLevel(), ((BlockGeneratorScreenHandler)this.menu).getEntity().getBlockPos(), fluid.defaultFluidState())[0];
        int color = fluidRenderHandler2.getFluidColor((BlockAndTintGetter)((BlockGeneratorScreenHandler)this.menu).getEntity().getLevel(), ((BlockGeneratorScreenHandler)this.menu).getEntity().getBlockPos(), fluid.defaultFluidState());
        Intrinsics.checkNotNull((Object)sprite);
        this.drawBar(context, delta, sprite, color, left);
    }

    private final void drawBar(GuiGraphics context, float delta, TextureAtlasSprite sprite, int color, boolean left) {
        float bar;
        int off = 0;
        ((BlockGeneratorScreenHandler)this.menu).getEntity().setLastRenderProgress(Mth.lerp((float)delta, (float)((BlockGeneratorScreenHandler)this.menu).getEntity().getLastRenderProgress(), (float)((BlockGeneratorScreenHandler)this.menu).getEntity().getRenderProgress()));
        for (bar = ((BlockGeneratorScreenHandler)this.menu).getEntity().getLastRenderProgress() * 70.0f % 70.0f; bar > (float)sprite.contents().width(); bar -= (float)16) {
            if (left) {
                this.drawColoredTextureQuad(context, (float)this.leftPos + 8.0f + (float)off, (float)this.leftPos + 8.0f + (float)off + 16.0f, (float)this.topPos + 19.0f, (float)this.topPos + 19.0f + 14.0f, sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1() - 2.0f / this.atlasHeight, color);
            } else {
                this.drawColoredTextureQuad(context, (float)this.leftPos + 168.0f - (float)off - 16.0f, (float)this.leftPos + 168.0f - (float)off, (float)this.topPos + 19.0f, (float)this.topPos + 19.0f + 14.0f, sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1() - 2.0f / this.atlasHeight, color);
            }
            off += 16;
        }
        if (left) {
            this.drawColoredTextureQuad(context, (float)this.leftPos + 8.0f + (float)off, (float)this.leftPos + 8.0f + (float)off + bar, (float)this.topPos + 19.0f, (float)this.topPos + 19.0f + 14.0f, sprite.getU0(), sprite.getU1() - (16.0f - bar) / this.atlasWidth, sprite.getV0(), sprite.getV1() - 2.0f / this.atlasHeight, color);
        } else {
            this.drawColoredTextureQuad(context, (float)this.leftPos + 168.0f - (float)off - bar, (float)this.leftPos + 168.0f - (float)off, (float)this.topPos + 19.0f, (float)this.topPos + 19.0f + 14.0f, sprite.getU0() + (16.0f - bar) / this.atlasWidth, sprite.getU1(), sprite.getV0(), sprite.getV1() - 2.0f / this.atlasHeight, color);
        }
    }

    private final void drawColoredTextureQuad(GuiGraphics context, float x0, float x1, float y0, float y1, float u0, float u1, float v0, float v1, int color) {
        float z = 0.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Matrix4f matrix = context.pose().last().pose();
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferBuilder.addVertex(matrix, x0, y1, z).setUv(u0, v1).setColor(r, g, b, 1.0f);
        bufferBuilder.addVertex(matrix, x1, y1, z).setUv(u1, v1).setColor(r, g, b, 1.0f);
        bufferBuilder.addVertex(matrix, x1, y0, z).setUv(u1, v0).setColor(r, g, b, 1.0f);
        bufferBuilder.addVertex(matrix, x0, y0, z).setUv(u0, v0).setColor(r, g, b, 1.0f);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
    }
}

