/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lucaargolo.kibe.data.component.ComponentTypeCompendium;
import io.github.lucaargolo.kibe.item.MeasuringTape;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.reflect.KProperty1;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\u0018\u0000 %2\u00020\u0001:\u0003%&'B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ5\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ7\u0010#\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b#\u0010$\u00a8\u0006("}, d2={"Lio/github/lucaargolo/kibe/item/MeasuringTape;", "Lnet/minecraft/world/item/Item;", "Lnet/minecraft/world/item/Item$Properties;", "settings", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/player/Player;", "user", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "stack", "Lnet/minecraft/world/item/Item$TooltipContext;", "context", "", "Lnet/minecraft/network/chat/Component;", "tooltip", "Lnet/minecraft/world/item/TooltipFlag;", "type", "", "appendTooltip", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/Item$TooltipContext;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V", "", "hasGlint", "(Lnet/minecraft/world/item/ItemStack;)Z", "Lnet/minecraft/world/entity/Entity;", "entity", "", "slot", "selected", "inventoryTick", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Entity;IZ)V", "Companion", "MeasuringData", "PredicateProvider", "kibe"})
public final class MeasuringTape
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public MeasuringTape(@NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        ItemStack stack = user.getItemInHand(hand);
        if (Intrinsics.areEqual((Object)user.getMainHandItem(), (Object)stack) || user.getMainHandItem().isEmpty()) {
            double reach = user.isCreative() ? 5.0 : 4.5;
            HitResult hitResult = user.pick(reach, 1.0f, true);
            BlockHitResult blockHitResult = hitResult instanceof BlockHitResult ? (BlockHitResult)hitResult : null;
            if (blockHitResult == null || (blockHitResult = blockHitResult.getBlockPos()) == null) {
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.pass((Object)stack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
                return interactionResultHolder;
            }
            BlockHitResult pos = blockHitResult;
            if (!world.isClientSide) {
                Intrinsics.checkNotNull((Object)stack);
                Pair<ResourceLocation, BlockPos> measuringFrom = Companion.measuringFrom(stack);
                Pair<ResourceLocation, BlockPos> measuringTo = Companion.measuringTo(stack);
                if (measuringFrom == null) {
                    Companion.startMeasuring(stack, world, (BlockPos)pos);
                } else {
                    Companion.finishMeasuring(measuringFrom, measuringTo, user, (BlockPos)pos, stack);
                }
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)stack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
                return interactionResultHolder;
            }
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.pass((Object)stack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
        return interactionResultHolder;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag type) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        super.appendHoverText(stack, context, tooltip, type);
        Pair<ResourceLocation, BlockPos> measuringFrom = Companion.measuringFrom(stack);
        Pair<ResourceLocation, BlockPos> measuringTo = Companion.measuringTo(stack);
        if (measuringFrom == null) {
            Collection collection = tooltip;
            ChatFormatting[] chatFormattingArray = new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC};
            collection.add(Component.translatable((String)"tooltip.kibe.lore.measuring_tape.start").withStyle(chatFormattingArray));
        } else {
            Object[] objectArray;
            Collection collection;
            if (measuringTo != null) {
                collection = tooltip;
                objectArray = new Object[]{((BlockPos)measuringFrom.getSecond()).getX(), ((BlockPos)measuringFrom.getSecond()).getY(), ((BlockPos)measuringFrom.getSecond()).getZ(), ((BlockPos)measuringTo.getSecond()).getX(), ((BlockPos)measuringTo.getSecond()).getY(), ((BlockPos)measuringTo.getSecond()).getZ()};
                MutableComponent mutableComponent = Component.translatable((String)"tooltip.kibe.lore.measuring_tape.measuring_to", (Object[])objectArray);
                objectArray = new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC};
                collection.add(mutableComponent.withStyle((ChatFormatting[])objectArray));
            } else {
                collection = tooltip;
                objectArray = new Object[]{((BlockPos)measuringFrom.getSecond()).getX(), ((BlockPos)measuringFrom.getSecond()).getY(), ((BlockPos)measuringFrom.getSecond()).getZ()};
                MutableComponent mutableComponent = Component.translatable((String)"tooltip.kibe.lore.measuring_tape.measuring_from", (Object[])objectArray);
                objectArray = new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC};
                collection.add(mutableComponent.withStyle((ChatFormatting[])objectArray));
                collection = tooltip;
                objectArray = new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC};
                collection.add(Component.translatable((String)"tooltip.kibe.lore.measuring_tape.measuring_2").withStyle((ChatFormatting[])objectArray));
            }
            collection = tooltip;
            objectArray = new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC};
            collection.add(Component.translatable((String)"tooltip.kibe.lore.measuring_tape.measuring_3").withStyle((ChatFormatting[])objectArray));
        }
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return Companion.measuringTo(stack) != null;
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int slot, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (world.isClientSide && selected) {
            Minecraft client = Minecraft.getInstance();
            LocalPlayer localPlayer = client.player;
            if (localPlayer == null) {
                return;
            }
            LocalPlayer player = localPlayer;
            HitResult hitResult = client.hitResult;
            BlockHitResult blockHitResult = hitResult instanceof BlockHitResult ? (BlockHitResult)hitResult : null;
            if (blockHitResult == null || (blockHitResult = blockHitResult.getBlockPos()) == null) {
                return;
            }
            BlockHitResult pos = blockHitResult;
            Pair<ResourceLocation, BlockPos> measuringFrom = Companion.measuringFrom(stack);
            Pair<ResourceLocation, BlockPos> measuringTo = Companion.measuringTo(stack);
            if (measuringFrom != null) {
                Companion.finishMeasuring(measuringFrom, measuringTo, (Player)player, (BlockPos)pos, null);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ#\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\nJ%\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0004\b\u0010\u0010\u0011JQ\u0010\u0015\u001a\u00020\u000f2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lio/github/lucaargolo/kibe/item/MeasuringTape$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lkotlin/Pair;", "Lnet/minecraft/resources/ResourceLocation;", "Lnet/minecraft/core/BlockPos;", "measuringFrom", "(Lnet/minecraft/world/item/ItemStack;)Lkotlin/Pair;", "measuringTo", "Lnet/minecraft/world/level/Level;", "world", "pos", "", "startMeasuring", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V", "Lnet/minecraft/world/entity/player/Player;", "player", "lookPos", "finishMeasuring", "(Lkotlin/Pair;Lkotlin/Pair;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/item/ItemStack;)V", "fromPos", "toPos", "", "measureResult", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Ljava/lang/String;", "kibe"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Pair<ResourceLocation, BlockPos> measuringFrom(@NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            MeasuringData measuringData = (MeasuringData)stack.get(ComponentTypeCompendium.INSTANCE.getMEASURING_FROM());
            if (measuringData == null) {
                return null;
            }
            MeasuringData data = measuringData;
            return TuplesKt.to((Object)data.getMeasuringLevel(), (Object)data.getMeasuring().immutable());
        }

        @Nullable
        public final Pair<ResourceLocation, BlockPos> measuringTo(@NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            MeasuringData measuringData = (MeasuringData)stack.get(ComponentTypeCompendium.INSTANCE.getMEASURING_TO());
            if (measuringData == null) {
                return null;
            }
            MeasuringData data = measuringData;
            return TuplesKt.to((Object)data.getMeasuringLevel(), (Object)data.getMeasuring().immutable());
        }

        public final void startMeasuring(@NotNull ItemStack stack, @NotNull Level world, @NotNull BlockPos pos) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            stack.remove(ComponentTypeCompendium.INSTANCE.getMEASURING_TO());
            DataComponentType<MeasuringData> dataComponentType = ComponentTypeCompendium.INSTANCE.getMEASURING_FROM();
            ResourceLocation resourceLocation = world.dimension().location();
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getValue(...)");
            stack.set(dataComponentType, (Object)new MeasuringData(resourceLocation, pos));
        }

        public final void finishMeasuring(@NotNull Pair<ResourceLocation, ? extends BlockPos> measuringFrom, @Nullable Pair<ResourceLocation, ? extends BlockPos> measuringTo, @NotNull Player player, @NotNull BlockPos lookPos, @Nullable ItemStack stack) {
            block6: {
                ResourceLocation fromLevel;
                block8: {
                    BlockPos toPos;
                    block7: {
                        Object[] objectArray;
                        Intrinsics.checkNotNullParameter(measuringFrom, (String)"measuringFrom");
                        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                        Intrinsics.checkNotNullParameter((Object)lookPos, (String)"lookPos");
                        fromLevel = (ResourceLocation)measuringFrom.component1();
                        BlockPos fromPos = (BlockPos)measuringFrom.component2();
                        Pair<ResourceLocation, ? extends BlockPos> pair = measuringTo;
                        Object object = toPos = pair != null ? (BlockPos)pair.getSecond() : null;
                        if (!player.isShiftKeyDown()) {
                            if (!Intrinsics.areEqual((Object)fromLevel, (Object)player.level().dimension().location())) {
                                player.displayClientMessage((Component)Component.translatable((String)"chat.kibe.measuring_tape.measuring_between_dimensions").withStyle(ChatFormatting.RED), true);
                            } else if (toPos != null) {
                                objectArray = new Object[]{this.measureResult(fromPos, toPos)};
                                player.displayClientMessage((Component)Component.translatable((String)"chat.kibe.measuring_tape.result", (Object[])objectArray).withStyle(ChatFormatting.YELLOW), true);
                            } else {
                                objectArray = new Object[]{this.measureResult(fromPos, lookPos)};
                                player.displayClientMessage((Component)Component.translatable((String)"chat.kibe.measuring_tape.result", (Object[])objectArray).withStyle(ChatFormatting.BLUE), true);
                            }
                        }
                        if (player.level().isClientSide) break block6;
                        if (!player.isShiftKeyDown()) break block7;
                        objectArray = new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC};
                        player.displayClientMessage((Component)Component.translatable((String)"chat.kibe.measuring_tape.clear").withStyle((ChatFormatting[])objectArray), true);
                        ItemStack itemStack = stack;
                        if (itemStack != null) {
                            MeasuringData cfr_ignored_0 = (MeasuringData)itemStack.remove(ComponentTypeCompendium.INSTANCE.getMEASURING_FROM());
                        }
                        ItemStack itemStack2 = stack;
                        if (itemStack2 == null) break block6;
                        MeasuringData cfr_ignored_1 = (MeasuringData)itemStack2.remove(ComponentTypeCompendium.INSTANCE.getMEASURING_TO());
                        break block6;
                    }
                    if (toPos == null) break block8;
                    ItemStack itemStack = stack;
                    if (itemStack == null) break block6;
                    MeasuringData cfr_ignored_2 = (MeasuringData)itemStack.remove(ComponentTypeCompendium.INSTANCE.getMEASURING_TO());
                    break block6;
                }
                ItemStack itemStack = stack;
                if (itemStack == null) break block6;
                MeasuringData cfr_ignored_3 = (MeasuringData)itemStack.set(ComponentTypeCompendium.INSTANCE.getMEASURING_TO(), (Object)new MeasuringData(fromLevel, lookPos));
            }
        }

        private final String measureResult(BlockPos fromPos, BlockPos toPos) {
            String unit = Component.translatable((String)"chat.kibe.measuring_tape.unit").getString();
            double dist = (double)MathKt.roundToInt((double)(Vec3.atCenterOf((Vec3i)((Vec3i)fromPos)).distanceTo(Vec3.atCenterOf((Vec3i)((Vec3i)toPos))) * 100.0)) / 100.0;
            double distX = (double)Math.abs(fromPos.getX() - toPos.getX()) + 1.0;
            double distY = (double)Math.abs(fromPos.getY() - toPos.getY()) + 1.0;
            double distZ = (double)Math.abs(fromPos.getZ() - toPos.getZ()) + 1.0;
            String result = dist + "m";
            if (distX > 1.0) {
                result = result + " (x: " + distX + " " + unit + ")";
            }
            if (distY > 1.0) {
                result = result + " (y: " + distY + " " + unit + ")";
            }
            if (distZ > 1.0) {
                result = result + " (z: " + distZ + " " + unit + ")";
            }
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001a\u001a\u0004\b\u001b\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lio/github/lucaargolo/kibe/item/MeasuringTape$MeasuringData;", "", "Lnet/minecraft/resources/ResourceLocation;", "measuringLevel", "Lnet/minecraft/core/BlockPos;", "measuring", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/core/BlockPos;)V", "component1", "()Lnet/minecraft/resources/ResourceLocation;", "component2", "()Lnet/minecraft/core/BlockPos;", "copy", "(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/core/BlockPos;)Lio/github/lucaargolo/kibe/item/MeasuringTape$MeasuringData;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/resources/ResourceLocation;", "getMeasuringLevel", "Lnet/minecraft/core/BlockPos;", "getMeasuring", "Companion", "kibe"})
    public static final class MeasuringData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ResourceLocation measuringLevel;
        @NotNull
        private final BlockPos measuring;
        @NotNull
        private static final Codec<MeasuringData> CODEC;
        private static final StreamCodec<ByteBuf, MeasuringData> PACKET_CODEC;

        public MeasuringData(@NotNull ResourceLocation measuringLevel, @NotNull BlockPos measuring) {
            Intrinsics.checkNotNullParameter((Object)measuringLevel, (String)"measuringLevel");
            Intrinsics.checkNotNullParameter((Object)measuring, (String)"measuring");
            this.measuringLevel = measuringLevel;
            this.measuring = measuring;
        }

        @NotNull
        public final ResourceLocation getMeasuringLevel() {
            return this.measuringLevel;
        }

        @NotNull
        public final BlockPos getMeasuring() {
            return this.measuring;
        }

        @NotNull
        public final ResourceLocation component1() {
            return this.measuringLevel;
        }

        @NotNull
        public final BlockPos component2() {
            return this.measuring;
        }

        @NotNull
        public final MeasuringData copy(@NotNull ResourceLocation measuringLevel, @NotNull BlockPos measuring) {
            Intrinsics.checkNotNullParameter((Object)measuringLevel, (String)"measuringLevel");
            Intrinsics.checkNotNullParameter((Object)measuring, (String)"measuring");
            return new MeasuringData(measuringLevel, measuring);
        }

        public static /* synthetic */ MeasuringData copy$default(MeasuringData measuringData, ResourceLocation resourceLocation, BlockPos blockPos, int n, Object object) {
            if ((n & 1) != 0) {
                resourceLocation = measuringData.measuringLevel;
            }
            if ((n & 2) != 0) {
                blockPos = measuringData.measuring;
            }
            return measuringData.copy(resourceLocation, blockPos);
        }

        @NotNull
        public String toString() {
            return "MeasuringData(measuringLevel=" + this.measuringLevel + ", measuring=" + this.measuring + ")";
        }

        public int hashCode() {
            int result = this.measuringLevel.hashCode();
            result = result * 31 + this.measuring.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MeasuringData)) {
                return false;
            }
            MeasuringData measuringData = (MeasuringData)other;
            if (!Intrinsics.areEqual((Object)this.measuringLevel, (Object)measuringData.measuringLevel)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.measuring, (Object)measuringData.measuring);
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)ResourceLocation.CODEC.fieldOf("measuringLevel").forGetter(arg_0 -> MeasuringData.CODEC$lambda$0$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)BlockPos.CODEC.fieldOf("measuring").forGetter(arg_0 -> MeasuringData.CODEC$lambda$0$1((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0))).apply((Applicative)instance, MeasuringData::new);
        }

        private static final ResourceLocation CODEC$lambda$0$0(KProperty1 $tmp0, MeasuringData p0) {
            return (ResourceLocation)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final BlockPos CODEC$lambda$0$1(KProperty1 $tmp0, MeasuringData p0) {
            return (BlockPos)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final ResourceLocation PACKET_CODEC$lambda$0(KProperty1 $tmp0, MeasuringData p0) {
            return (ResourceLocation)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final BlockPos PACKET_CODEC$lambda$1(KProperty1 $tmp0, MeasuringData p0) {
            return (BlockPos)((Function1)$tmp0).invoke((Object)p0);
        }

        static {
            Codec codec = RecordCodecBuilder.create(MeasuringData::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
            PACKET_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, arg_0 -> MeasuringData.PACKET_CODEC$lambda$0((KProperty1)Companion.PACKET_CODEC.1.INSTANCE, arg_0), (StreamCodec)BlockPos.STREAM_CODEC, arg_0 -> MeasuringData.PACKET_CODEC$lambda$1((KProperty1)Companion.PACKET_CODEC.2.INSTANCE, arg_0), MeasuringData::new);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tRW\u0010\r\u001aB\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00050\u0005 \f* \u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\n0\n8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lio/github/lucaargolo/kibe/item/MeasuringTape$MeasuringData$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/Codec;", "Lio/github/lucaargolo/kibe/item/MeasuringTape$MeasuringData;", "CODEC", "Lcom/mojang/serialization/Codec;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "Lnet/minecraft/network/codec/StreamCodec;", "Lio/netty/buffer/ByteBuf;", "kotlin.jvm.PlatformType", "PACKET_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "getPACKET_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "kibe"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<MeasuringData> getCODEC() {
                return CODEC;
            }

            public final StreamCodec<ByteBuf, MeasuringData> getPACKET_CODEC() {
                return PACKET_CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/github/lucaargolo/kibe/item/MeasuringTape$PredicateProvider;", "Lnet/minecraft/client/renderer/item/ClampedItemPropertyFunction;", "<init>", "()V", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lnet/minecraft/client/multiplayer/ClientLevel;", "world", "Lnet/minecraft/world/entity/LivingEntity;", "entity", "", "seed", "", "unclampedCall", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/minecraft/world/entity/LivingEntity;I)F", "kibe"})
    public static final class PredicateProvider
    implements ClampedItemPropertyFunction {
        public float unclampedCall(@NotNull ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            if (stack.has(ComponentTypeCompendium.INSTANCE.getMEASURING_FROM())) {
                return 1.0f;
            }
            return 0.0f;
        }
    }
}

