/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.mixin;

import io.github.lucaargolo.kibe.entity.EntityCompendium;
import io.github.lucaargolo.kibe.entity.ThrownTorchEntity;
import io.github.lucaargolo.kibe.utils.SyncableBlockEntity;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public class ClientPlayNetworkHandlerMixin {
    @Shadow
    private ClientLevel level;
    @Shadow
    @Final
    private RegistryAccess.Frozen registryAccess;

    @Inject(at={@At(value="TAIL")}, method={"handleAddEntity(Lnet/minecraft/network/protocol/game/ClientboundAddEntityPacket;)V"})
    public void onEntitySpawn(ClientboundAddEntityPacket packet, CallbackInfo ci) {
        double x = packet.getX();
        double y = packet.getY();
        double z = packet.getZ();
        EntityType entityType = packet.getType();
        ThrownTorchEntity entity = null;
        if (entityType == EntityCompendium.INSTANCE.getTHROWN_TORCH()) {
            entity = new ThrownTorchEntity((Level)this.level, x, y, z);
        }
        if (entity != null) {
            int i = packet.getId();
            entity.syncPacketPositionCodec(x, y, z);
            entity.moveTo(x, y, z);
            entity.setXRot(packet.getXRot() * 360.0f / 256.0f);
            entity.setYRot(packet.getYRot() * 360.0f / 256.0f);
            entity.setId(i);
            entity.setUUID(packet.getUUID());
            this.level.addEntity((Entity)entity);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/BlockEntity;onDataPacket(Lnet/minecraft/network/Connection;Lnet/minecraft/network/protocol/game/ClientboundBlockEntityDataPacket;Lnet/minecraft/core/HolderLookup$Provider;)V")}, method={"lambda$handleBlockEntityData$5(Lnet/minecraft/network/protocol/game/ClientboundBlockEntityDataPacket;Lnet/minecraft/world/level/block/entity/BlockEntity;)V"}, cancellable=true)
    public void onBlockEntityUpdate(ClientboundBlockEntityDataPacket arg, BlockEntity blockEntity, CallbackInfo ci) {
        if (blockEntity instanceof SyncableBlockEntity) {
            ((SyncableBlockEntity)blockEntity).readClientNbt(arg.getTag(), (HolderLookup.Provider)this.registryAccess);
            ci.cancel();
        }
    }
}

