/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.mixin;

import io.github.lucaargolo.kibe.effect.EffectCompendium;
import io.github.lucaargolo.kibe.item.ItemCompendium;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Mob.class})
public abstract class MobEntityMixin
extends LivingEntity {
    protected MobEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(at={@At(value="HEAD")}, method={"requiresCustomPersistence()Z"}, cancellable=true)
    public void cannotDespawn(CallbackInfoReturnable<Boolean> info) {
        boolean isCursed = this.hasEffect((Holder)EffectCompendium.INSTANCE.getCURSED());
        if (isCursed) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;is(Lnet/minecraft/world/item/Item;)Z", ordinal=0)}, method={"checkAndHandleImportantInteractions(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    public void method_29506(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir, ItemStack itemStack) {
        InteractionResult actionResult;
        if ((itemStack.is((Item)ItemCompendium.INSTANCE.getGOLDEN_LASSO()) || itemStack.is((Item)ItemCompendium.INSTANCE.getCURSED_LASSO()) || itemStack.is((Item)ItemCompendium.INSTANCE.getDIAMOND_LASSO())) && (actionResult = itemStack.interactLivingEntity(player, (LivingEntity)this, hand)).consumesAction()) {
            cir.setReturnValue((Object)actionResult);
        }
    }
}

