/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.lucaargolo.kibe.utils.helper.GliderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public class PlayerEntityRendererMixin {
    @Inject(at={@At(value="HEAD")}, method={"render(Lnet/minecraft/client/player/AbstractClientPlayer;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"})
    private void renderPre(AbstractClientPlayer abstractClientPlayerEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, CallbackInfo info) {
        if (GliderHelper.INSTANCE.isPlayerGliding((Player)abstractClientPlayerEntity)) {
            float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
            float interpolatedYaw = abstractClientPlayerEntity.yHeadRotO + (abstractClientPlayerEntity.yHeadRot - abstractClientPlayerEntity.yHeadRotO) * partialTicks;
            matrixStack.pushPose();
            matrixStack.mulPose(Axis.YP.rotationDegrees(-interpolatedYaw));
            matrixStack.translate(0.0f, abstractClientPlayerEntity.getBbHeight() / 2.0f, 0.0f);
            matrixStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            matrixStack.translate(0.0f, -abstractClientPlayerEntity.getBbHeight() / 2.0f, 0.0f);
            matrixStack.mulPose(Axis.YP.rotationDegrees(interpolatedYaw));
            GliderHelper.INSTANCE.setPlayerRenderPoppingNeeds((Player)abstractClientPlayerEntity, true);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"render(Lnet/minecraft/client/player/AbstractClientPlayer;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"})
    private void renderPost(AbstractClientPlayer abstractClientPlayerEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, CallbackInfo info) {
        if (GliderHelper.INSTANCE.needsPlayerRenderPopping((Player)abstractClientPlayerEntity)) {
            matrixStack.popPose();
            GliderHelper.INSTANCE.setPlayerRenderPoppingNeeds((Player)abstractClientPlayerEntity, false);
        }
    }
}

