/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.blockentity;

import io.github.lucaargolo.kibe.block.BlockCompendium;
import io.github.lucaargolo.kibe.blockentity.BlockEntityCompendium;
import io.github.lucaargolo.kibe.utils.SyncableBlockEntity;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 R2\u00020\u00012\u00020\u0002:\u0002SRB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u001f\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0013\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u000fJ\u000f\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u001f\u0010\u001dJ!\u0010\"\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u00142\b\u0010!\u001a\u0004\u0018\u00010\u001bH\u0016\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010$\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b$\u0010%J\u0019\u0010(\u001a\u00020\u00172\b\u0010'\u001a\u0004\u0018\u00010&H\u0016\u00a2\u0006\u0004\b(\u0010)J\u0019\u0010-\u001a\u00020,2\b\u0010+\u001a\u0004\u0018\u00010*H\u0016\u00a2\u0006\u0004\b-\u0010.J)\u00100\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u001b2\b\u0010/\u001a\u0004\u0018\u00010*H\u0016\u00a2\u0006\u0004\b0\u00101J+\u00102\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00142\b\u0010!\u001a\u0004\u0018\u00010\u001b2\b\u0010/\u001a\u0004\u0018\u00010*H\u0016\u00a2\u0006\u0004\b2\u00101R(\u00104\u001a\b\u0012\u0004\u0012\u00020\u001b038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b4\u00105\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\"\u0010:\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\"\u0010@\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b@\u0010A\u001a\u0004\bB\u0010\u0016\"\u0004\bC\u0010DR\"\u0010\u0006\u001a\u00020E8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010F\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR\"\u0010L\u001a\u00020K8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bL\u0010M\u001a\u0004\bN\u0010O\"\u0004\bP\u0010Q\u00a8\u0006T"}, d2={"Lio/github/lucaargolo/kibe/blockentity/DrawbridgeBlockEntity;", "Lio/github/lucaargolo/kibe/utils/SyncableBlockEntity;", "Lnet/minecraft/world/WorldlyContainer;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Lnet/minecraft/nbt/CompoundTag;", "tag", "Lnet/minecraft/core/HolderLookup$Provider;", "registryLookup", "", "writeNbt", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)V", "readNbt", "writeClientNbt", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/nbt/CompoundTag;", "readClientNbt", "", "size", "()I", "", "isEmpty", "()Z", "slot", "Lnet/minecraft/world/item/ItemStack;", "getStack", "(I)Lnet/minecraft/world/item/ItemStack;", "amount", "removeStack", "(II)Lnet/minecraft/world/item/ItemStack;", "stack", "setStack", "(ILnet/minecraft/world/item/ItemStack;)V", "clear", "()V", "Lnet/minecraft/world/entity/player/Player;", "player", "canPlayerUse", "(Lnet/minecraft/world/entity/player/Player;)Z", "Lnet/minecraft/core/Direction;", "side", "", "getAvailableSlots", "(Lnet/minecraft/core/Direction;)[I", "dir", "canInsert", "(ILnet/minecraft/world/item/ItemStack;Lnet/minecraft/core/Direction;)Z", "canExtract", "Lnet/minecraft/core/NonNullList;", "inventory", "Lnet/minecraft/core/NonNullList;", "getInventory", "()Lnet/minecraft/core/NonNullList;", "setInventory", "(Lnet/minecraft/core/NonNullList;)V", "extendedStack", "Lnet/minecraft/world/item/ItemStack;", "getExtendedStack", "()Lnet/minecraft/world/item/ItemStack;", "setExtendedStack", "(Lnet/minecraft/world/item/ItemStack;)V", "extendedStacks", "I", "getExtendedStacks", "setExtendedStacks", "(I)V", "Lio/github/lucaargolo/kibe/blockentity/DrawbridgeBlockEntity$State;", "Lio/github/lucaargolo/kibe/blockentity/DrawbridgeBlockEntity$State;", "getState", "()Lio/github/lucaargolo/kibe/blockentity/DrawbridgeBlockEntity$State;", "setState", "(Lio/github/lucaargolo/kibe/blockentity/DrawbridgeBlockEntity$State;)V", "Lnet/minecraft/world/level/block/Block;", "lastCoverBlock", "Lnet/minecraft/world/level/block/Block;", "getLastCoverBlock", "()Lnet/minecraft/world/level/block/Block;", "setLastCoverBlock", "(Lnet/minecraft/world/level/block/Block;)V", "Companion", "State", "kibe"})
@SourceDebugExtension(value={"SMAP\nDrawbridgeBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DrawbridgeBlockEntity.kt\nio/github/lucaargolo/kibe/blockentity/DrawbridgeBlockEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,270:1\n1#2:271\n1740#3,3:272\n*S KotlinDebug\n*F\n+ 1 DrawbridgeBlockEntity.kt\nio/github/lucaargolo/kibe/blockentity/DrawbridgeBlockEntity\n*L\n107#1:272,3\n*E\n"})
public final class DrawbridgeBlockEntity
extends SyncableBlockEntity
implements WorldlyContainer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private NonNullList<ItemStack> inventory;
    @NotNull
    private ItemStack extendedStack;
    private int extendedStacks;
    @NotNull
    private State state;
    @NotNull
    private Block lastCoverBlock;

    public DrawbridgeBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(BlockEntityCompendium.INSTANCE.getDRAWBRIDGE(), pos, state);
        NonNullList nonNullList = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"ofSize(...)");
        this.inventory = nonNullList;
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.extendedStack = itemStack;
        this.state = State.CONTRACTED;
        this.lastCoverBlock = (Block)BlockCompendium.INSTANCE.getDRAWBRIDGE();
    }

    @NotNull
    public final NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public final void setInventory(@NotNull NonNullList<ItemStack> nonNullList) {
        Intrinsics.checkNotNullParameter(nonNullList, (String)"<set-?>");
        this.inventory = nonNullList;
    }

    @NotNull
    public final ItemStack getExtendedStack() {
        return this.extendedStack;
    }

    public final void setExtendedStack(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<set-?>");
        this.extendedStack = itemStack;
    }

    public final int getExtendedStacks() {
        return this.extendedStacks;
    }

    public final void setExtendedStacks(int n) {
        this.extendedStacks = n;
    }

    @NotNull
    public final State getState() {
        return this.state;
    }

    public final void setState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"<set-?>");
        this.state = state;
    }

    @NotNull
    public final Block getLastCoverBlock() {
        return this.lastCoverBlock;
    }

    public final void setLastCoverBlock(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"<set-?>");
        this.lastCoverBlock = block;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        super.saveAdditional(tag, registryLookup);
        tag.putString("state", this.state.name());
        tag.put("extendedStack", this.extendedStack.saveOptional(registryLookup));
        tag.putInt("extendedStacks", this.extendedStacks);
        ListTag nbtList = new ListTag();
        int n = ((Collection)this.inventory).size();
        for (int i = 0; i < n; ++i) {
            Object object = this.inventory.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            ItemStack itemStack = (ItemStack)object;
            CompoundTag nbtCompound = new CompoundTag();
            nbtCompound.putByte("Slot", (byte)i);
            boolean bl = !itemStack.isEmpty() ? nbtList.add((Object)itemStack.save(registryLookup, (Tag)nbtCompound)) : nbtList.add((Object)nbtCompound);
        }
        tag.put("Items", (Tag)nbtList);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registryLookup) {
        State state;
        DrawbridgeBlockEntity drawbridgeBlockEntity;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        super.loadAdditional(tag, registryLookup);
        DrawbridgeBlockEntity drawbridgeBlockEntity2 = this;
        try {
            drawbridgeBlockEntity = drawbridgeBlockEntity2;
            String string = tag.getString("state");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            state = State.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            drawbridgeBlockEntity = drawbridgeBlockEntity2;
            state = State.CONTRACTED;
        }
        drawbridgeBlockEntity.state = state;
        ItemStack itemStack = ItemStack.parseOptional((HolderLookup.Provider)registryLookup, (CompoundTag)tag.getCompound("extendedStack"));
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"fromNbtOrEmpty(...)");
        this.extendedStack = itemStack;
        this.extendedStacks = tag.getInt("extendedBlocks");
        ListTag listTag = tag.getList("Items", 10);
        Intrinsics.checkNotNullExpressionValue((Object)listTag, (String)"getList(...)");
        ListTag nbtList = listTag;
        int n = ((Collection)nbtList).size();
        for (int i = 0; i < n; ++i) {
            CompoundTag nbtCompound = nbtList.getCompound(i);
            int j = nbtCompound.getByte("Slot") & 0xFF;
            if (j >= this.inventory.size()) continue;
            if (nbtCompound.contains("id")) {
                this.inventory.set(j, (Object)ItemStack.parse((HolderLookup.Provider)registryLookup, (Tag)((Tag)nbtCompound)).orElse(ItemStack.EMPTY));
                continue;
            }
            this.inventory.set(j, (Object)ItemStack.EMPTY);
        }
    }

    @Override
    @NotNull
    public CompoundTag writeClientNbt(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registryLookup) {
        CompoundTag compoundTag;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        CompoundTag it = compoundTag = tag;
        boolean bl = false;
        this.saveAdditional(it, registryLookup);
        return compoundTag;
    }

    @Override
    public void readClientNbt(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        this.loadAdditional(tag, registryLookup);
        Minecraft.getInstance().levelRenderer.blockChanged((BlockGetter)this.level, this.worldPosition, this.getBlockState(), this.getBlockState(), 0);
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public boolean isEmpty() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = (Iterable)this.inventory;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ItemStack it = (ItemStack)element$iv;
                    boolean bl2 = false;
                    if (it.isEmpty()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public ItemStack getItem(int slot) {
        Object object = this.inventory.get(slot);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ItemStack)object;
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemStack = ContainerHelper.removeItem((List)((List)this.inventory), (int)slot, (int)amount);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"splitStack(...)");
        return itemStack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack itemStack = ContainerHelper.takeItem((List)((List)this.inventory), (int)slot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"removeStack(...)");
        return itemStack;
    }

    public void setItem(int slot, @Nullable ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
        ItemStack itemStack = stack;
        Intrinsics.checkNotNull((Object)itemStack);
        if (itemStack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
    }

    public void clearContent() {
        this.inventory.clear();
    }

    public boolean stillValid(@Nullable Player player) {
        boolean bl;
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        if (!Intrinsics.areEqual((Object)level.getBlockEntity(this.worldPosition), (Object)((Object)this))) {
            bl = false;
        } else {
            Player player2 = player;
            Intrinsics.checkNotNull((Object)player2);
            bl = player2.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
        }
        return bl;
    }

    @NotNull
    public int[] getSlotsForFace(@Nullable Direction side) {
        int[] nArray = new int[]{0};
        return nArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canPlaceItemThroughFace(int slot, @NotNull ItemStack stack, @Nullable Direction dir) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!(stack.getItem() instanceof BlockItem)) return false;
        Item item = stack.getItem();
        Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type net.minecraft.item.BlockItem");
        if (!((BlockItem)item).getBlock().defaultBlockState().isCollisionShapeFullBlock((BlockGetter)this.level, this.worldPosition)) return false;
        return true;
    }

    public boolean canTakeItemThroughFace(int slot, @Nullable ItemStack stack, @Nullable Direction dir) {
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lio/github/lucaargolo/kibe/blockentity/DrawbridgeBlockEntity$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lio/github/lucaargolo/kibe/blockentity/DrawbridgeBlockEntity;", "blockEntity", "", "tick", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lio/github/lucaargolo/kibe/blockentity/DrawbridgeBlockEntity;)V", "Lnet/minecraft/server/level/ServerLevel;", "Lnet/minecraft/world/item/ItemStack;", "stackFromLootTable", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/item/ItemStack;", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/item/ItemStack;", "kibe"})
    public static final class Companion {
        private Companion() {
        }

        public final void tick(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull DrawbridgeBlockEntity blockEntity) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            if (world.isClientSide || world.getGameTime() % (long)8 != 0L) {
                return;
            }
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            Object object = blockEntity.getInventory().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            ItemStack stack = (ItemStack)object;
            boolean hasSpace = stack.isEmpty() || stack.getCount() < stack.getMaxStackSize();
            block0 : switch (WhenMappings.$EnumSwitchMapping$0[blockEntity.getState().ordinal()]) {
                case 1: {
                    if (world.hasNeighborSignal(pos)) break;
                    blockEntity.setState(State.CONTRACTING);
                    break;
                }
                case 2: {
                    if (!world.hasNeighborSignal(pos)) {
                        blockEntity.setState(State.CONTRACTING);
                    }
                    if (!stack.isEmpty()) {
                        for (int it = 1; it < 65; ++it) {
                            BlockPos itPos = pos.offset(new Vec3i(facing.getNormal().getX() * it, facing.getNormal().getY() * it, facing.getNormal().getZ() * it));
                            BlockState itState = world.getBlockState(itPos);
                            Block itBlock = itState.getBlock();
                            ServerLevel serverLevel = (ServerLevel)world;
                            Intrinsics.checkNotNull((Object)itPos);
                            Intrinsics.checkNotNull((Object)itState);
                            ItemStack itStack = this.stackFromLootTable(serverLevel, itPos, itState);
                            if (itBlock instanceof AirBlock) {
                                if (it != blockEntity.getExtendedStacks() + 1) {
                                    blockEntity.setState(State.EXTENDED);
                                    break block0;
                                }
                                if (!ItemStack.isSameItemSameComponents((ItemStack)blockEntity.getExtendedStack(), (ItemStack)stack)) {
                                    ItemStack itemStack = stack.copy();
                                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
                                    blockEntity.setExtendedStack(itemStack);
                                    blockEntity.setExtendedStacks(0);
                                }
                                int n = blockEntity.getExtendedStacks();
                                blockEntity.setExtendedStacks(n + 1);
                                FakePlayer fakePlayer = FakePlayer.get((ServerLevel)((ServerLevel)world));
                                fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, stack);
                                Vec3 fakeHitPos = new Vec3((double)itPos.getX() + 0.5, (double)itPos.getY() + 0.0, (double)itPos.getZ() + 0.5);
                                Item item = stack.getItem();
                                BlockItem blockItem = item instanceof BlockItem ? (BlockItem)item : null;
                                if (blockItem != null) {
                                    blockItem.useOn(new UseOnContext((Player)fakePlayer, InteractionHand.MAIN_HAND, new BlockHitResult(fakeHitPos, facing.getOpposite(), itPos, false)));
                                }
                                ((ServerLevel)world).playSound(null, itPos, SoundEvents.PISTON_EXTEND, SoundSource.BLOCKS, 1.0f, world.random.nextFloat() * 0.25f + 0.6f);
                                break block0;
                            }
                            if (!ItemStack.isSameItemSameComponents((ItemStack)itStack, (ItemStack)stack)) {
                                blockEntity.setState(State.EXTENDED);
                                break block0;
                            }
                            if (it != 64) continue;
                            blockEntity.setState(State.EXTENDED);
                        }
                        break;
                    }
                    blockEntity.setState(State.EXTENDED);
                    break;
                }
                case 3: {
                    if (!world.hasNeighborSignal(pos)) break;
                    blockEntity.setState(State.EXTENDING);
                    break;
                }
                case 4: {
                    if (world.hasNeighborSignal(pos)) {
                        blockEntity.setState(State.EXTENDING);
                    }
                    if (!hasSpace) break;
                    BlockPos furthestPos = pos;
                    ItemStack furthestStack = ItemStack.EMPTY;
                    ItemStack selectedStack = stack;
                    for (int it = 1; it < 65; ++it) {
                        BlockPos itPos = pos.offset(new Vec3i(facing.getNormal().getX() * it, facing.getNormal().getY() * it, facing.getNormal().getZ() * it));
                        ServerLevel serverLevel = (ServerLevel)world;
                        Intrinsics.checkNotNull((Object)itPos);
                        ItemStack itStack = this.stackFromLootTable(serverLevel, itPos);
                        if (selectedStack.isEmpty()) {
                            selectedStack = itStack;
                        }
                        if (!ItemStack.isSameItemSameComponents((ItemStack)blockEntity.getExtendedStack(), (ItemStack)selectedStack) || it > blockEntity.getExtendedStacks()) break;
                        if (itStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)selectedStack, (ItemStack)itStack)) {
                            if (it != 1) break;
                            blockEntity.setState(State.CONTRACTED);
                            break;
                        }
                        furthestPos = itPos;
                        furthestStack = itStack;
                    }
                    if (Intrinsics.areEqual((Object)furthestPos, (Object)pos)) break;
                    if (((ItemStack)blockEntity.getInventory().get(0)).isEmpty()) {
                        blockEntity.getInventory().set(0, (Object)furthestStack);
                    } else {
                        ((ItemStack)blockEntity.getInventory().get(0)).grow(1);
                    }
                    int n = blockEntity.getExtendedStacks();
                    blockEntity.setExtendedStacks(n + -1);
                    world.destroyBlock(furthestPos, false);
                    world.playSound(null, furthestPos, SoundEvents.PISTON_CONTRACT, SoundSource.BLOCKS, 1.0f, world.random.nextFloat() * 0.25f + 0.6f);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        private final ItemStack stackFromLootTable(ServerLevel world, BlockPos pos) {
            BlockState state = world.getBlockState(pos);
            Intrinsics.checkNotNull((Object)state);
            return this.stackFromLootTable(world, pos, state);
        }

        private final ItemStack stackFromLootTable(ServerLevel world, BlockPos pos, BlockState state) {
            ItemStack itemStack;
            BlockEntity entity = world.getBlockEntity(pos);
            ItemStack it = itemStack = Items.STICK.getDefaultInstance();
            boolean bl = false;
            it.enchant((Holder)world.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(Enchantments.SILK_TOUCH).get(), 1);
            ItemStack silkTouch = itemStack;
            List list = Block.getDrops((BlockState)state, (ServerLevel)world, (BlockPos)pos, (BlockEntity)entity, (Entity)((Entity)FakePlayer.get((ServerLevel)world)), (ItemStack)silkTouch);
            if (list.size() == 1) {
                Intrinsics.checkNotNull((Object)list);
                ItemStack stack = (ItemStack)CollectionsKt.first((List)list);
                if (stack.getCount() == 1 && stack.getItem() instanceof BlockItem) {
                    Intrinsics.checkNotNull((Object)stack);
                    return stack;
                }
            }
            ItemStack itemStack2 = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"EMPTY");
            return itemStack2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[State.values().length];
                try {
                    nArray[State.EXTENDED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.EXTENDING.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.CONTRACTED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.CONTRACTING.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lio/github/lucaargolo/kibe/blockentity/DrawbridgeBlockEntity$State;", "", "<init>", "(Ljava/lang/String;I)V", "CONTRACTED", "CONTRACTING", "EXTENDING", "EXTENDED", "kibe"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State CONTRACTED = new State();
        public static final /* enum */ State CONTRACTING = new State();
        public static final /* enum */ State EXTENDING = new State();
        public static final /* enum */ State EXTENDED = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.CONTRACTED, State.CONTRACTING, State.EXTENDING, State.EXTENDED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

