/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.blockentity;

import io.github.lucaargolo.kibe.blockentity.BlockEntityCompendium;
import io.github.lucaargolo.kibe.blockentity.EntangledChestEntity;
import io.github.lucaargolo.kibe.data.component.ComponentTypeCompendium;
import io.github.lucaargolo.kibe.data.state.EntangledChestState;
import io.github.lucaargolo.kibe.utils.SyncableBlockEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0013\u0018\u0000 Z2\u00020\u00012\u00020\u0002:\u0001ZB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0011\u0010\r\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0014\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u001f\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0014\u00a2\u0006\u0004\b\u001c\u0010\u001aJ\u001f\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010!\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u001fH\u0014\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010%\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020#H\u0014\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010(\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u0015H\u0017\u00a2\u0006\u0004\b(\u0010)J\u000f\u0010*\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b*\u0010\u0014J\u000f\u0010+\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b+\u0010\u000bJ\u0017\u0010.\u001a\u00020-2\u0006\u0010,\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b.\u0010/J\u001f\u00101\u001a\u00020-2\u0006\u0010,\u001a\u00020\u00122\u0006\u00100\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b1\u00102J\u0017\u00101\u001a\u00020-2\u0006\u0010,\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b1\u0010/J!\u00104\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020\u00122\b\u00103\u001a\u0004\u0018\u00010-H\u0016\u00a2\u0006\u0004\b4\u00105J\u000f\u00106\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b6\u0010\u0011J\u0019\u00109\u001a\u00020\t2\b\u00108\u001a\u0004\u0018\u000107H\u0016\u00a2\u0006\u0004\b9\u0010:R(\u0010<\u001a\b\u0012\u0004\u0012\u00020-0;8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b<\u0010=\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\u001d\u0010D\u001a\b\u0012\u0004\u0012\u00020C0B8\u0006\u00a2\u0006\f\n\u0004\bD\u0010E\u001a\u0004\bF\u0010GR\u0011\u0010K\u001a\u00020H8F\u00a2\u0006\u0006\u001a\u0004\bI\u0010JR\"\u0010L\u001a\u00020H8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bL\u0010M\u001a\u0004\bN\u0010J\"\u0004\bO\u0010PR\"\u0010Q\u001a\u00020H8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bQ\u0010M\u001a\u0004\bR\u0010J\"\u0004\bS\u0010PR\u0016\u0010T\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bT\u0010UR\"\u0010V\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bV\u0010W\u001a\u0004\bV\u0010\u000b\"\u0004\bX\u0010Y\u00a8\u0006["}, d2={"Lio/github/lucaargolo/kibe/blockentity/EntangledChestEntity;", "Lio/github/lucaargolo/kibe/utils/SyncableBlockEntity;", "Lnet/minecraft/world/Container;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "", "hasPersistentState", "()Z", "Lio/github/lucaargolo/kibe/data/state/EntangledChestState;", "getPersistentState", "()Lio/github/lucaargolo/kibe/data/state/EntangledChestState;", "", "markDirty", "()V", "", "getComparatorOutput", "()I", "Lnet/minecraft/nbt/CompoundTag;", "tag", "Lnet/minecraft/core/HolderLookup$Provider;", "registryLookup", "readNbt", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)V", "readClientNbt", "writeNbt", "writeClientNbt", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/nbt/CompoundTag;", "Lnet/minecraft/core/component/DataComponentMap$Builder;", "builder", "addComponents", "(Lnet/minecraft/core/component/DataComponentMap$Builder;)V", "Lnet/minecraft/world/level/block/entity/BlockEntity$DataComponentInput;", "components", "readComponents", "(Lnet/minecraft/world/level/block/entity/BlockEntity$DataComponentInput;)V", "nbt", "removeFromCopiedStackNbt", "(Lnet/minecraft/nbt/CompoundTag;)V", "size", "isEmpty", "slot", "Lnet/minecraft/world/item/ItemStack;", "getStack", "(I)Lnet/minecraft/world/item/ItemStack;", "amount", "removeStack", "(II)Lnet/minecraft/world/item/ItemStack;", "stack", "setStack", "(ILnet/minecraft/world/item/ItemStack;)V", "clear", "Lnet/minecraft/world/entity/player/Player;", "player", "canPlayerUse", "(Lnet/minecraft/world/entity/player/Player;)Z", "Lnet/minecraft/core/NonNullList;", "inventory", "Lnet/minecraft/core/NonNullList;", "getInventory", "()Lnet/minecraft/core/NonNullList;", "setInventory", "(Lnet/minecraft/core/NonNullList;)V", "", "Lnet/minecraft/world/item/DyeColor;", "runeColors", "[Lnet/minecraft/world/item/DyeColor;", "getRuneColors", "()[Lnet/minecraft/world/item/DyeColor;", "", "getColorCode", "()Ljava/lang/String;", "colorCode", "key", "Ljava/lang/String;", "getKey", "setKey", "(Ljava/lang/String;)V", "owner", "getOwner", "setOwner", "lastComparatorOutput", "I", "isBeingCompared", "Z", "setBeingCompared", "(Z)V", "Companion", "kibe"})
@SourceDebugExtension(value={"SMAP\nEntangledChestEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntangledChestEntity.kt\nio/github/lucaargolo/kibe/blockentity/EntangledChestEntity\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n11561#2:188\n11896#2,3:189\n13870#2,3:196\n13870#2,3:199\n1869#3,2:192\n1869#3,2:194\n1878#3,3:202\n1869#3,2:206\n1740#3,3:208\n1#4:205\n*S KotlinDebug\n*F\n+ 1 EntangledChestEntity.kt\nio/github/lucaargolo/kibe/blockentity/EntangledChestEntity\n*L\n28#1:188\n28#1:189,3\n79#1:196,3\n97#1:199,3\n60#1:192,2\n70#1:194,2\n112#1:202,3\n121#1:206,2\n135#1:208,3\n*E\n"})
public final class EntangledChestEntity
extends SyncableBlockEntity
implements Container {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private NonNullList<ItemStack> inventory;
    @NotNull
    private final DyeColor[] runeColors;
    @NotNull
    private String key;
    @NotNull
    private String owner;
    private int lastComparatorOutput;
    private boolean isBeingCompared;

    public EntangledChestEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(BlockEntityCompendium.INSTANCE.getENTANGLED_CHEST(), pos, state);
        NonNullList nonNullList = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"ofSize(...)");
        this.inventory = nonNullList;
        DyeColor[] dyeColorArray = new DyeColor[]{DyeColor.WHITE, DyeColor.WHITE, DyeColor.WHITE, DyeColor.WHITE, DyeColor.WHITE, DyeColor.WHITE, DyeColor.WHITE, DyeColor.WHITE};
        this.runeColors = dyeColorArray;
        this.key = "entangledchest-global";
        this.owner = "";
    }

    @NotNull
    public final NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public final void setInventory(@NotNull NonNullList<ItemStack> nonNullList) {
        Intrinsics.checkNotNullParameter(nonNullList, (String)"<set-?>");
        this.inventory = nonNullList;
    }

    @NotNull
    public final DyeColor[] getRuneColors() {
        return this.runeColors;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getColorCode() {
        void $this$mapTo$iv$iv;
        DyeColor[] $this$map$iv = this.runeColors;
        boolean $i$f$map = false;
        DyeColor[] dyeColorArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void p0;
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getId());
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, (Function1)colorCode.2.INSTANCE, (int)30, null);
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    public final void setKey(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.key = string;
    }

    @NotNull
    public final String getOwner() {
        return this.owner;
    }

    public final void setOwner(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.owner = string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasPersistentState() {
        if (!this.hasLevel()) return false;
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        if (level.isClientSide) return false;
        return true;
    }

    private final EntangledChestState getPersistentState() {
        EntangledChestState entangledChestState;
        Level level = this.level;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel != null) {
            ServerLevel serverWorld = serverLevel;
            boolean bl = false;
            MinecraftServer minecraftServer = serverWorld.getServer();
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
            entangledChestState = EntangledChestState.Companion.getPersistentState(minecraftServer, this.key);
        } else {
            entangledChestState = null;
        }
        return entangledChestState;
    }

    public void setChanged() {
        if (this.hasPersistentState()) {
            EntangledChestState entangledChestState = this.getPersistentState();
            Intrinsics.checkNotNull((Object)((Object)entangledChestState));
            entangledChestState.setDirty();
        }
        super.setChanged();
    }

    public final boolean isBeingCompared() {
        return this.isBeingCompared;
    }

    public final void setBeingCompared(boolean bl) {
        this.isBeingCompared = bl;
    }

    public final int getComparatorOutput() {
        Intrinsics.checkNotNull((Object)((Object)this), (String)"null cannot be cast to non-null type net.minecraft.inventory.Inventory");
        int comparatorOutput = AbstractContainerMenu.getRedstoneSignalFromContainer((Container)this);
        this.isBeingCompared = true;
        this.lastComparatorOutput = comparatorOutput;
        return comparatorOutput;
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        super.loadAdditional(tag, registryLookup);
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)this.runeColors.length);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int idx = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            DyeColor dyeColor = DyeColor.byName((String)tag.getString("rune" + (idx + 1)), (DyeColor)DyeColor.WHITE);
            if (dyeColor == null) {
                dyeColor = DyeColor.WHITE;
            }
            this.runeColors[idx] = dyeColor;
        }
        String string = tag.getString("key");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        this.key = string;
        String string2 = tag.getString("owner");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        this.owner = string2;
        this.isBeingCompared = tag.getBoolean("isBeingCompared");
        this.lastComparatorOutput = tag.getInt("lastComparatorOutput");
    }

    @Override
    public void readClientNbt(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)this.runeColors.length);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int idx = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            DyeColor dyeColor = DyeColor.byName((String)tag.getString("rune" + (idx + 1)), (DyeColor)DyeColor.WHITE);
            if (dyeColor == null) {
                dyeColor = DyeColor.WHITE;
            }
            this.runeColors[idx] = dyeColor;
        }
        String string = tag.getString("key");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        this.key = string;
        String string2 = tag.getString("owner");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        this.owner = string2;
    }

    /*
     * WARNING - void declaration
     */
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        super.saveAdditional(tag, registryLookup);
        DyeColor[] $this$forEachIndexed$iv = this.runeColors;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (DyeColor item$iv : $this$forEachIndexed$iv) {
            void col;
            int n = index$iv++;
            DyeColor dyeColor = item$iv;
            int idx = n;
            boolean bl = false;
            tag.putString("rune" + (idx + 1), col.getName());
        }
        tag.putString("key", this.key);
        tag.putString("owner", this.owner);
        tag.putBoolean("isBeingCompared", this.isBeingCompared);
        tag.putInt("lastComparatorOutput", this.lastComparatorOutput);
        if (this.hasPersistentState()) {
            CompoundTag subTag = new CompoundTag();
            EntangledChestState entangledChestState = this.getPersistentState();
            Intrinsics.checkNotNull((Object)((Object)entangledChestState));
            subTag = entangledChestState.save(subTag, registryLookup);
            if (subTag.get(this.getColorCode()) != null) {
                Tag tag2 = subTag.get(this.getColorCode());
                Intrinsics.checkNotNull((Object)tag2, (String)"null cannot be cast to non-null type net.minecraft.nbt.NbtCompound");
                subTag = (CompoundTag)tag2;
                tag.put("Items", subTag.get("Items"));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompoundTag writeClientNbt(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        DyeColor[] $this$forEachIndexed$iv = this.runeColors;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (DyeColor item$iv : $this$forEachIndexed$iv) {
            void col;
            int n = index$iv++;
            DyeColor dyeColor = item$iv;
            int idx = n;
            boolean bl = false;
            tag.putString("rune" + (idx + 1), col.getName());
        }
        tag.putString("key", this.key);
        tag.putString("owner", this.owner);
        return tag;
    }

    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.set(ComponentTypeCompendium.INSTANCE.getRUNE_SET(), (Object)ArraysKt.toList((Object[])this.runeColors));
        builder.set(ComponentTypeCompendium.INSTANCE.getENTANGLED_KEY(), (Object)this.key);
        builder.set(ComponentTypeCompendium.INSTANCE.getOWNER(), (Object)this.owner);
    }

    /*
     * WARNING - void declaration
     */
    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput components) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)components, (String)"components");
            List list = (List)components.get(ComponentTypeCompendium.INSTANCE.getRUNE_SET());
            if (list != null) {
                Iterable $this$forEachIndexed$iv = list;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void component;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    DyeColor dyeColor = (DyeColor)item$iv;
                    int index = n;
                    boolean bl = false;
                    this.runeColors[index] = component;
                }
            }
            String string = (String)components.get(ComponentTypeCompendium.INSTANCE.getENTANGLED_KEY());
            if (string != null) {
                String it = string;
                boolean bl = false;
                this.key = it;
            }
            String string2 = (String)components.get(ComponentTypeCompendium.INSTANCE.getOWNER());
            if (string2 == null) break block4;
            String it = string2;
            boolean bl = false;
            this.owner = it;
        }
    }

    @Deprecated(message="Deprecated in Java", replaceWith=@ReplaceWith(expression="nbt.remove(\"Items\")", imports={}))
    public void removeComponentsFromTag(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Iterable $this$forEach$iv = (Iterable)new IntRange(1, 8);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            nbt.remove("rune" + it);
        }
        nbt.remove("key");
        nbt.remove("owner");
    }

    public int getContainerSize() {
        int n;
        if (this.hasPersistentState()) {
            EntangledChestState entangledChestState = this.getPersistentState();
            Intrinsics.checkNotNull((Object)((Object)entangledChestState));
            n = entangledChestState.size(this.getColorCode());
        } else {
            n = this.inventory.size();
        }
        return n;
    }

    public boolean isEmpty() {
        boolean bl;
        block5: {
            if (this.hasPersistentState()) {
                EntangledChestState entangledChestState = this.getPersistentState();
                Intrinsics.checkNotNull((Object)((Object)entangledChestState));
                bl = entangledChestState.isEmpty(this.getColorCode());
            } else {
                Iterable $this$all$iv = (Iterable)this.inventory;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        ItemStack it = (ItemStack)element$iv;
                        boolean bl2 = false;
                        if (it.isEmpty()) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
        }
        return bl;
    }

    @NotNull
    public ItemStack getItem(int slot) {
        ItemStack itemStack;
        if (this.hasPersistentState()) {
            EntangledChestState entangledChestState = this.getPersistentState();
            Intrinsics.checkNotNull((Object)((Object)entangledChestState));
            itemStack = entangledChestState.getStack(slot, this.getColorCode());
        } else {
            Object object = this.inventory.get(slot);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            itemStack = (ItemStack)object;
        }
        return itemStack;
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemStack;
        if (this.hasPersistentState()) {
            EntangledChestState entangledChestState = this.getPersistentState();
            Intrinsics.checkNotNull((Object)((Object)entangledChestState));
            itemStack = entangledChestState.removeStack(slot, amount, this.getColorCode());
        } else {
            ItemStack itemStack2 = ContainerHelper.removeItem((List)((List)this.inventory), (int)slot, (int)amount);
            itemStack = itemStack2;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"splitStack(...)");
        }
        return itemStack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack itemStack;
        if (this.hasPersistentState()) {
            EntangledChestState entangledChestState = this.getPersistentState();
            Intrinsics.checkNotNull((Object)((Object)entangledChestState));
            itemStack = entangledChestState.removeStack(slot, this.getColorCode());
        } else {
            ItemStack itemStack2 = ContainerHelper.takeItem((List)((List)this.inventory), (int)slot);
            itemStack = itemStack2;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"removeStack(...)");
        }
        return itemStack;
    }

    public void setItem(int slot, @Nullable ItemStack stack) {
        if (this.hasPersistentState()) {
            EntangledChestState entangledChestState = this.getPersistentState();
            Intrinsics.checkNotNull((Object)((Object)entangledChestState));
            entangledChestState.setStack(slot, stack, this.getColorCode());
        } else {
            this.inventory.set(slot, (Object)stack);
            ItemStack itemStack = stack;
            Intrinsics.checkNotNull((Object)itemStack);
            if (itemStack.getCount() > this.getMaxStackSize()) {
                stack.setCount(this.getMaxStackSize());
            }
        }
    }

    public void clearContent() {
        this.inventory.clear();
    }

    public boolean stillValid(@Nullable Player player) {
        boolean bl;
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        if (!Intrinsics.areEqual((Object)level.getBlockEntity(this.worldPosition), (Object)((Object)this))) {
            bl = false;
        } else {
            Player player2 = player;
            Intrinsics.checkNotNull((Object)player2);
            bl = player2.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
        }
        return bl;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/github/lucaargolo/kibe/blockentity/EntangledChestEntity$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lio/github/lucaargolo/kibe/blockentity/EntangledChestEntity;", "entity", "", "tick", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lio/github/lucaargolo/kibe/blockentity/EntangledChestEntity;)V", "kibe"})
    public static final class Companion {
        private Companion() {
        }

        public final void tick(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull EntangledChestEntity entity) {
            int comparatorOutput;
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
            if (!world.isClientSide && entity.isBeingCompared() && (comparatorOutput = AbstractContainerMenu.getRedstoneSignalFromContainer((Container)entity)) != entity.lastComparatorOutput) {
                world.updateNeighbourForOutputSignal(pos, state.getBlock());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

