/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.client.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.lucaargolo.kibe.blockentity.TankBlockEntity;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001)B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J?\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0087\u0001\u0010&\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b&\u0010'R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010(\u00a8\u0006*"}, d2={"Lio/github/lucaargolo/kibe/client/blockentity/TankBlockEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Lio/github/lucaargolo/kibe/blockentity/TankBlockEntity;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "arg", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "entity", "", "tickDelta", "Lcom/mojang/blaze3d/vertex/PoseStack;", "matrices", "Lnet/minecraft/client/renderer/MultiBufferSource;", "vertexConsumers", "", "light", "overlay", "", "render", "(Lio/github/lucaargolo/kibe/blockentity/TankBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "bb", "Lcom/mojang/blaze3d/vertex/PoseStack$Pose;", "entry", "Lorg/joml/Vector3f;", "normal", "Ljava/awt/Color;", "color", "Lio/github/lucaargolo/kibe/client/blockentity/TankBlockEntityRenderer$UV;", "uv", "f", "g", "h", "i", "j", "k", "l", "m", "renderVertices", "(Lcom/mojang/blaze3d/vertex/VertexConsumer;Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lorg/joml/Vector3f;Ljava/awt/Color;IILio/github/lucaargolo/kibe/client/blockentity/TankBlockEntityRenderer$UV;FFFFFFFF)V", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "UV", "kibe"})
public final class TankBlockEntityRenderer
implements BlockEntityRenderer<TankBlockEntity> {
    @NotNull
    private final BlockEntityRendererProvider.Context arg;

    public TankBlockEntityRenderer(@NotNull BlockEntityRendererProvider.Context arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        this.arg = arg;
    }

    public void render(@NotNull TankBlockEntity entity, float tickDelta, @NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)vertexConsumers, (String)"vertexConsumers");
        FluidVariant fluid = (FluidVariant)entity.getTank().variant;
        int fluidColor = FluidVariantRendering.getColor((FluidVariant)fluid, (BlockAndTintGetter)((BlockAndTintGetter)entity.getLevel()), (BlockPos)entity.getBlockPos());
        TextureAtlasSprite textureAtlasSprite = FluidVariantRendering.getSprite((FluidVariant)fluid);
        if (textureAtlasSprite == null) {
            return;
        }
        TextureAtlasSprite sprite = textureAtlasSprite;
        Color color = new Color(fluidColor >> 16 & 0xFF, fluidColor >> 8 & 0xFF, fluidColor & 0xFF);
        RenderType renderLayer = !Intrinsics.areEqual((Object)fluid, (Object)Fluids.EMPTY) ? (Minecraft.useShaderTransparency() ? RenderType.solid() : ItemBlockRenderTypes.getRenderLayer((FluidState)fluid.getFluid().defaultFluidState())) : RenderType.entityTranslucent((ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        VertexConsumer bb = vertexConsumers.getBuffer(renderLayer);
        PoseStack.Pose entry = matrices.last();
        Vector3f normal = Direction.NORTH.step();
        float p = Mth.lerp((float)tickDelta, (float)entity.getLastRenderedFluid(), (float)((float)entity.getTank().amount / 81000.0f));
        entity.setLastRenderedFluid(p);
        UV partUv = new UV(sprite);
        partUv.setMaxV(partUv.getMaxV() - (sprite.getV1() - sprite.getV0()) * ((16.0f - p) / 16.0f));
        p = Mth.clamp((float)(p / 16.0f), (float)0.001f, (float)0.999f);
        Intrinsics.checkNotNull((Object)bb);
        Intrinsics.checkNotNull((Object)entry);
        Intrinsics.checkNotNull((Object)normal);
        this.renderVertices(bb, entry, normal, color, overlay, light, partUv, 0.001f, 0.999f, 0.001f, p, 0.999f, 0.999f, 0.999f, 0.999f);
        this.renderVertices(bb, entry, normal, color, overlay, light, partUv, 0.001f, 0.999f, p, 0.001f, 0.001f, 0.001f, 0.001f, 0.001f);
        this.renderVertices(bb, entry, normal, color, overlay, light, partUv, 0.999f, 0.999f, p, 0.001f, 0.001f, 0.999f, 0.999f, 0.001f);
        this.renderVertices(bb, entry, normal, color, overlay, light, partUv, 0.001f, 0.001f, 0.001f, p, 0.001f, 0.999f, 0.999f, 0.001f);
        UV fullUv = new UV(sprite);
        this.renderVertices(bb, entry, normal, color, overlay, light, fullUv, 0.001f, 0.999f, 0.001f, 0.001f, 0.001f, 0.001f, 0.999f, 0.999f);
        this.renderVertices(bb, entry, normal, color, overlay, light, fullUv, 0.001f, 0.999f, p, p, 0.999f, 0.999f, 0.001f, 0.001f);
    }

    private final void renderVertices(VertexConsumer bb, PoseStack.Pose entry, Vector3f normal, Color color, int overlay, int light, UV uv, float f, float g, float h, float i, float j, float k, float l, float m) {
        bb.addVertex(entry, f, h, j).setColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f).setUv(uv.getMaxU(), uv.getMinV()).setOverlay(overlay).setLight(light).setNormal(entry, normal.x, normal.y, normal.z);
        bb.addVertex(entry, g, h, k).setColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f).setUv(uv.getMinU(), uv.getMinV()).setOverlay(overlay).setLight(light).setNormal(entry, normal.x, normal.y, normal.z);
        bb.addVertex(entry, g, i, l).setColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f).setUv(uv.getMinU(), uv.getMaxV()).setOverlay(overlay).setLight(light).setNormal(entry, normal.x, normal.y, normal.z);
        bb.addVertex(entry, f, i, m).setColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f).setUv(uv.getMaxU(), uv.getMaxV()).setOverlay(overlay).setLight(light).setNormal(entry, normal.x, normal.y, normal.z);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\u000bR\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\"\u0010\u0004\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0004\u0010\f\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\"\u0010\u0005\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\f\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0010R\"\u0010\u0006\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010\f\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lio/github/lucaargolo/kibe/client/blockentity/TankBlockEntityRenderer$UV;", "", "", "minU", "minV", "maxU", "maxV", "<init>", "(FFFF)V", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "sprite", "(Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;)V", "F", "getMinU", "()F", "setMinU", "(F)V", "getMinV", "setMinV", "getMaxU", "setMaxU", "getMaxV", "setMaxV", "kibe"})
    public static final class UV {
        private float minU;
        private float minV;
        private float maxU;
        private float maxV;

        public UV(float minU, float minV, float maxU, float maxV) {
            this.minU = minU;
            this.minV = minV;
            this.maxU = maxU;
            this.maxV = maxV;
        }

        public final float getMinU() {
            return this.minU;
        }

        public final void setMinU(float f) {
            this.minU = f;
        }

        public final float getMinV() {
            return this.minV;
        }

        public final void setMinV(float f) {
            this.minV = f;
        }

        public final float getMaxU() {
            return this.maxU;
        }

        public final void setMaxU(float f) {
            this.maxU = f;
        }

        public final float getMaxV() {
            return this.maxV;
        }

        public final void setMaxV(float f) {
            this.maxV = f;
        }

        public UV(@NotNull TextureAtlasSprite sprite) {
            Intrinsics.checkNotNullParameter((Object)sprite, (String)"sprite");
            this(sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1());
        }
    }
}

