/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.client.screen;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.lucaargolo.kibe.blockentity.ChunkLoaderBlockEntity;
import io.github.lucaargolo.kibe.network.ChunkMapClickPacket;
import io.github.lucaargolo.kibe.network.ChunkPlayerCheckPacket;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0019\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\f\u0010\bJ\u000f\u0010\r\u001a\u00020\u0006H\u0014\u00a2\u0006\u0004\b\r\u0010\bJ/\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J/\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0016J'\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0017\u0010 \u001a\u00020\u001f8\u0006\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u0017\u0010$\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R$\u0010)\u001a\u0004\u0018\u00010(8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\"\u0010/\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b/\u00100\u001a\u0004\b1\u0010\u000b\"\u0004\b2\u00103R\u0014\u00104\u001a\u00020\u00108\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0014\u00106\u001a\u00020\u00108\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b6\u00105R\"\u00107\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b7\u00105\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\"\u0010<\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b<\u00105\u001a\u0004\b=\u00109\"\u0004\b>\u0010;R\u001c\u0010@\u001a\n ?*\u0004\u0018\u00010(0(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b@\u0010*\u00a8\u0006A"}, d2={"Lio/github/lucaargolo/kibe/client/screen/ChunkLoaderScreen;", "Lnet/minecraft/client/gui/screens/Screen;", "Lio/github/lucaargolo/kibe/blockentity/ChunkLoaderBlockEntity;", "be", "<init>", "(Lio/github/lucaargolo/kibe/blockentity/ChunkLoaderBlockEntity;)V", "", "createImage", "()V", "", "shouldPause", "()Z", "close", "init", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "", "mouseX", "mouseY", "", "delta", "renderBackground", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "render", "", "button", "mouseClicked", "(DDI)Z", "Lnet/minecraft/world/level/ChunkPos;", "chunkPos", "Lnet/minecraft/world/level/ChunkPos;", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/level/Level;", "getWorld", "()Lnet/minecraft/world/level/Level;", "entity", "Lio/github/lucaargolo/kibe/blockentity/ChunkLoaderBlockEntity;", "getEntity", "()Lio/github/lucaargolo/kibe/blockentity/ChunkLoaderBlockEntity;", "Lnet/minecraft/resources/ResourceLocation;", "identifier", "Lnet/minecraft/resources/ResourceLocation;", "getIdentifier", "()Lnet/minecraft/resources/ResourceLocation;", "setIdentifier", "(Lnet/minecraft/resources/ResourceLocation;)V", "notOwner", "Z", "getNotOwner", "setNotOwner", "(Z)V", "backgroundHeight", "I", "backgroundWidth", "x", "getX", "()I", "setX", "(I)V", "y", "getY", "setY", "kotlin.jvm.PlatformType", "texture", "kibe"})
@SourceDebugExtension(value={"SMAP\nChunkLoaderScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkLoaderScreen.kt\nio/github/lucaargolo/kibe/client/screen/ChunkLoaderScreen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1869#2:142\n1869#2,2:143\n1870#2:145\n1869#2,2:147\n1#3:146\n*S KotlinDebug\n*F\n+ 1 ChunkLoaderScreen.kt\nio/github/lucaargolo/kibe/client/screen/ChunkLoaderScreen\n*L\n29#1:142\n30#1:143,2\n29#1:145\n88#1:147,2\n*E\n"})
public final class ChunkLoaderScreen
extends Screen {
    @NotNull
    private final ChunkPos chunkPos;
    @NotNull
    private final Level world;
    @NotNull
    private final ChunkLoaderBlockEntity entity;
    @Nullable
    private ResourceLocation identifier;
    private boolean notOwner;
    private final int backgroundHeight;
    private final int backgroundWidth;
    private int x;
    private int y;
    private final ResourceLocation texture;

    public ChunkLoaderScreen(@NotNull ChunkLoaderBlockEntity be) {
        Intrinsics.checkNotNullParameter((Object)((Object)be), (String)"be");
        super((Component)Component.translatable((String)"screen.kibe.chunk_loader"));
        this.chunkPos = new ChunkPos(be.getBlockPos());
        Level level = be.getLevel();
        Intrinsics.checkNotNull((Object)level);
        this.world = level;
        this.entity = be;
        this.backgroundHeight = 116;
        this.backgroundWidth = 94;
        this.texture = ResourceLocation.parse((String)"kibe:textures/gui/chunk_loader.png");
    }

    @NotNull
    public final Level getWorld() {
        return this.world;
    }

    @NotNull
    public final ChunkLoaderBlockEntity getEntity() {
        return this.entity;
    }

    @Nullable
    public final ResourceLocation getIdentifier() {
        return this.identifier;
    }

    public final void setIdentifier(@Nullable ResourceLocation resourceLocation) {
        this.identifier = resourceLocation;
    }

    public final boolean getNotOwner() {
        return this.notOwner;
    }

    public final void setNotOwner(boolean bl) {
        this.notOwner = bl;
    }

    private final void createImage() {
        NativeImage image = new NativeImage(NativeImage.Format.RGBA, 256, 256, false);
        Iterable $this$forEach$iv = (Iterable)new IntRange(this.chunkPos.getMinBlockX() - 32, this.chunkPos.getMaxBlockX() + 32);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int x = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            Iterable $this$forEach$iv2 = (Iterable)new IntRange(this.chunkPos.getMinBlockZ() - 32, this.chunkPos.getMaxBlockZ() + 32);
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                int element$iv2;
                int z = element$iv2 = ((IntIterator)iterator2).nextInt();
                boolean bl2 = false;
                MapColor color = MapColor.SNOW;
                for (int y = 256; y >= 0; --y) {
                    BlockPos innerPos = new BlockPos(x, y, z);
                    BlockState state = this.world.getBlockState(innerPos);
                    if (state.isAir()) continue;
                    color = state.getMapColor((BlockGetter)this.world, innerPos);
                    break;
                }
                int red = color.col >> 16 & 0xFF;
                int green = color.col >> 8 & 0xFF;
                int blue = color.col >> 0 & 0xFF;
                int out = 0xFF000000 | blue << 16 | green << 8 | red << 0;
                image.setPixelRGBA(x - this.chunkPos.getMinBlockX() + 32, z - this.chunkPos.getMinBlockZ() + 32, out);
            }
        }
        Minecraft mc = Minecraft.getInstance();
        DynamicTexture texture = new DynamicTexture(image);
        this.identifier = mc.getTextureManager().register("chunk_loader_minimap", texture);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public final int getX() {
        return this.x;
    }

    public final void setX(int n) {
        this.x = n;
    }

    public final int getY() {
        return this.y;
    }

    public final void setY(int n) {
        this.y = n;
    }

    public void onClose() {
        block1: {
            super.onClose();
            ResourceLocation resourceLocation = this.identifier;
            if (resourceLocation == null) break block1;
            ResourceLocation it = resourceLocation;
            boolean bl = false;
            Minecraft minecraft = this.minecraft;
            if (minecraft != null && (minecraft = minecraft.getTextureManager()) != null) {
                minecraft.release(it);
            }
        }
    }

    protected void init() {
        super.init();
        this.x = (this.width - this.backgroundWidth) / 2;
        this.y = (this.height - this.backgroundHeight) / 2;
    }

    public void renderBackground(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.renderTransparentBackground(context);
        context.blit(this.texture, this.x, this.y, 0, 0, this.backgroundWidth, this.backgroundHeight);
    }

    /*
     * Unable to fully structure code
     */
    public void render(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                super.render(context, mouseX, mouseY, delta);
                if (this.identifier == null) {
                    this.createImage();
                }
                v0 = this.identifier;
                if (v0 != null) {
                    it = v0;
                    $i$a$-let-ChunkLoaderScreen$render$1 = false;
                    context.blit(it, this.x + 7, this.y + 28, 0, 0, 80, 80);
                }
                $this$forEach$iv = this.entity.getEnabledChunks();
                $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    it = (Pair)element$iv;
                    $i$a$-forEach-ChunkLoaderScreen$render$2 = false;
                    context.fill(this.x + 7 + (((Number)it.getFirst()).intValue() + 2) * 16, this.y + 28 + (((Number)it.getSecond()).intValue() + 2) * 16, this.x + 7 + (((Number)it.getFirst()).intValue() + 2) * 16 + 16, this.y + 28 + (((Number)it.getSecond()).intValue() + 2) * 16 + 16, -2147418368);
                }
                if (this.entity.getCheckForOwner()) {
                    context.blit(this.texture, this.x + 7, this.y + 18, 94, 0, 7, 7);
                }
                $this$forEach$iv = this.x + 7;
                v1 = mouseX < this.x + 87 ? $this$forEach$iv <= mouseX : false;
                if (!v1) break block8;
                $this$forEach$iv = this.y + 28;
                v2 = mouseY < this.y + 109 ? $this$forEach$iv <= mouseY : false;
                if (!v2) break block8;
                chunkX = (mouseX - (this.x + 7)) / 16;
                chunkZ = (mouseY - (this.y + 28)) / 16;
                context.fill(this.x + 7 + chunkX * 16, this.y + 28 + chunkZ * 16, this.x + 7 + chunkX * 16 + 16, this.y + 28 + chunkZ * 16 + 16, -2130706433);
                tooltip = new ArrayList<E>();
                v3 = Component.translatable((String)"tooltip.kibe.chunk_at").append((Component)Component.literal((String)(this.chunkPos.x + chunkX - 2 + ", " + (this.chunkPos.z + chunkZ - 2))));
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"append(...)");
                tooltip.add(v3);
                v4 = Component.translatable((String)"tooltip.kibe.forced").append((Component)Component.translatable((String)(this.entity.getEnabledChunks().contains(new Pair((Object)(chunkX - 2), (Object)(chunkZ - 2))) != false ? "tooltip.kibe.enabled" : "tooltip.kibe.disabled")));
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"append(...)");
                tooltip.add(v4);
                context.renderComponentTooltip(this.font, tooltip, mouseX, mouseY);
                break block9;
            }
            chunkX = this.x + 7;
            v5 = mouseX < this.x + 14 ? chunkX <= mouseX : false;
            if (!v5) ** GOTO lbl-1000
            chunkX = this.y + 18;
            v6 = mouseY < this.y + 25 ? chunkX <= mouseY : false;
            if (v6) {
                context.fill(this.x + 7, this.y + 18, this.x + 14, this.y + 25, -2130706433);
                tooltip = new ArrayList<E>();
                var7_5 = new Object[]{this.entity.getCheckForOwner() != false ? Component.translatable((String)"tooltip.kibe.enabled") : Component.translatable((String)"tooltip.kibe.disabled")};
                v7 = Component.translatable((String)"tooltip.kibe.check_for_owner_status", (Object[])var7_5);
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"translatable(...)");
                tooltip.add(v7);
                if (this.notOwner) {
                    v8 = Component.translatable((String)"tooltip.kibe.lore.not_owner");
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"translatable(...)");
                    v9 = tooltip.add(v8);
                } else {
                    v10 = Component.translatable((String)"tooltip.kibe.lore.check_for_owner");
                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"translatable(...)");
                    v9 = tooltip.add(v10);
                }
                context.renderComponentTooltip(this.font, tooltip, mouseX, mouseY);
            } else lbl-1000:
            // 2 sources

            {
                this.notOwner = false;
            }
        }
        context.drawString(this.font, this.title, this.x + 47 - this.font.width((FormattedText)this.title) / 2, this.y + 6, 0x404040, false);
        toggle = Component.translatable((String)"tooltip.kibe.check_for_owner");
        context.pose().pushPose();
        context.pose().scale(0.5f, 0.5f, 0.5f);
        context.drawString(this.font, (Component)toggle, (this.x + 16) * 2, (this.y + 20) * 2, 0x404040, false);
        context.pose().popPose();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int n = this.x + 7;
        int n2 = this.x + 87;
        int n3 = (int)mouseX;
        boolean bl = n <= n3 ? n3 < n2 : false;
        if (bl) {
            n = this.y + 28;
            n2 = this.y + 109;
            n3 = (int)mouseY;
            boolean bl2 = n <= n3 ? n3 < n2 : false;
            if (bl2) {
                int x = ((int)mouseX - (this.x + 7)) / 16 - 2;
                int z = ((int)mouseY - (this.y + 28)) / 16 - 2;
                BlockPos blockPos = this.entity.getBlockPos();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
                ClientPlayNetworking.send((CustomPacketPayload)new ChunkMapClickPacket(x, z, blockPos));
                return true;
            }
        }
        n = this.x + 7;
        n2 = this.x + 14;
        n3 = (int)mouseX;
        boolean bl3 = n <= n3 ? n3 < n2 : false;
        if (bl3) {
            n = this.y + 18;
            n2 = this.y + 25;
            n3 = (int)mouseY;
            boolean bl4 = n <= n3 ? n3 < n2 : false;
            if (bl4) {
                Minecraft minecraft = this.minecraft;
                if (!Intrinsics.areEqual((Object)(minecraft != null && (minecraft = minecraft.player) != null ? minecraft.getStringUUID() : null), (Object)this.entity.getOwnerUUID())) {
                    this.notOwner = true;
                } else {
                    BlockPos blockPos = this.entity.getBlockPos();
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
                    ClientPlayNetworking.send((CustomPacketPayload)new ChunkPlayerCheckPacket(blockPos));
                }
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

