/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.data.state;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001b\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0019\u0010\u000bJ\u001d\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001c\u0010\u001dJ%\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001f\u0010 J\u001d\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001f\u0010\u001dJ'\u0010\"\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00162\b\u0010!\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\"\u0010#J\u0015\u0010$\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b$\u0010\bR(\u0010'\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0&0%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R(\u0010)\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010(R\u0014\u0010*\u001a\u00020\u00168\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b*\u0010+\u00a8\u0006-"}, d2={"Lio/github/lucaargolo/kibe/data/state/EntangledChestState;", "Lnet/minecraft/world/level/saveddata/SavedData;", "<init>", "()V", "", "colorCode", "", "createInventory", "(Ljava/lang/String;)V", "", "hasInventory", "(Ljava/lang/String;)Z", "Lnet/fabricmc/fabric/api/transfer/v1/storage/Storage;", "Lnet/fabricmc/fabric/api/transfer/v1/item/ItemVariant;", "getStorage", "(Ljava/lang/String;)Lnet/fabricmc/fabric/api/transfer/v1/storage/Storage;", "Lnet/minecraft/nbt/CompoundTag;", "tag", "Lnet/minecraft/core/HolderLookup$Provider;", "registryLookup", "writeNbt", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/nbt/CompoundTag;", "", "size", "(Ljava/lang/String;)I", "isEmpty", "slot", "Lnet/minecraft/world/item/ItemStack;", "getStack", "(ILjava/lang/String;)Lnet/minecraft/world/item/ItemStack;", "amount", "removeStack", "(IILjava/lang/String;)Lnet/minecraft/world/item/ItemStack;", "stack", "setStack", "(ILnet/minecraft/world/item/ItemStack;Ljava/lang/String;)V", "clear", "", "Lnet/minecraft/core/NonNullList;", "inventoryMap", "Ljava/util/Map;", "storageMap", "invMaxStackAmount", "I", "Companion", "kibe"})
@SourceDebugExtension(value={"SMAP\nEntangledChestState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntangledChestState.kt\nio/github/lucaargolo/kibe/data/state/EntangledChestState\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n216#2,2:129\n1740#3,3:131\n*S KotlinDebug\n*F\n+ 1 EntangledChestState.kt\nio/github/lucaargolo/kibe/data/state/EntangledChestState\n*L\n56#1:129,2\n73#1:131,3\n*E\n"})
public final class EntangledChestState
extends SavedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Map<String, NonNullList<ItemStack>> inventoryMap = new LinkedHashMap();
    @NotNull
    private Map<String, Storage<ItemVariant>> storageMap = new LinkedHashMap();
    private final int invMaxStackAmount;

    public EntangledChestState() {
        this.invMaxStackAmount = 64;
    }

    private final void createInventory(String colorCode2) {
        this.inventoryMap.put(colorCode2, (NonNullList<ItemStack>)NonNullList.withSize((int)27, (Object)ItemStack.EMPTY));
    }

    private final boolean hasInventory(String colorCode2) {
        return this.inventoryMap.get(colorCode2) != null;
    }

    @NotNull
    public final Storage<ItemVariant> getStorage(@NotNull String colorCode2) {
        Intrinsics.checkNotNullParameter((Object)colorCode2, (String)"colorCode");
        Storage<ItemVariant> existing = this.storageMap.get(colorCode2);
        if (existing != null) {
            return existing;
        }
        if (!this.hasInventory(colorCode2)) {
            Storage storage = Storage.empty();
            Intrinsics.checkNotNullExpressionValue((Object)storage, (String)"empty(...)");
            return storage;
        }
        InventoryStorage inventoryStorage = InventoryStorage.of((Container)new Container(this, colorCode2){
            final /* synthetic */ EntangledChestState this$0;
            final /* synthetic */ String $colorCode;
            {
                this.this$0 = $receiver;
                this.$colorCode = $colorCode;
            }

            public void clearContent() {
                this.this$0.clear(this.$colorCode);
            }

            public int getContainerSize() {
                return this.this$0.size(this.$colorCode);
            }

            public boolean isEmpty() {
                return this.this$0.isEmpty(this.$colorCode);
            }

            public ItemStack getItem(int slot) {
                return this.this$0.getStack(slot, this.$colorCode);
            }

            public ItemStack removeItem(int slot, int amount) {
                return this.this$0.removeStack(slot, amount, this.$colorCode);
            }

            public ItemStack removeItemNoUpdate(int slot) {
                return this.this$0.removeStack(slot, this.$colorCode);
            }

            public void setItem(int slot, ItemStack stack) {
                this.this$0.setStack(slot, stack, this.$colorCode);
            }

            public boolean stillValid(Player player) {
                return true;
            }

            public void setChanged() {
                this.this$0.setDirty();
            }
        }, null);
        Intrinsics.checkNotNullExpressionValue((Object)inventoryStorage, (String)"of(...)");
        return (Storage)inventoryStorage;
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        Map<String, NonNullList<ItemStack>> $this$forEach$iv = this.inventoryMap;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, NonNullList<ItemStack>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, NonNullList<ItemStack>> element$iv;
            Map.Entry<String, NonNullList<ItemStack>> entry = element$iv = iterator.next();
            boolean bl = false;
            String colorCode2 = entry.getKey();
            NonNullList<ItemStack> inventory2 = entry.getValue();
            CompoundTag subTag = new CompoundTag();
            ContainerHelper.saveAllItems((CompoundTag)subTag, inventory2, (HolderLookup.Provider)registryLookup);
            tag.put(colorCode2, (Tag)subTag);
        }
        return tag;
    }

    public final int size(@NotNull String colorCode2) {
        Intrinsics.checkNotNullParameter((Object)colorCode2, (String)"colorCode");
        if (!this.hasInventory(colorCode2)) {
            this.createInventory(colorCode2);
        }
        NonNullList<ItemStack> nonNullList = this.inventoryMap.get(colorCode2);
        Intrinsics.checkNotNull(nonNullList);
        return nonNullList.size();
    }

    public final boolean isEmpty(@NotNull String colorCode2) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)colorCode2, (String)"colorCode");
            if (!this.hasInventory(colorCode2)) {
                this.createInventory(colorCode2);
            }
            NonNullList<ItemStack> nonNullList = this.inventoryMap.get(colorCode2);
            Intrinsics.checkNotNull(nonNullList);
            Iterable $this$all$iv = (Iterable)nonNullList;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ItemStack it = (ItemStack)element$iv;
                    boolean bl2 = false;
                    if (it.isEmpty()) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public final ItemStack getStack(int slot, @NotNull String colorCode2) {
        Intrinsics.checkNotNullParameter((Object)colorCode2, (String)"colorCode");
        if (!this.hasInventory(colorCode2)) {
            this.createInventory(colorCode2);
        }
        NonNullList<ItemStack> nonNullList = this.inventoryMap.get(colorCode2);
        Intrinsics.checkNotNull(nonNullList);
        Object object = nonNullList.get(slot);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ItemStack)object;
    }

    @NotNull
    public final ItemStack removeStack(int slot, int amount, @NotNull String colorCode2) {
        Intrinsics.checkNotNullParameter((Object)colorCode2, (String)"colorCode");
        if (!this.hasInventory(colorCode2)) {
            this.createInventory(colorCode2);
        }
        NonNullList<ItemStack> nonNullList = this.inventoryMap.get(colorCode2);
        Intrinsics.checkNotNull(nonNullList);
        ItemStack itemStack = ContainerHelper.removeItem((List)((List)nonNullList), (int)slot, (int)amount);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"splitStack(...)");
        return itemStack;
    }

    @NotNull
    public final ItemStack removeStack(int slot, @NotNull String colorCode2) {
        Intrinsics.checkNotNullParameter((Object)colorCode2, (String)"colorCode");
        if (!this.hasInventory(colorCode2)) {
            this.createInventory(colorCode2);
        }
        NonNullList<ItemStack> nonNullList = this.inventoryMap.get(colorCode2);
        Intrinsics.checkNotNull(nonNullList);
        ItemStack itemStack = ContainerHelper.takeItem((List)((List)nonNullList), (int)slot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"removeStack(...)");
        return itemStack;
    }

    public final void setStack(int slot, @Nullable ItemStack stack, @NotNull String colorCode2) {
        Intrinsics.checkNotNullParameter((Object)colorCode2, (String)"colorCode");
        if (!this.hasInventory(colorCode2)) {
            this.createInventory(colorCode2);
        }
        NonNullList<ItemStack> nonNullList = this.inventoryMap.get(colorCode2);
        Intrinsics.checkNotNull(nonNullList);
        nonNullList.set(slot, (Object)stack);
        ItemStack itemStack = stack;
        Intrinsics.checkNotNull((Object)itemStack);
        if (itemStack.getCount() > this.invMaxStackAmount) {
            stack.setCount(this.invMaxStackAmount);
        }
    }

    public final void clear(@NotNull String colorCode2) {
        Intrinsics.checkNotNullParameter((Object)colorCode2, (String)"colorCode");
        if (!this.hasInventory(colorCode2)) {
            this.createInventory(colorCode2);
        }
        NonNullList<ItemStack> nonNullList = this.inventoryMap.get(colorCode2);
        Intrinsics.checkNotNull(nonNullList);
        nonNullList.clear();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u000b\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lio/github/lucaargolo/kibe/data/state/EntangledChestState$Companion;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "key", "Lio/github/lucaargolo/kibe/data/state/EntangledChestState;", "getPersistentState", "(Lnet/minecraft/server/MinecraftServer;Ljava/lang/String;)Lio/github/lucaargolo/kibe/data/state/EntangledChestState;", "Lnet/minecraft/world/level/saveddata/SavedData$Factory;", "getPersistentStateType", "()Lnet/minecraft/world/level/saveddata/SavedData$Factory;", "kibe"})
    @SourceDebugExtension(value={"SMAP\nEntangledChestState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntangledChestState.kt\nio/github/lucaargolo/kibe/data/state/EntangledChestState$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1869#2,2:129\n*S KotlinDebug\n*F\n+ 1 EntangledChestState.kt\nio/github/lucaargolo/kibe/data/state/EntangledChestState$Companion\n*L\n115#1:129,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntangledChestState getPersistentState(@NotNull MinecraftServer server, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            SavedData savedData = server.overworld().getDataStorage().computeIfAbsent(this.getPersistentStateType(), key);
            Intrinsics.checkNotNullExpressionValue((Object)savedData, (String)"getOrCreate(...)");
            return (EntangledChestState)savedData;
        }

        @NotNull
        public final SavedData.Factory<EntangledChestState> getPersistentStateType() {
            return new SavedData.Factory(EntangledChestState::new, Companion::getPersistentStateType$lambda$0, null);
        }

        private static final EntangledChestState getPersistentStateType$lambda$0(CompoundTag tag, HolderLookup.Provider lookup) {
            EntangledChestState state = new EntangledChestState();
            Set set = tag.getAllKeys();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getKeys(...)");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                NonNullList tempInventory = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
                Tag tag2 = tag.get(it);
                Intrinsics.checkNotNull((Object)tag2, (String)"null cannot be cast to non-null type net.minecraft.nbt.NbtCompound");
                ContainerHelper.loadAllItems((CompoundTag)((CompoundTag)tag2), (NonNullList)tempInventory, (HolderLookup.Provider)lookup);
                state.inventoryMap.put(it, tempInventory);
            }
            return state;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

