/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.item;

import io.github.lucaargolo.kibe.data.component.ComponentTypeCompendium;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ9\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J-\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001b2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ%\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ%\u0010 \u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0004\b \u0010\u001fJ\u0017\u0010!\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b!\u0010\nJ\u0017\u0010\"\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010$\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b$\u0010#J\u0017\u0010%\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b%\u0010#\u00a8\u0006&"}, d2={"Lio/github/lucaargolo/kibe/item/BooleanItem;", "Lnet/minecraft/world/item/Item;", "Lnet/minecraft/world/item/Item$Properties;", "settings", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "Lnet/minecraft/world/item/ItemStack;", "stack", "", "hasGlint", "(Lnet/minecraft/world/item/ItemStack;)Z", "Lnet/minecraft/world/item/Item$TooltipContext;", "context", "", "Lnet/minecraft/network/chat/Component;", "tooltip", "Lnet/minecraft/world/item/TooltipFlag;", "type", "", "appendTooltip", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/Item$TooltipContext;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/InteractionResultHolder;", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "appendEnabledTooltip", "(Lnet/minecraft/world/item/ItemStack;Ljava/util/List;)V", "appendDisabledTooltip", "isEnabled", "enable", "(Lnet/minecraft/world/item/ItemStack;)V", "disable", "toggle", "kibe"})
public class BooleanItem
extends Item {
    public BooleanItem(@NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return this.isEnabled(stack);
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @Nullable TooltipFlag type) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.appendHoverText(stack, context, tooltip, type);
        if (this.isEnabled(stack)) {
            this.appendEnabledTooltip(stack, tooltip);
        } else {
            this.appendDisabledTooltip(stack, tooltip);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown() && !world.isClientSide) {
            Intrinsics.checkNotNull((Object)stack);
            this.toggle(stack);
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.pass((Object)stack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
        return interactionResultHolder;
    }

    public void appendEnabledTooltip(@NotNull ItemStack stack, @NotNull List<Component> tooltip) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        MutableComponent mutableComponent = Component.translatable((String)"tooltip.kibe.enabled");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        tooltip.add((Component)mutableComponent);
        MutableComponent mutableComponent2 = Component.translatable((String)"tooltip.kibe.shift2disable");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translatable(...)");
        tooltip.add((Component)mutableComponent2);
    }

    public void appendDisabledTooltip(@NotNull ItemStack stack, @NotNull List<Component> tooltip) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        MutableComponent mutableComponent = Component.translatable((String)"tooltip.kibe.disabled");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        tooltip.add((Component)mutableComponent);
        MutableComponent mutableComponent2 = Component.translatable((String)"tooltip.kibe.shift2disable");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translatable(...)");
        tooltip.add((Component)mutableComponent2);
    }

    public boolean isEnabled(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Boolean bl = (Boolean)stack.get(ComponentTypeCompendium.INSTANCE.getENABLED());
        return bl != null ? bl : false;
    }

    public void enable(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        stack.set(ComponentTypeCompendium.INSTANCE.getENABLED(), (Object)true);
    }

    public void disable(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        stack.set(ComponentTypeCompendium.INSTANCE.getENABLED(), (Object)false);
    }

    public void toggle(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (this.isEnabled(stack)) {
            this.disable(stack);
        } else {
            this.enable(stack);
        }
    }
}

