/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.item;

import io.github.lucaargolo.kibe.KibeMod;
import io.github.lucaargolo.kibe.block.BlockCompendium;
import io.github.lucaargolo.kibe.compat.CurioCoolerBlockItem;
import io.github.lucaargolo.kibe.item.CoolerBlockItem;
import io.github.lucaargolo.kibe.menu.CoolerBlockItemScreenHandler;
import io.github.lucaargolo.kibe.utils.menu.ItemScreenHandlerFactory;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientBundleTooltip;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 #2\u00020\u0001:\u0003$%#B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J7\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J/\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001c2\u0006\u0010\t\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001d\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b!\u0010\"\u00a8\u0006&"}, d2={"Lio/github/lucaargolo/kibe/item/CoolerBlockItem;", "Lnet/minecraft/world/item/BlockItem;", "Lnet/minecraft/world/item/Item$Properties;", "settings", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/Entity;", "entity", "", "slot", "", "selected", "", "inventoryTick", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Entity;IZ)V", "Lnet/minecraft/world/item/context/UseOnContext;", "context", "Lnet/minecraft/world/InteractionResult;", "useOnBlock", "(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/InteractionResultHolder;", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "Ljava/util/Optional;", "Lnet/minecraft/world/inventory/tooltip/TooltipComponent;", "getTooltipData", "(Lnet/minecraft/world/item/ItemStack;)Ljava/util/Optional;", "Companion", "CoolerTooltipData", "CoolerTooltipComponent", "kibe"})
public class CoolerBlockItem
extends BlockItem {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public CoolerBlockItem(@NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super((Block)BlockCompendium.INSTANCE.getCOOLER(), settings);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int slot, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!(!(entity instanceof Player) || ((Player)entity).containerMenu instanceof CoolerBlockItemScreenHandler || ((Player)entity).isCreative() || ((Player)entity).isSpectator() || ((Player)entity).isInvulnerable() || ((Player)entity).getAbilities().invulnerable || !((Player)entity).canEat(false))) {
            NonNullList rawInventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
            ItemContainerContents itemContainerContents = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
            if (itemContainerContents != null) {
                itemContainerContents.copyInto(rawInventory);
            }
            Object object = rawInventory.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            ItemStack foodStack = (ItemStack)object;
            if (!foodStack.isEmpty() && foodStack.has(DataComponents.FOOD)) {
                rawInventory.set(0, (Object)((Player)entity).eat(world, foodStack, (FoodProperties)foodStack.get(DataComponents.FOOD)));
                stack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)((List)rawInventory)));
            }
        }
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Player player = context.getPlayer();
        boolean bl = player != null ? player.isShiftKeyDown() : false;
        if (bl) {
            Level level = context.getLevel();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getWorld(...)");
            Player player2 = context.getPlayer();
            InteractionHand interactionHand = context.getHand();
            Intrinsics.checkNotNullExpressionValue((Object)interactionHand, (String)"getHand(...)");
            InteractionResult interactionResult = this.use(level, player2, interactionHand).getResult();
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"getResult(...)");
            return interactionResult;
        }
        InteractionResult interactionResult = super.useOn(context);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useOnBlock(...)");
        return interactionResult;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @Nullable Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (!world.isClientSide && player != null) {
            Player it = player;
            boolean bl = false;
            ItemStack stack = player.getItemInHand(hand);
            Item item = (Item)this;
            Intrinsics.checkNotNull((Object)stack);
            player.openMenu((MenuProvider)new ItemScreenHandlerFactory(item, hand, stack, use.1.1.INSTANCE));
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
            return interactionResultHolder;
        }
        InteractionResultHolder interactionResultHolder = super.use(world, player, hand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"use(...)");
        return interactionResultHolder;
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        Optional<Object> optional;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            Optional<Object> optional2;
            Minecraft client = Minecraft.getInstance();
            ClientLevel world = client.level;
            if (world != null) {
                NonNullList rawInventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
                ItemContainerContents itemContainerContents = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
                if (itemContainerContents != null) {
                    itemContainerContents.copyInto(rawInventory);
                }
                BundleContents contents = new BundleContents((List)rawInventory);
                optional2 = !((ItemStack)rawInventory.get(0)).isEmpty() ? Optional.of(new CoolerTooltipData(contents)) : Optional.empty();
            } else {
                optional2 = Optional.empty();
            }
            Optional optional3 = optional2;
            Intrinsics.checkNotNull(optional3);
            optional = optional3;
        } else {
            Optional<TooltipComponent> optional4 = Optional.empty();
            Intrinsics.checkNotNull(optional4);
            optional = optional4;
        }
        return optional;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lio/github/lucaargolo/kibe/item/CoolerBlockItem$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/item/Item$Properties;", "settings", "Lio/github/lucaargolo/kibe/item/CoolerBlockItem;", "create", "(Lnet/minecraft/world/item/Item$Properties;)Lio/github/lucaargolo/kibe/item/CoolerBlockItem;", "kibe"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CoolerBlockItem create(@NotNull Item.Properties settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            return KibeMod.INSTANCE.getTRINKET() ? (CoolerBlockItem)new CurioCoolerBlockItem(settings) : new CoolerBlockItem(settings);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\t\u001a\u00020\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lio/github/lucaargolo/kibe/item/CoolerBlockItem$CoolerTooltipComponent;", "Lnet/minecraft/client/gui/screens/inventory/tooltip/ClientBundleTooltip;", "Lnet/minecraft/world/item/component/BundleContents;", "contents", "<init>", "(Lnet/minecraft/world/item/component/BundleContents;)V", "Lnet/minecraft/client/gui/Font;", "textRenderer", "", "getWidth", "(Lnet/minecraft/client/gui/Font;)I", "getHeight", "()I", "kibe"})
    public static final class CoolerTooltipComponent
    extends ClientBundleTooltip {
        public CoolerTooltipComponent(@NotNull BundleContents contents) {
            Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
            super(contents);
        }

        public int getWidth(@Nullable Font textRenderer) {
            return 20;
        }

        public int getHeight() {
            return 26;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lio/github/lucaargolo/kibe/item/CoolerBlockItem$CoolerTooltipData;", "Lnet/minecraft/world/inventory/tooltip/TooltipComponent;", "Lnet/minecraft/world/item/component/BundleContents;", "contents", "<init>", "(Lnet/minecraft/world/item/component/BundleContents;)V", "component1", "()Lnet/minecraft/world/item/component/BundleContents;", "copy", "(Lnet/minecraft/world/item/component/BundleContents;)Lio/github/lucaargolo/kibe/item/CoolerBlockItem$CoolerTooltipData;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/world/item/component/BundleContents;", "getContents", "kibe"})
    public static final class CoolerTooltipData
    implements TooltipComponent {
        @NotNull
        private final BundleContents contents;

        public CoolerTooltipData(@NotNull BundleContents contents) {
            Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
            this.contents = contents;
        }

        @NotNull
        public final BundleContents getContents() {
            return this.contents;
        }

        @NotNull
        public final BundleContents component1() {
            return this.contents;
        }

        @NotNull
        public final CoolerTooltipData copy(@NotNull BundleContents contents) {
            Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
            return new CoolerTooltipData(contents);
        }

        public static /* synthetic */ CoolerTooltipData copy$default(CoolerTooltipData coolerTooltipData, BundleContents bundleContents, int n, Object object) {
            if ((n & 1) != 0) {
                bundleContents = coolerTooltipData.contents;
            }
            return coolerTooltipData.copy(bundleContents);
        }

        @NotNull
        public String toString() {
            return "CoolerTooltipData(contents=" + this.contents + ")";
        }

        public int hashCode() {
            return this.contents.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CoolerTooltipData)) {
                return false;
            }
            CoolerTooltipData coolerTooltipData = (CoolerTooltipData)other;
            return Intrinsics.areEqual((Object)this.contents, (Object)coolerTooltipData.contents);
        }
    }
}

