/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.item;

import io.github.lucaargolo.kibe.entity.ThrownTorchEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J/\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lio/github/lucaargolo/kibe/item/TorchSling;", "Lnet/minecraft/world/item/Item;", "Lnet/minecraft/world/item/Item$Properties;", "settings", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "stack", "Lnet/minecraft/world/item/UseAnim;", "getUseAction", "(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/UseAnim;", "Lnet/minecraft/world/entity/LivingEntity;", "entity", "", "getMaxUseTime", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/LivingEntity;)I", "remainingUseTicks", "", "onStoppedUsing", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;I)V", "kibe"})
@SourceDebugExtension(value={"SMAP\nTorchSling.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TorchSling.kt\nio/github/lucaargolo/kibe/item/TorchSling\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n295#2,2:53\n*S KotlinDebug\n*F\n+ 1 TorchSling.kt\nio/github/lucaargolo/kibe/item/TorchSling\n*L\n37#1:53,2\n*E\n"})
public final class TorchSling
extends Item {
    public TorchSling(@NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        ItemStack stack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)stack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
        return interactionResultHolder;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.BOW;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return 72000;
    }

    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level world, @NotNull LivingEntity entity, int remainingUseTicks) {
        block5: {
            ItemStack torchStack;
            Object v2;
            float tickStrength;
            Player player;
            block4: {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                Player player2 = entity instanceof Player ? (Player)entity : null;
                if (player2 == null) {
                    return;
                }
                player = player2;
                tickStrength = RangesKt.coerceAtMost((float)RangesKt.coerceAtLeast((float)((float)(this.getUseDuration(stack, entity) - remainingUseTicks) / 20.0f), (float)0.5f), (float)1.5f);
                NonNullList nonNullList = player.getInventory().items;
                Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"main");
                Iterable $this$firstOrNull$iv = (Iterable)nonNullList;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ItemStack it = (ItemStack)element$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getItem(), (Object)Items.TORCH) || Intrinsics.areEqual((Object)it.getItem(), (Object)Items.SOUL_TORCH) || Intrinsics.areEqual((Object)it.getItem(), (Object)Items.REDSTONE_TORCH))) continue;
                    v2 = element$iv;
                    break block4;
                }
                v2 = null;
            }
            ItemStack itemStack = torchStack = (ItemStack)v2;
            if (itemStack == null) break block5;
            ItemStack it = itemStack;
            boolean bl = false;
            world.playSound(null, ((Player)entity).getX(), ((Player)entity).getY(), ((Player)entity).getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (world.random.nextFloat() * 0.4f + 0.8f));
            if (!world.isClientSide) {
                ThrownTorchEntity thrownTorchEntity = new ThrownTorchEntity(world, entity);
                thrownTorchEntity.setItem(new ItemStack((ItemLike)it.getItem()));
                thrownTorchEntity.shootFromRotation((Entity)entity, ((Player)entity).getXRot(), ((Player)entity).getYRot(), 0.0f, tickStrength, 0.0f);
                world.addFreshEntity((Entity)thrownTorchEntity);
                if (!player.getAbilities().instabuild) {
                    it.shrink(1);
                }
            }
        }
    }
}

