/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.item;

import io.github.lucaargolo.kibe.item.ItemCompendium;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J1\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J#\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001c\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001f"}, d2={"Lio/github/lucaargolo/kibe/item/WoodenBucket;", "Lnet/minecraft/world/item/Item;", "Lnet/minecraft/world/level/material/Fluid;", "fluid", "Lnet/minecraft/world/item/Item$Properties;", "settings", "<init>", "(Lnet/minecraft/world/level/material/Fluid;Lnet/minecraft/world/item/Item$Properties;)V", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/player/Player;", "user", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "stack", "player", "getEmptiedStack", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/world/level/material/Fluid;", "getFluid", "()Lnet/minecraft/world/level/material/Fluid;", "Lnet/minecraft/world/item/BucketItem;", "getBucketItem", "()Lnet/minecraft/world/item/BucketItem;", "bucketItem", "Empty", "Water", "kibe"})
public class WoodenBucket
extends Item {
    @NotNull
    private final Fluid fluid;

    public WoodenBucket(@NotNull Fluid fluid, @NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.fluid = fluid;
    }

    @NotNull
    public final Fluid getFluid() {
        return this.fluid;
    }

    @Nullable
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @Nullable InteractionHand hand) {
        BlockHitResult blockHitResult;
        block16: {
            ItemStack itemStack;
            block15: {
                Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                Intrinsics.checkNotNullParameter((Object)user, (String)"user");
                itemStack = user.getItemInHand(hand);
                BlockHitResult blockHitResult2 = Item.getPlayerPOVHitResult((Level)world, (Player)user, (ClipContext.Fluid)(this.fluid == Fluids.EMPTY ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
                Intrinsics.checkNotNullExpressionValue((Object)blockHitResult2, (String)"raycast(...)");
                HitResult hitResult = (HitResult)blockHitResult2;
                blockHitResult = (BlockHitResult)hitResult;
                if (blockHitResult == null) break block15;
                BlockHitResult blockHitResult3 = blockHitResult;
                boolean bl = false;
                Direction dir = blockHitResult3.getDirection();
                BlockPos pos = blockHitResult3.getBlockPos();
                BlockPos offsetPos = pos.relative(dir);
                if (((BlockHitResult)hitResult).getType() == HitResult.Type.MISS) {
                    return InteractionResultHolder.pass((Object)itemStack);
                }
                if (((BlockHitResult)hitResult).getType() != HitResult.Type.BLOCK) {
                    return InteractionResultHolder.pass((Object)itemStack);
                }
                if (world.mayInteract(user, pos) && user.mayUseItemAt(offsetPos, dir, itemStack)) {
                    BlockState blockState = world.getBlockState(pos);
                    if (Intrinsics.areEqual((Object)this.fluid, (Object)Fluids.EMPTY)) {
                        if (blockState.getBlock() instanceof BucketPickup) {
                            Block block = blockState.getBlock();
                            Intrinsics.checkNotNull((Object)block, (String)"null cannot be cast to non-null type net.minecraft.block.FluidDrainable");
                            ItemStack fluid = ((BucketPickup)block).pickupBlock(user, (LevelAccessor)world, pos, blockState);
                            if (Intrinsics.areEqual((Object)fluid.getItem(), (Object)Fluids.WATER.getBucket())) {
                                user.awardStat(Stats.ITEM_USED.get((Object)this));
                                user.playSound(SoundEvents.BUCKET_FILL, 1.0f, 1.0f);
                                ItemStack itemStack2 = ItemUtils.createFilledResult((ItemStack)itemStack, (Player)user, (ItemStack)new ItemStack((ItemLike)ItemCompendium.INSTANCE.getWOODEN_WATER_BUCKET()));
                                if (!world.isClientSide) {
                                    CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)user, new ItemStack((ItemLike)ItemCompendium.INSTANCE.getWOODEN_WATER_BUCKET()));
                                }
                                return InteractionResultHolder.sidedSuccess((Object)itemStack2, (boolean)world.isClientSide());
                            }
                            Item item = fluid.getItem();
                            BucketItem bucketItem = item instanceof BucketItem ? (BucketItem)item : null;
                            if (bucketItem != null) {
                                bucketItem.emptyContents(user, world, pos, blockHitResult3);
                            }
                        }
                    } else {
                        BlockPos interactablePos;
                        BlockPos blockPos = interactablePos = blockState.getBlock() instanceof LiquidBlockContainer && this.fluid == Fluids.WATER ? pos : offsetPos;
                        if (this.getBucketItem().emptyContents(user, world, interactablePos, blockHitResult3)) {
                            this.getBucketItem().checkExtraContent(null, world, itemStack, interactablePos);
                            if (user instanceof ServerPlayer) {
                                CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)user, interactablePos, itemStack);
                            }
                            user.awardStat(Stats.ITEM_USED.get((Object)this));
                            return InteractionResultHolder.sidedSuccess((Object)this.getEmptiedStack(itemStack, user), (boolean)world.isClientSide());
                        }
                    }
                }
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)itemStack);
                blockHitResult = interactionResultHolder;
                if (interactionResultHolder != null) break block16;
            }
            blockHitResult = InteractionResultHolder.pass((Object)itemStack);
        }
        return blockHitResult;
    }

    private final BucketItem getBucketItem() {
        Item item = Intrinsics.areEqual((Object)this.fluid, (Object)Fluids.WATER) ? Items.WATER_BUCKET : Items.BUCKET;
        Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type net.minecraft.item.BucketItem");
        return (BucketItem)item;
    }

    private final ItemStack getEmptiedStack(ItemStack stack, Player player) {
        return !player.isCreative() ? new ItemStack((ItemLike)ItemCompendium.INSTANCE.getWOODEN_BUCKET()) : stack;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lio/github/lucaargolo/kibe/item/WoodenBucket$Empty;", "Lio/github/lucaargolo/kibe/item/WoodenBucket;", "Lnet/minecraft/world/item/Item$Properties;", "settings", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "kibe"})
    public static final class Empty
    extends WoodenBucket {
        public Empty(@NotNull Item.Properties settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Fluid fluid = Fluids.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)fluid, (String)"EMPTY");
            super(fluid, settings);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lio/github/lucaargolo/kibe/item/WoodenBucket$Water;", "Lio/github/lucaargolo/kibe/item/WoodenBucket;", "Lnet/minecraft/world/item/Item$Properties;", "settings", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "kibe"})
    public static final class Water
    extends WoodenBucket {
        public Water(@NotNull Item.Properties settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            FlowingFluid flowingFluid = Fluids.WATER;
            Intrinsics.checkNotNullExpressionValue((Object)flowingFluid, (String)"WATER");
            super((Fluid)flowingFluid, settings);
        }
    }
}

