/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.mixin;

import io.github.lucaargolo.kibe.enchantment.EnchantmentCompendium;
import io.github.lucaargolo.kibe.item.ItemCompendium;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={AnvilMenu.class})
public abstract class AnvilScreenHandlerMixin
extends ItemCombinerMenu {
    @Shadow
    @Final
    private DataSlot cost;
    @Shadow
    @Nullable
    private String itemName;

    public AnvilScreenHandlerMixin(@Nullable MenuType<?> type, int syncId, Inventory playerInventory, ContainerLevelAccess context) {
        super(type, syncId, playerInventory, context);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getOrDefault(Lnet/minecraft/core/component/DataComponentType;Ljava/lang/Object;)Ljava/lang/Object;", ordinal=0)}, method={"createResult()V"}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private void onUpdateResult(CallbackInfo ci, ItemStack input, int i, long l, int j, ItemStack output, ItemStack extra, ItemEnchantments.Mutable builder) {
        if (output.is(ItemTags.FOOT_ARMOR_ENCHANTABLE) && output.getEnchantments().keySet().stream().noneMatch(enchantment -> EnchantmentCompendium.INSTANCE.getSLIMY().equals(enchantment.unwrapKey().orElse(null))) && extra.is((Item)ItemCompendium.INSTANCE.getSLIME_BOOTS())) {
            this.player.level().registryAccess().lookup(Registries.ENCHANTMENT).flatMap(registry -> registry.get(EnchantmentCompendium.INSTANCE.getSLIMY())).ifPresent(enchantment -> {
                output.enchant((Holder)enchantment, 1);
                if (this.itemName != null && !StringUtil.isBlank((String)this.itemName)) {
                    if (!this.itemName.equals(input.getHoverName().getString())) {
                        output.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)this.itemName));
                    }
                } else if (input.has(DataComponents.CUSTOM_NAME)) {
                    output.remove(DataComponents.CUSTOM_NAME);
                }
                this.cost.set(4);
                this.resultSlots.setItem(0, output);
                this.broadcastChanges();
                ci.cancel();
            });
        }
    }
}

