/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.mixin;

import io.github.lucaargolo.kibe.blockentity.HeaterBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Biome.class})
public class BiomeMixin {
    @Inject(at={@At(value="HEAD")}, method={"shouldFreeze(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Z)Z"}, cancellable=true)
    private void canSetIce(LevelReader world, BlockPos pos, boolean doWaterCheck, CallbackInfoReturnable<Boolean> cir) {
        if (world instanceof ServerLevel && HeaterBlockEntity.Companion.isBeingHeated((ServerLevel)world, new ChunkPos(pos))) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"shouldSnow(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z"}, cancellable=true)
    private void canSetSnow(LevelReader world, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        if (world instanceof ServerLevel && HeaterBlockEntity.Companion.isBeingHeated((ServerLevel)world, new ChunkPos(pos))) {
            cir.setReturnValue((Object)false);
        }
    }
}

