/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.mixin;

import io.github.lucaargolo.kibe.item.Glider;
import io.github.lucaargolo.kibe.utils.helper.GliderHelper;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidModel.class})
public class BipedEntityModelMixin<T extends LivingEntity> {
    @Final
    @Shadow
    public ModelPart rightArm;
    @Final
    @Shadow
    public ModelPart leftArm;
    @Final
    @Shadow
    public ModelPart rightLeg;
    @Final
    @Shadow
    public ModelPart leftLeg;

    @Inject(at={@At(value="TAIL")}, method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"})
    private void setAngles(T livingEntity, float f, float g, float h, float i, float j, CallbackInfo info) {
        if (livingEntity instanceof Player) {
            boolean isGliding;
            Player player = (Player)livingEntity;
            ItemStack stack1 = livingEntity.getItemInHand(InteractionHand.MAIN_HAND);
            ItemStack stack2 = livingEntity.getItemInHand(InteractionHand.OFF_HAND);
            if (stack1.getItem() instanceof Glider && Glider.Companion.isEnabled(stack1) || stack2.getItem() instanceof Glider && Glider.Companion.isEnabled(stack2)) {
                this.rightArm.xRot = -0.35f;
                this.rightArm.zRot = 0.0f;
                this.rightArm.yRot = 0.0f;
                this.leftArm.xRot = -0.35f;
                this.leftArm.zRot = 0.0f;
                this.leftArm.yRot = 0.0f;
            }
            if (isGliding = GliderHelper.INSTANCE.isPlayerGliding(player)) {
                this.rightLeg.xRot = 0.0f;
                this.rightLeg.zRot = 0.0f;
                this.rightLeg.yRot = 0.0f;
                this.leftLeg.xRot = 0.0f;
                this.leftLeg.zRot = 0.0f;
                this.leftArm.yRot = 0.0f;
            }
        }
    }
}

