/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.mixin;

import io.github.lucaargolo.kibe.block.Elevator;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    private Level level;
    @Shadow
    private Vec3 position;

    @Shadow
    public abstract BlockPos blockPosition();

    @Shadow
    public abstract boolean isSpectator();

    @Shadow
    public abstract void teleportTo(double var1, double var3, double var5);

    @Inject(at={@At(value="HEAD")}, method={"setShiftKeyDown(Z)V"})
    private void setSneaking(boolean sneaking, CallbackInfo info) {
        BlockPos pos;
        Block block;
        if (sneaking && !this.isSpectator() && (block = this.level.getBlockState((pos = this.blockPosition()).below()).getBlock()) instanceof Elevator && this.level.getBlockState(pos).getCollisionShape((BlockGetter)this.level, pos).isEmpty()) {
            pos = pos.below();
            while (pos.getY() > this.level.getMinBuildHeight()) {
                if (this.level.getBlockState(pos.below()).getBlock().equals(block) && Elevator.Companion.isElevatorValid(this.level, pos.below())) {
                    this.teleportTo(this.position.x, (double)pos.below().getY() + 1.15, this.position.z);
                    this.level.playSound(null, pos, SoundEvents.PISTON_CONTRACT, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.15f + 0.6f);
                    break;
                }
                pos = pos.below();
            }
        }
    }
}

