/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.mixin;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lucaargolo.kibe.block.EntangledChest;
import io.github.lucaargolo.kibe.block.EntangledTank;
import io.github.lucaargolo.kibe.blockentity.BlockEntityCompendium;
import io.github.lucaargolo.kibe.utils.ModIdentifier;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={GameRenderer.class})
public class GameRendererMixin {
    @Shadow
    @Final
    Minecraft minecraft;
    @Unique
    private static final ResourceLocation TEXTURE = ModIdentifier.INSTANCE.of("textures/gui/entangled_rune_set.png");

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;getOverlay()Lnet/minecraft/client/gui/screens/Overlay;", ordinal=0)}, method={"render(Lnet/minecraft/client/DeltaTracker;Z)V"}, locals=LocalCapture.CAPTURE_FAILSOFT)
    public void renderEntangledRuneSet(DeltaTracker tickCounter, boolean tick, CallbackInfo ci, boolean bl, int i, int j, Window window, Matrix4f matrix4f, Matrix4fStack matrix4fStack, GuiGraphics context) {
        if (this.minecraft.level != null && this.minecraft.player != null) {
            BlockHitResult blockHitResult;
            BlockPos pos;
            BlockState state;
            Block block;
            HitResult hitResult;
            assert (this.minecraft.hitResult != null);
            ItemStack stack = this.minecraft.player.getItemInHand(InteractionHand.MAIN_HAND);
            if (stack.getItem() instanceof DyeItem && this.minecraft.hitResult.getType() == HitResult.Type.BLOCK && (hitResult = this.minecraft.hitResult) instanceof BlockHitResult && ((block = (state = this.minecraft.level.getBlockState(pos = (blockHitResult = (BlockHitResult)hitResult).getBlockPos())).getBlock()) instanceof EntangledChest || block instanceof EntangledTank)) {
                Integer selected = EntangledChest.Companion.getRuneByPos(blockHitResult.getLocation().x - (double)pos.getX(), blockHitResult.getLocation().z - (double)pos.getZ());
                this.minecraft.level.getBlockEntity(pos, BlockEntityCompendium.INSTANCE.getENTANGLED_CHEST()).ifPresent(chest -> GameRendererMixin.drawEntangledRuneSet(context, window.getGuiScaledWidth() / 2 - 46, window.getGuiScaledHeight() / 2 + 8, chest.getRuneColors(), selected));
                this.minecraft.level.getBlockEntity(pos, BlockEntityCompendium.INSTANCE.getENTANGLED_TANK()).ifPresent(tank2 -> GameRendererMixin.drawEntangledRuneSet(context, window.getGuiScaledWidth() / 2 - 46, window.getGuiScaledHeight() / 2 + 8, tank2.getRuneColors(), selected));
            }
        }
    }

    @Unique
    private static void drawEntangledRuneSet(GuiGraphics context, int startX, int startY, DyeColor[] runeColors, Integer selected) {
        context.setColor(1.0f, 1.0f, 1.0f, 0.75f);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        context.blit(TEXTURE, startX, startY, 0, 0, 92, 20);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        context.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        for (int idx = 0; idx < runeColors.length; ++idx) {
            DyeColor col = runeColors[idx];
            context.blit(TEXTURE, startX + 7 + idx * 10, startY + 5, col.getId() * 8, 20, 8, 10);
        }
        if (selected != null) {
            context.blit(TEXTURE, startX + 6 + selected * 10, startY + 4, 92, 0, 10, 12);
        }
    }
}

