/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.mixin;

import io.github.lucaargolo.kibe.block.Elevator;
import io.github.lucaargolo.kibe.effect.EffectCompendium;
import io.github.lucaargolo.kibe.enchantment.EnchantmentCompendium;
import io.github.lucaargolo.kibe.item.Glider;
import io.github.lucaargolo.kibe.item.ItemCompendium;
import io.github.lucaargolo.kibe.item.SleepingBag;
import io.github.lucaargolo.kibe.mixed.LivingEntityMixed;
import io.github.lucaargolo.kibe.utils.SlimeBounceHandler;
import io.github.lucaargolo.kibe.utils.helper.SpikeHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements LivingEntityMixed {
    private static final class_2940<Boolean> CURSED = class_2945.method_12791(class_1309.class, (class_2941)class_2943.field_13323);

    @Shadow
    public abstract class_1799 method_5998(class_1268 var1);

    @Shadow
    public abstract boolean method_6082(double var1, double var3, double var5, boolean var7);

    @Shadow
    public abstract boolean method_6059(class_6880<class_1291> var1);

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(at={@At(value="TAIL")}, method={"initDataTracker"})
    private void initDataTracker(class_2945.class_9222 builder, CallbackInfo ci) {
        builder.method_56912(CURSED, (Object)false);
    }

    @Inject(at={@At(value="HEAD")}, method={"onStatusEffectApplied"})
    private void addStatusEffect(class_1293 effect, class_1297 source, CallbackInfo ci) {
        if (effect.method_5579().equals(EffectCompendium.INSTANCE.getCURSED())) {
            this.field_6011.method_12778(CURSED, (Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"onStatusEffectRemoved"})
    private void removeStatusEffect(class_1293 effect, CallbackInfo ci) {
        if (effect.method_5579().equals(EffectCompendium.INSTANCE.getCURSED())) {
            this.field_6011.method_12778(CURSED, (Object)false);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"readCustomDataFromNbt"})
    private void afterReadNbt(class_2487 nbt, CallbackInfo ci) {
        if (this.method_6059(EffectCompendium.INSTANCE.getCURSED())) {
            this.field_6011.method_12778(CURSED, (Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"swingHand(Lnet/minecraft/util/Hand;)V"}, cancellable=true)
    private void swingHand(class_1268 hand, CallbackInfo info) {
        class_1799 stack = this.method_5998(hand);
        if (stack.method_7909() instanceof Glider && Glider.Companion.isEnabled(stack)) {
            info.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isSleepingInBed"}, cancellable=true)
    private void isSleepingInBed(CallbackInfoReturnable<Boolean> info) {
        if (SleepingBag.Companion.getPlayersSleeping().contains(this)) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"jump"})
    private void jump(CallbackInfo info) {
        class_2338 pos = this.method_24515();
        class_2248 block = this.method_37908().method_8320(pos.method_10074()).method_26204();
        if (block instanceof Elevator && this.method_37908().method_8320(pos).method_26220((class_1922)this.method_37908(), pos).method_1110()) {
            while (pos.method_10264() < this.method_37908().method_31600()) {
                if (this.method_37908().method_8320(pos.method_10084()).method_26204().equals(block) && Elevator.Companion.isElevatorValid(this.method_37908(), pos.method_10084())) {
                    this.method_6082(this.method_19538().field_1352, (double)pos.method_10084().method_10264() + 1.15, this.method_19538().field_1350, false);
                    this.method_37908().method_8396(null, pos, class_3417.field_15134, class_3419.field_15245, 0.5f, this.method_37908().field_9229.method_43057() * 0.25f + 0.6f);
                    break;
                }
                pos = pos.method_10084();
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"handleFallDamage"})
    private void handleFallDamage(float fallDistance, float damageMultiplier, class_1282 source, CallbackInfoReturnable<Boolean> info) {
        if (this instanceof class_1657) {
            boolean isSlimy;
            class_1657 player = (class_1657)this;
            class_1799 feetStack = player.method_6118(class_1304.field_6166);
            boolean bl = isSlimy = feetStack.method_7909() == ItemCompendium.INSTANCE.getSLIME_BOOTS();
            if (!isSlimy) {
                isSlimy = feetStack.method_58657().method_57534().stream().anyMatch(enchantment -> EnchantmentCompendium.INSTANCE.getSLIMY().equals(enchantment.method_40230().orElse(null)));
            }
            if (isSlimy) {
                if (!this.method_5715() && fallDistance > 2.0f) {
                    this.field_6017 = 0.0f;
                    if (this.method_37908().field_9236) {
                        this.method_18800(this.method_18798().field_1352, this.method_18798().field_1351 * -0.9, this.method_18798().field_1350);
                        this.field_6007 = true;
                        this.method_24830(false);
                        double f = 0.9500000000000001;
                        this.method_18800(this.method_18798().field_1352 / f, this.method_18798().field_1351, this.method_18798().field_1350 / f);
                    } else {
                        info.cancel();
                    }
                    this.method_5783(class_3417.field_15095, 1.0f, 1.0f);
                    SlimeBounceHandler.Companion.addBounceHandler((class_1309)player, this.method_18798().field_1351);
                } else if (!this.method_37908().field_9236 && this.method_5715() && fallDistance > 5.0f) {
                    this.field_6017 = 5.0f;
                }
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"shouldDropLoot"}, cancellable=true)
    private void shouldDropLoot(CallbackInfoReturnable<Boolean> cir) {
        class_1309 livingEntity = (class_1309)this;
        if (SpikeHelper.INSTANCE.shouldCancelLootDrop(livingEntity)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Override
    public boolean kibe$isCursed() {
        return (Boolean)this.field_6011.method_12789(CURSED);
    }
}

