/*
 * Decompiled with CFR 0.152.
 */
package dev.micalobia.fullslabs;

import com.google.common.collect.BiMap;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.micalobia.fullslabs.FullSlabs;
import dev.micalobia.fullslabs.block.MixedSlabBlock;
import dev.micalobia.fullslabs.block.OxidizableVerticalSlabBlock;
import dev.micalobia.fullslabs.block.VerticalSlabBlock;
import dev.micalobia.fullslabs.block.entity.MixedSlabBlockEntity;
import dev.micalobia.fullslabs.fabric.SlabRegistryImpl;
import dev.micalobia.fullslabs.handlers.MixedHandler;
import dev.micalobia.fullslabs.handlers.MixedHandlers;
import dev.micalobia.fullslabs.handlers.OxidizableMixedHandler;
import dev.micalobia.fullslabs.handlers.VanillaMixedHandler;
import dev.micalobia.fullslabs.mixin.BlockEntityTypeAccessor;
import dev.micalobia.fullslabs.util.Utility;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2248;
import net.minecraft.class_2482;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5813;
import net.minecraft.class_5953;
import net.minecraft.class_5955;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class SlabRegistry {
    private static final Map<Class<? extends class_2482>, VerticalFactory> MAPPING = new HashMap<Class<? extends class_2482>, VerticalFactory>();
    private static final Map<Class<? extends class_2482>, PairConsumer> POST_INIT = new HashMap<Class<? extends class_2482>, PairConsumer>();
    private static final DeferredRegister<class_2248> BLOCKS = DeferredRegister.create((String)"fullslabs", (class_5321)class_7924.field_41254);
    private static final DeferredRegister<class_2248> GENERATED = DeferredRegister.create((String)"fullslabs", (class_5321)class_7924.field_41254);
    private static final DeferredRegister<class_2591<?>> BLOCK_ENTITIES = DeferredRegister.create((String)"fullslabs", (class_5321)class_7924.field_41255);
    public static final RegistrySupplier<MixedSlabBlock> MIXED_SLAB = SlabRegistry.registerBlock("mixed_slab", MixedSlabBlock::new);
    public static final RegistrySupplier<class_2591<MixedSlabBlockEntity>> MIXED_SLAB_ENTITY = BLOCK_ENTITIES.register(FullSlabs.id("mixed_slab"), () -> BlockEntityTypeAccessor.constructor(MixedSlabBlockEntity::new, Set.of((class_2248)MIXED_SLAB.get())));

    private SlabRegistry() {
    }

    private static <T extends class_2248> RegistrySupplier<T> registerBlock(String id, Function<class_4970.class_2251, T> func) {
        return SlabRegistry.registerBlock(id, func, class_4970.class_2251::method_9637);
    }

    private static <T extends class_2248> RegistrySupplier<T> registerBlock(String id, Function<class_4970.class_2251, T> func, Supplier<class_4970.class_2251> settings) {
        return BLOCKS.register(id, () -> (class_2248)func.apply(((class_4970.class_2251)settings.get()).method_63500(SlabRegistry.generateKey(id))));
    }

    public static void init() {
        SlabRegistry.registerVanilla();
        SlabRegistry.initSlabListener();
        SlabRegistry.seedExistingSlabs();
        BLOCKS.register();
        BLOCK_ENTITIES.register();
        GENERATED.register();
        LifecycleEvent.SETUP.register(() -> VerticalSlabBlock.MAP_VIEW.keySet().stream().filter(slab -> POST_INIT.containsKey(slab.getClass())).forEach(slab -> POST_INIT.get(slab.getClass()).consume(slab, VerticalSlabBlock.getVertical(slab))));
    }

    private static void registerVanilla() {
        SlabRegistry.registerVertical(class_2482.class, VerticalSlabBlock::new);
        MixedHandlers.register(class_2482.class, (MixedHandler)VanillaMixedHandler.INSTANCE);
        SlabRegistry.registerVertical(class_5813.class, OxidizableVerticalSlabBlock::new, SlabRegistry::registerOxidizableSlabs);
        MixedHandlers.register(class_5813.class, (MixedHandler)OxidizableMixedHandler.INSTANCE);
    }

    private static void registerDebug() {
        SlabRegistry.registerBlock("debug", class_2248::new);
        SlabRegistry.registerBlock("debug_slab", class_2482::new);
    }

    private static class_5321<class_2248> generateKey(String path) {
        return SlabRegistry.generateKey(FullSlabs.id(path));
    }

    private static class_5321<class_2248> generateKey(class_2960 id) {
        return class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)id);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void initSlabListener() {
        SlabRegistryImpl.initSlabListener();
    }

    public static void registerOxidizableBlockPair(class_2248 less, class_2248 more) {
        Objects.requireNonNull(less, "Oxidizable block cannot be null!");
        Objects.requireNonNull(more, "Oxidizable block cannot be null!");
        ((BiMap)class_5955.field_29564.get()).forcePut((Object)less, (Object)more);
    }

    public static void registerWaxableBlockPair(class_2248 unwaxed, class_2248 waxed) {
        Objects.requireNonNull(unwaxed, "Unwaxed block cannot be null!");
        Objects.requireNonNull(waxed, "Waxed block cannot be null!");
        ((BiMap)class_5953.field_29560.get()).forcePut((Object)unwaxed, (Object)waxed);
    }

    private static void registerOxidizableSlabs(class_2482 slab, VerticalSlabBlock vertical) {
        Optional less = class_5955.method_34732((class_2248)slab);
        Optional more = class_5955.method_34737((class_2248)slab);
        Optional lessWaxed = less.flatMap(Utility::getWaxed);
        Optional<class_2248> slabWaxed = Utility.getWaxed((class_2248)slab);
        Optional moreWaxed = more.flatMap(Utility::getWaxed);
        Optional lessVertical = less.flatMap(VerticalSlabBlock::tryGetVertical);
        Optional moreVertical = more.flatMap(VerticalSlabBlock::tryGetVertical);
        Optional lessWaxedVertical = lessWaxed.flatMap(VerticalSlabBlock::tryGetVertical);
        Optional slabWaxedVertical = slabWaxed.flatMap(VerticalSlabBlock::tryGetVertical);
        Optional moreWaxedVertical = moreWaxed.flatMap(VerticalSlabBlock::tryGetVertical);
        lessVertical.ifPresent(_less -> {
            SlabRegistry.registerOxidizableBlockPair(_less, vertical);
            lessWaxedVertical.ifPresent(_waxed -> {
                SlabRegistry.registerWaxableBlockPair(_less, _waxed);
                MixedHandlers.register((class_2248)_waxed, (MixedHandler)OxidizableMixedHandler.INSTANCE);
            });
        });
        moreVertical.ifPresent(_more -> {
            SlabRegistry.registerOxidizableBlockPair(vertical, _more);
            moreWaxedVertical.ifPresent(_waxed -> {
                SlabRegistry.registerWaxableBlockPair(_more, _waxed);
                MixedHandlers.register((class_2248)_waxed, (MixedHandler)OxidizableMixedHandler.INSTANCE);
            });
        });
        slabWaxedVertical.ifPresent(_waxed -> {
            SlabRegistry.registerWaxableBlockPair(vertical, _waxed);
            MixedHandlers.register((class_2248)_waxed, (MixedHandler)OxidizableMixedHandler.INSTANCE);
        });
    }

    public static <S extends class_2482, V extends VerticalSlabBlock> void registerVertical(Class<S> slabClass, VerticalFactory<S, V> factory) {
        SlabRegistry.registerVertical(slabClass, factory, null);
    }

    public static <S extends class_2482, V extends VerticalSlabBlock> void registerVertical(Class<S> slabClass, VerticalFactory<S, V> factory, @Nullable PairConsumer<S, V> listener) {
        VerticalFactory<S, V> old = MAPPING.putIfAbsent(slabClass, factory);
        if (old != null) {
            throw new IllegalArgumentException("That slab class has already been registered!");
        }
        if (listener != null) {
            POST_INIT.put(slabClass, listener);
        }
    }

    private static void seedExistingSlabs() {
        List<class_2248> slabs = class_7923.field_41175.method_10220().filter(class_2482.class::isInstance).toList();
        for (class_2248 block : slabs) {
            SlabRegistry.tryRegisterVertical(class_7923.field_41175.method_10221((Object)block), block);
        }
    }

    @ApiStatus.Internal
    public static void tryRegisterVertical(class_2960 id, class_2248 block) {
        if (!(block instanceof class_2482)) {
            return;
        }
        class_2482 slab = (class_2482)block;
        VerticalFactory factory = MAPPING.get(slab.getClass());
        if (factory == null) {
            FullSlabs.LOGGER.warn("{} ({}) failed to register a vertical!", (Object)slab, (Object)slab.getClass().getSimpleName());
            return;
        }
        class_2960 verticalId = FullSlabs.id(FullSlabs.verticalPath(id));
        RegistrySupplier b = GENERATED.register(verticalId, () -> {
            class_4970.class_2251 settings = class_4970.class_2251.method_9630((class_4970)slab).method_63500(SlabRegistry.generateKey(verticalId)).method_63502(slab.method_26162());
            return factory.create(slab, settings);
        });
    }

    public static interface VerticalFactory<S extends class_2482, V extends VerticalSlabBlock> {
        public V create(S var1, class_4970.class_2251 var2);
    }

    public static interface PairConsumer<S extends class_2482, V extends VerticalSlabBlock> {
        public void consume(S var1, V var2);
    }
}

