/*
 * Decompiled with CFR 0.152.
 */
package dev.micalobia.fullslabs.block;

import dev.micalobia.fullslabs.handlers.MixedHandlers;
import dev.micalobia.fullslabs.util.Utility;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1309;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2482;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3486;
import net.minecraft.class_3542;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class VerticalSlabBlock
extends class_2248
implements class_3737 {
    private static final Map<class_2482, VerticalSlabBlock> MAP = new HashMap<class_2482, VerticalSlabBlock>();
    public static final class_2754<class_2350> DIRECTION = class_2741.field_12481;
    public static final class_2754<VerticalType> TYPE = class_2754.method_11850((String)"type", VerticalType.class);
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_265 NORTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    public static final class_265 EAST_SHAPE = class_2248.method_9541((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final class_265 SOUTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    public static final class_265 WEST_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    public static final Map<class_2482, VerticalSlabBlock> MAP_VIEW = Collections.unmodifiableMap(MAP);
    public final class_2482 parent;

    public VerticalSlabBlock(class_2482 block, class_4970.class_2251 settings) {
        super(settings);
        this.parent = block;
        MAP.put(block, this);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(DIRECTION, (Comparable)class_2350.field_11039)).method_11657(TYPE, (Comparable)((Object)VerticalType.TOWARDS))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected boolean method_9526(class_2680 state) {
        return state.method_11654(TYPE) != VerticalType.FULL;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{DIRECTION, TYPE, WATERLOGGED});
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        VerticalType type = (VerticalType)((Object)state.method_11654(TYPE));
        if (type == VerticalType.FULL) {
            return class_259.method_1077();
        }
        boolean towards = type == VerticalType.TOWARDS;
        return switch ((class_2350)state.method_11654(DIRECTION)) {
            case class_2350.field_11043 -> {
                if (towards) {
                    yield NORTH_SHAPE;
                }
                yield SOUTH_SHAPE;
            }
            case class_2350.field_11034 -> {
                if (towards) {
                    yield EAST_SHAPE;
                }
                yield WEST_SHAPE;
            }
            case class_2350.field_11035 -> {
                if (towards) {
                    yield SOUTH_SHAPE;
                }
                yield NORTH_SHAPE;
            }
            case class_2350.field_11039 -> {
                if (towards) {
                    yield WEST_SHAPE;
                }
                yield EAST_SHAPE;
            }
            default -> throw new IllegalArgumentException();
        };
    }

    protected boolean method_9616(class_2680 state, class_1750 context) {
        class_1799 stack = context.method_8041();
        VerticalType type = (VerticalType)((Object)state.method_11654(TYPE));
        if (type == VerticalType.FULL) {
            return false;
        }
        class_2248 block = ((class_1747)stack.method_7909()).method_7711();
        if (!(block instanceof class_2482)) {
            return false;
        }
        if (!(block == this.parent || MixedHandlers.hasHandler(block) && MixedHandlers.hasHandler(this))) {
            return false;
        }
        if (context.method_7717()) {
            return Utility.isInsideSlab(state, context.method_8037(), context.method_17698());
        }
        return true;
    }

    protected class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public boolean method_10311(class_1936 world, class_2338 pos, class_2680 state, class_3610 fluidState) {
        return state.method_11654(TYPE) != VerticalType.FULL && super.method_10311(world, pos, state, fluidState);
    }

    public boolean method_10310(@Nullable class_1309 filler, class_1922 world, class_2338 pos, class_2680 state, class_3611 fluid) {
        return state.method_11654(TYPE) != VerticalType.FULL && super.method_10310(filler, world, pos, state, fluid);
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            tickView.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }
        return super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    protected boolean method_9516(class_2680 state, class_10 type) {
        return type == class_10.field_48 && state.method_26227().method_15767(class_3486.field_15517);
    }

    public class_1792 method_8389() {
        return this.parent.method_8389();
    }

    public static VerticalSlabBlock getVertical(class_2482 block) {
        return MAP.get(block);
    }

    public static Optional<VerticalSlabBlock> tryGetVertical(class_2248 block) {
        if (block instanceof class_2482) {
            class_2482 slab = (class_2482)block;
            return Optional.ofNullable(MAP.get(slab));
        }
        if (block instanceof VerticalSlabBlock) {
            VerticalSlabBlock slab = (VerticalSlabBlock)block;
            return Optional.of(slab);
        }
        return Optional.empty();
    }

    public static class_2482 getRoot(class_2248 block) {
        return VerticalSlabBlock.tryGetRoot(block).orElseThrow(() -> new IllegalArgumentException("Not a slab or missing vertical!"));
    }

    public static Optional<class_2482> tryGetRoot(class_2248 block) {
        Object slab;
        if (block instanceof class_2482 && VerticalSlabBlock.hasVertical(slab = (class_2482)block)) {
            return Optional.of(slab);
        }
        if (block instanceof VerticalSlabBlock) {
            slab = (VerticalSlabBlock)block;
            return Optional.of(slab.parent);
        }
        return Optional.empty();
    }

    public static boolean hasVertical(class_2482 block) {
        return MAP.containsKey(block);
    }

    public static enum VerticalType implements class_3542
    {
        TOWARDS("towards"),
        AWAY("away"),
        FULL("full");

        private final String name;

        private VerticalType(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

