/*
 * Decompiled with CFR 0.152.
 */
package dev.micalobia.fullslabs.block.entity;

import dev.micalobia.fullslabs.FullSlabs;
import dev.micalobia.fullslabs.SlabRegistry;
import dev.micalobia.fullslabs.block.MixedSlabBlock;
import dev.micalobia.fullslabs.block.VerticalSlabBlock;
import dev.micalobia.fullslabs.handlers.MixedHandlers;
import java.util.Objects;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_3965;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class MixedSlabBlockEntity
extends class_2586 {
    private static class_3545<class_2482, class_2482> CACHE = new class_3545((Object)((class_2482)class_2246.field_10454), (Object)((class_2482)class_2246.field_10454));
    private class_2482 towards;
    private class_2482 away;

    public MixedSlabBlockEntity(class_2338 pos, class_2680 state, class_2482 towards, class_2482 away) {
        super((class_2591)SlabRegistry.MIXED_SLAB_ENTITY.get(), pos, state);
        this.towards = towards;
        this.away = away;
    }

    public MixedSlabBlockEntity(class_2338 pos, class_2680 state) {
        this(pos, state, (class_2482)class_2246.field_10454, (class_2482)class_2246.field_10454);
    }

    public class_2680 getTowardsState() {
        return ((MixedSlabBlock.MixedType)((Object)this.method_11010().method_11654(MixedSlabBlock.TYPE))).state(this.towards, true);
    }

    public class_2680 getAwayState() {
        return ((MixedSlabBlock.MixedType)((Object)this.method_11010().method_11654(MixedSlabBlock.TYPE))).state(this.away, false);
    }

    public class_2680 getState(boolean towards) {
        return ((MixedSlabBlock.MixedType)((Object)this.method_11010().method_11654(MixedSlabBlock.TYPE))).state(towards ? this.towards : this.away, towards);
    }

    public class_2680 getTargetedState(class_3965 crosshair) {
        return this.getTargetedState(crosshair.method_17777(), crosshair.method_17784());
    }

    public class_2680 getTargetedState(class_2338 pos, class_243 hit) {
        MixedSlabBlock.MixedType type;
        boolean towards = (type = (MixedSlabBlock.MixedType)((Object)this.method_11010().method_11654(MixedSlabBlock.TYPE))).isAxisTargetTowards(hit, pos);
        return type.state(towards ? this.towards : this.away, towards);
    }

    public class_2482 getTowards() {
        return this.towards;
    }

    public class_2482 getAway() {
        return this.away;
    }

    public class_2482 getBlock(boolean towards) {
        return towards ? this.towards : this.away;
    }

    public boolean setTowards(class_2248 slab) {
        return this.setBlock(slab, true);
    }

    public boolean setAway(class_2248 slab) {
        return this.setBlock(slab, false);
    }

    public boolean setBlock(class_2248 block, boolean towards) {
        class_2482 slab = VerticalSlabBlock.getRoot(block);
        if (!MixedHandlers.hasHandler((class_2248)slab)) {
            return false;
        }
        if (towards) {
            this.towards = slab;
        } else {
            this.away = slab;
        }
        this.method_5431();
        this.syncModel();
        return true;
    }

    public class_2482 getTargetedSlab(class_3965 crosshair) {
        MixedSlabBlock.MixedType type = (MixedSlabBlock.MixedType)((Object)this.method_11010().method_11654(MixedSlabBlock.TYPE));
        return this.getBlock(type.isAxisTargetTowards(crosshair.method_17784(), crosshair.method_17777()));
    }

    @ApiStatus.Internal
    public static void writeCache(class_2482 towards, class_2482 away) {
        CACHE = new class_3545((Object)towards, (Object)away);
    }

    @ApiStatus.Internal
    public void readCache() {
        this.towards = (class_2482)CACHE.method_15442();
        this.away = (class_2482)CACHE.method_15441();
    }

    protected void method_11007(class_11372 view) {
        view.method_71469("towards_id", class_7923.field_41175.method_10221((Object)this.towards).toString());
        view.method_71469("away_id", class_7923.field_41175.method_10221((Object)this.away).toString());
    }

    protected void method_11014(class_11368 view) {
        class_2482 slab;
        String towardsStr = view.method_71428("towards_id", "minecraft:stone_slab");
        String awayStr = view.method_71428("away_id", "minecraft:stone_slab");
        Object object = class_7923.field_41175.method_63535(class_2960.method_60654((String)towardsStr));
        if (object instanceof class_2482) {
            this.towards = slab = (class_2482)object;
        } else {
            FullSlabs.LOGGER.warn("missing \"{}\": replacing with \"minecraft:stone_slab\"", (Object)towardsStr);
            this.towards = (class_2482)class_2246.field_10454;
        }
        object = class_7923.field_41175.method_63535(class_2960.method_60654((String)awayStr));
        if (object instanceof class_2482) {
            this.away = slab = (class_2482)object;
        } else {
            FullSlabs.LOGGER.warn("missing \"{}\": replacing with \"minecraft:stone_slab\"", (Object)awayStr);
            this.away = (class_2482)class_2246.field_10454;
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_38244(registries);
    }

    public void syncModel() {
        Objects.requireNonNull(this.field_11863).method_8427(this.field_11867, this.method_11010().method_26204(), 0, 0);
    }

    public record ModelContext(int towards, int away) {
        public static ModelContext fromStates(class_2680 towards, class_2680 away) {
            return new ModelContext(class_2248.method_9507((class_2680)towards), class_2248.method_9507((class_2680)away));
        }

        public class_2680 towardsState() {
            return class_2248.method_9531((int)this.towards);
        }

        public class_2680 awayState() {
            return class_2248.method_9531((int)this.away);
        }
    }
}

