/*
 * Decompiled with CFR 0.152.
 */
package dev.micalobia.fullslabs.client;

import dev.micalobia.fullslabs.config.Controls;
import dev.micalobia.fullslabs.util.SlabPlacement;
import dev.micalobia.fullslabs.util.Utility;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_11658;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_9799;
import org.jetbrains.annotations.Nullable;

public final class BlockFaceOverlay {
    private static final double EPSILON = 1.0E-4;
    private static final int FILL_COLOR = 1056997375;
    private static final int LINE_COLOR = -1;
    private static final class_1921 QUAD_LAYER = class_1921.method_49042();
    private static final class_1921 LINE_LAYER = class_1921.method_49043((double)2.0);

    private BlockFaceOverlay() {
    }

    public static void renderFaceOverlay(class_11658 renderState) {
        if (!Controls.isOverlayActive()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_239 class_2392 = mc.field_1765;
        if (!(class_2392 instanceof class_3965)) {
            return;
        }
        class_3965 bhr = (class_3965)class_2392;
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        if (!player.method_24520(Utility::isSlabWithVertical)) {
            return;
        }
        class_638 world = mc.field_1687;
        if (world == null) {
            return;
        }
        class_2338 pos = bhr.method_17777();
        class_2350 face = bhr.method_17780();
        class_243 hit = bhr.method_17784();
        class_2680 state = world.method_8320(pos);
        BlockFaceOverlay.renderFaceOverlay((class_1657)player, renderState.field_63082.field_63078, (class_1920)world, pos, state, face, hit);
    }

    private static void renderFaceOverlay(class_1657 player, class_243 camera, class_1920 world, class_2338 pos, class_2680 state, class_2350 face, class_243 hit) {
        FaceFrame frame = FaceFrame.create(face);
        class_2350 playerFacing = player.method_5735();
        SlabPlacement.Mode mode = Controls.getPlacementMode(player.method_5667());
        FaceRegion at = Utility.isSlab(state) && Utility.isInsideSlab(state, pos, hit) ? null : BlockFaceOverlay.getRegion(mode, face, playerFacing, pos, hit);
        class_265 outline = state.method_26172((class_1922)world, pos, class_3726.method_16195((class_1297)player));
        if (outline.method_1110()) {
            return;
        }
        class_243 nHit = hit.method_1023((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        LinkedHashMap<class_1921, class_9799> map = new LinkedHashMap<class_1921, class_9799>();
        map.put(QUAD_LAYER, new class_9799(1024));
        map.put(LINE_LAYER, new class_9799(512));
        class_4597.class_4598 immediate = class_4597.method_22992(map, (class_9799)new class_9799(1024));
        class_4587 stack = new class_4587();
        stack.method_22903();
        stack.method_22904((double)pos.method_10263() + 0.5 - camera.field_1352, (double)pos.method_10264() + 0.5 - camera.field_1351, (double)pos.method_10260() + 0.5 - camera.field_1350);
        switch (face) {
            case field_11033: {
                stack.method_22904(0.0, nHit.field_1351, 0.0);
                break;
            }
            case field_11036: {
                stack.method_22904(0.0, nHit.field_1351 - 1.0, 0.0);
                break;
            }
            case field_11043: {
                stack.method_22904(0.0, 0.0, nHit.field_1350);
                break;
            }
            case field_11035: {
                stack.method_22904(0.0, 0.0, nHit.field_1350 - 1.0);
                break;
            }
            case field_11039: {
                stack.method_22904(nHit.field_1352, 0.0, 0.0);
                break;
            }
            case field_11034: {
                stack.method_22904(nHit.field_1352 - 1.0, 0.0, 0.0);
            }
        }
        class_4587.class_4665 entry = stack.method_23760();
        HashMap<EdgeKey, UVSeg> edgeMap = new HashMap<EdgeKey, UVSeg>();
        outline.method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
            RectUV rect = BlockFaceOverlay.faceRectOnBox(face, minX, minY, minZ, maxX, maxY, maxZ, nHit.field_1352, nHit.field_1351, nHit.field_1350);
            if (rect == null || rect.isDegenerate()) {
                return;
            }
            List<class_241> poly = BlockFaceOverlay.rectToCenteredPolygon(rect);
            poly = BlockFaceOverlay.clipPolygonByAt(mode, poly, at);
            int size = poly.size();
            for (int i = 0; i < size; ++i) {
                class_241 a = poly.get(i);
                class_241 b = poly.get((i + 1) % size);
                BlockFaceOverlay.addEdgeQuantized(edgeMap, a, b);
            }
            BlockFaceOverlay.emitFill(entry, (class_4597)immediate, frame, poly);
        });
        immediate.method_22993();
        BlockFaceOverlay.drawLines(entry, immediate, frame, edgeMap);
        stack.method_22909();
    }

    private static void putVertex(class_4588 vc, class_4587.class_4665 e, class_243 p, class_243 n) {
        vc.method_22918(e.method_23761(), (float)p.field_1352, (float)p.field_1351, (float)p.field_1350).method_39415(1056997375).method_60831(e, (float)n.field_1352, (float)n.field_1351, (float)n.field_1350);
    }

    private static class_243 uvToWorld(double u, double v, FaceFrame b) {
        double half = 0.5;
        double px = u - half;
        double py = v - half;
        class_243 U = b.u();
        class_243 V = b.v();
        class_243 N = b.n();
        double x = U.method_10216() * px + V.method_10216() * py + N.method_10216() * half;
        double y = U.method_10214() * px + V.method_10214() * py + N.method_10214() * half;
        double z = U.method_10215() * px + V.method_10215() * py + N.method_10215() * half;
        return new class_243(x, y, z);
    }

    private static RectUV faceRectOnBox(class_2350 face, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, double depthX, double depthY, double depthZ) {
        double eps = 1.0E-4;
        return switch (face) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11043 -> {
                if (Math.abs(minZ - depthZ) < 1.0E-4) {
                    yield new RectUV(minX, minY, maxX, maxY);
                }
                yield null;
            }
            case class_2350.field_11035 -> {
                if (Math.abs(maxZ - depthZ) < 1.0E-4) {
                    yield new RectUV(minX, minY, maxX, maxY);
                }
                yield null;
            }
            case class_2350.field_11039 -> {
                if (Math.abs(minX - depthX) < 1.0E-4) {
                    yield new RectUV(minZ, minY, maxZ, maxY);
                }
                yield null;
            }
            case class_2350.field_11034 -> {
                if (Math.abs(maxX - depthX) < 1.0E-4) {
                    yield new RectUV(minZ, minY, maxZ, maxY);
                }
                yield null;
            }
            case class_2350.field_11033 -> {
                if (Math.abs(minY - depthY) < 1.0E-4) {
                    yield new RectUV(minX, minZ, maxX, maxZ);
                }
                yield null;
            }
            case class_2350.field_11036 -> Math.abs(maxY - depthY) < 1.0E-4 ? new RectUV(minX, minZ, maxX, maxZ) : null;
        };
    }

    private static List<class_241> rectToCenteredPolygon(RectUV r) {
        float u0 = (float)(r.u0 - 0.5);
        float v0 = (float)(r.v0 - 0.5);
        float u1 = (float)(r.u1 - 0.5);
        float v1 = (float)(r.v1 - 0.5);
        ArrayList<class_241> poly = new ArrayList<class_241>(4);
        poly.add(new class_241(u0, v0));
        poly.add(new class_241(u1, v0));
        poly.add(new class_241(u1, v1));
        poly.add(new class_241(u0, v1));
        return poly;
    }

    private static List<class_241> clipHalfPlane(List<class_241> in, float a, float b, float d) {
        if (in.isEmpty()) {
            return in;
        }
        ArrayList<class_241> out = new ArrayList<class_241>(in.size() + 4);
        class_241 prev = in.getLast();
        float prevL = a * prev.field_1343 + b * prev.field_1342 + d;
        boolean prevIn = prevL <= 1.0E-6f;
        for (class_241 curr : in) {
            float denom;
            boolean currIn;
            float currL = a * curr.field_1343 + b * curr.field_1342 + d;
            boolean bl = currIn = currL <= 1.0E-6f;
            if (currIn != prevIn && Math.abs(denom = a * (curr.field_1343 - prev.field_1343) + b * (curr.field_1342 - prev.field_1342)) > 1.0E-7f) {
                float t = -prevL / denom;
                float ix = prev.field_1343 + t * (curr.field_1343 - prev.field_1343);
                float iy = prev.field_1342 + t * (curr.field_1342 - prev.field_1342);
                out.add(new class_241(ix, iy));
            }
            if (currIn) {
                out.add(curr);
            }
            prev = curr;
            prevL = currL;
            prevIn = currIn;
        }
        return out;
    }

    private static List<class_241> clipPolygonByAt(SlabPlacement.Mode mode, List<class_241> poly, @Nullable FaceRegion at) {
        float inner = 0.25f;
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case SlabPlacement.Mode.HYBRID -> {
                FaceRegion var4_4 = at;
                int var5_7 = 0;
                switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"CENTER", "LEFT", "RIGHT", "TOP", "BOTTOM"}, (FaceRegion)var4_4, var5_7)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        poly = BlockFaceOverlay.clipHalfPlane(poly, 1.0f, 0.0f, -0.25f);
                        poly = BlockFaceOverlay.clipHalfPlane(poly, -1.0f, 0.0f, -0.25f);
                        poly = BlockFaceOverlay.clipHalfPlane(poly, 0.0f, 1.0f, -0.25f);
                        yield poly = BlockFaceOverlay.clipHalfPlane(poly, 0.0f, -1.0f, -0.25f);
                    }
                    case 1: {
                        poly = BlockFaceOverlay.clipHalfPlane(poly, 1.0f, 0.0f, 0.25f);
                        poly = BlockFaceOverlay.clipHalfPlane(poly, 1.0f, -1.0f, 0.0f);
                        yield poly = BlockFaceOverlay.clipHalfPlane(poly, 1.0f, 1.0f, 0.0f);
                    }
                    case 2: {
                        poly = BlockFaceOverlay.clipHalfPlane(poly, -1.0f, 0.0f, 0.25f);
                        poly = BlockFaceOverlay.clipHalfPlane(poly, -1.0f, 1.0f, 0.0f);
                        yield poly = BlockFaceOverlay.clipHalfPlane(poly, -1.0f, -1.0f, 0.0f);
                    }
                    case 3: {
                        poly = BlockFaceOverlay.clipHalfPlane(poly, 0.0f, -1.0f, 0.25f);
                        poly = BlockFaceOverlay.clipHalfPlane(poly, 1.0f, -1.0f, 0.0f);
                        yield poly = BlockFaceOverlay.clipHalfPlane(poly, -1.0f, -1.0f, 0.0f);
                    }
                    case 4: {
                        poly = BlockFaceOverlay.clipHalfPlane(poly, 0.0f, 1.0f, 0.25f);
                        poly = BlockFaceOverlay.clipHalfPlane(poly, -1.0f, 1.0f, 0.0f);
                        yield poly = BlockFaceOverlay.clipHalfPlane(poly, 1.0f, 1.0f, 0.0f);
                    }
                    case -1: 
                }
                yield poly;
            }
            case SlabPlacement.Mode.VANILLA -> {
                FaceRegion var4_5 = at;
                int var5_8 = 0;
                switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"TOP", "BOTTOM"}, (FaceRegion)var4_5, var5_8)) {
                    case 0: {
                        yield BlockFaceOverlay.clipHalfPlane(poly, 0.0f, -1.0f, 0.0f);
                    }
                    case 1: {
                        yield BlockFaceOverlay.clipHalfPlane(poly, 0.0f, 1.0f, 0.0f);
                    }
                    case -1: {
                        yield poly;
                    }
                }
                yield poly;
            }
            case SlabPlacement.Mode.VERTICAL -> {
                FaceRegion var4_6 = at;
                int var5_9 = 0;
                switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"TOP", "BOTTOM", "LEFT", "RIGHT"}, (FaceRegion)var4_6, var5_9)) {
                    case 0: {
                        yield BlockFaceOverlay.clipHalfPlane(poly, 0.0f, -1.0f, 0.0f);
                    }
                    case 1: {
                        yield BlockFaceOverlay.clipHalfPlane(poly, 0.0f, 1.0f, 0.0f);
                    }
                    case 2: {
                        yield BlockFaceOverlay.clipHalfPlane(poly, 1.0f, 0.0f, 0.0f);
                    }
                    case 3: {
                        yield BlockFaceOverlay.clipHalfPlane(poly, -1.0f, 0.0f, 0.0f);
                    }
                    case -1: {
                        yield poly;
                    }
                }
                yield poly;
            }
        };
    }

    private static void emitFill(class_4587.class_4665 entry, class_4597 provider, FaceFrame frame, List<class_241> centeredPoly) {
        if (centeredPoly.size() < 3) {
            return;
        }
        class_243 n = frame.n();
        int size = centeredPoly.size();
        class_4588 vc = provider.method_73477(QUAD_LAYER);
        class_243 p0 = BlockFaceOverlay.uvToWorld((double)centeredPoly.getFirst().field_1343 + 0.5, (double)centeredPoly.getFirst().field_1342 + 0.5, frame).method_1031(n.method_10216() * 1.0E-4, n.method_10214() * 1.0E-4, n.method_10215() * 1.0E-4);
        for (int i = 1; i < size - 1; ++i) {
            class_243 p1 = BlockFaceOverlay.uvToWorld((double)centeredPoly.get((int)i).field_1343 + 0.5, (double)centeredPoly.get((int)i).field_1342 + 0.5, frame).method_1031(n.method_10216() * 1.0E-4, n.method_10214() * 1.0E-4, n.method_10215() * 1.0E-4);
            class_243 p2 = BlockFaceOverlay.uvToWorld((double)centeredPoly.get((int)(i + 1)).field_1343 + 0.5, (double)centeredPoly.get((int)(i + 1)).field_1342 + 0.5, frame).method_1031(n.method_10216() * 1.0E-4, n.method_10214() * 1.0E-4, n.method_10215() * 1.0E-4);
            BlockFaceOverlay.putVertex(vc, entry, p0, n);
            BlockFaceOverlay.putVertex(vc, entry, p1, n);
            BlockFaceOverlay.putVertex(vc, entry, p2, n);
            BlockFaceOverlay.putVertex(vc, entry, p2, n);
        }
    }

    private static void drawLines(class_4587.class_4665 entry, class_4597.class_4598 provider, FaceFrame frame, Map<EdgeKey, UVSeg> edgeMap) {
        class_243 n = frame.n();
        class_243 offset = n.method_1021(1.0E-4);
        List<List<class_241>> chains = BlockFaceOverlay.buildChains(edgeMap);
        for (List<class_241> chain : chains) {
            chain = BlockFaceOverlay.mergeColinear(chain);
            class_4588 vc = provider.method_73477(LINE_LAYER);
            for (class_241 v : chain) {
                class_243 p = BlockFaceOverlay.uvToWorld((double)v.field_1343 + 0.5, (double)v.field_1342 + 0.5, frame).method_1019(offset);
                vc.method_56824(entry, (float)p.field_1352, (float)p.field_1351, (float)p.field_1350).method_39415(-1).method_60831(entry, (float)n.field_1352, (float)n.field_1351, (float)n.field_1350);
            }
            provider.method_22993();
        }
    }

    private static List<class_241> mergeColinear(List<class_241> in) {
        if (in.size() < 2) {
            return in;
        }
        ArrayList<class_241> out = new ArrayList<class_241>(in.size());
        class_241 prev = in.getFirst();
        out.add(prev);
        int pdx = Integer.MIN_VALUE;
        int pdy = Integer.MIN_VALUE;
        for (int i = 1; i < in.size(); ++i) {
            class_241 curr = in.get(i);
            int dx = Integer.signum(Math.round((curr.field_1343 - prev.field_1343) * 1024.0f));
            int dy = Integer.signum(Math.round((curr.field_1342 - prev.field_1342) * 1024.0f));
            if (dx == 0 && dy == 0) continue;
            if (pdx == Integer.MIN_VALUE) {
                pdx = dx;
                pdy = dy;
                out.add(curr);
            } else if (dx == pdx && dy == pdy) {
                out.set(out.size() - 1, curr);
            } else {
                pdx = dx;
                pdy = dy;
                out.add(curr);
            }
            prev = curr;
        }
        return out;
    }

    private static FaceRegion getRegion(SlabPlacement.Mode mode, class_2350 face, class_2350 playerFacing, class_2338 pos, class_243 hit) {
        class_2350 targeted = SlabPlacement.getTargetedDirection(mode, face, playerFacing, pos, hit);
        if (targeted == face.method_10153()) {
            return FaceRegion.CENTER;
        }
        if (targeted == class_2350.field_11036) {
            return FaceRegion.TOP;
        }
        if (targeted == class_2350.field_11033) {
            return FaceRegion.BOTTOM;
        }
        return switch (face) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11043, class_2350.field_11035 -> {
                switch (targeted) {
                    case field_11034: {
                        yield FaceRegion.RIGHT;
                    }
                    case field_11039: {
                        yield FaceRegion.LEFT;
                    }
                }
                yield FaceRegion.CENTER;
            }
            case class_2350.field_11039, class_2350.field_11034 -> {
                switch (targeted) {
                    case field_11043: {
                        yield FaceRegion.LEFT;
                    }
                    case field_11035: {
                        yield FaceRegion.RIGHT;
                    }
                }
                yield FaceRegion.CENTER;
            }
            case class_2350.field_11033, class_2350.field_11036 -> {
                switch (targeted) {
                    case field_11034: {
                        yield FaceRegion.RIGHT;
                    }
                    case field_11039: {
                        yield FaceRegion.LEFT;
                    }
                    case field_11043: {
                        yield FaceRegion.BOTTOM;
                    }
                    case field_11035: {
                        yield FaceRegion.TOP;
                    }
                }
                yield FaceRegion.CENTER;
            }
        };
    }

    private static void addEdgeQuantized(Map<EdgeKey, UVSeg> map, class_241 a, class_241 b) {
        int ax = EdgeKey.quantize(a.field_1343);
        int ay = EdgeKey.quantize(a.field_1342);
        int bx = EdgeKey.quantize(b.field_1343);
        int by = EdgeKey.quantize(b.field_1342);
        int dx = Integer.signum(bx - ax);
        int dy = Integer.signum(by - ay);
        int steps = Math.max(Math.abs(bx - ax), Math.abs(by - ay));
        if (steps == 0) {
            return;
        }
        int x = ax;
        int y = ay;
        for (int i = 0; i < steps; ++i) {
            int nx = x + dx;
            int ny = y + dy;
            EdgeKey ek = new EdgeKey(x, y, nx, ny);
            UVSeg seg = map.get(ek);
            if (seg == null) {
                map.put(ek, new UVSeg(new class_241((float)x / 1024.0f, (float)y / 1024.0f), new class_241((float)nx / 1024.0f, (float)ny / 1024.0f)));
            } else {
                ++seg.count;
            }
            x = nx;
            y = ny;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static List<List<class_241>> buildChains(Map<EdgeKey, UVSeg> edgeMap) {
        List<UVSeg> unitEdges = edgeMap.values().stream().filter(e -> e.count == 1).toList();
        HashMap<QuantizedUV, List<QuantizedUV>> adjacent = new HashMap<QuantizedUV, List<QuantizedUV>>();
        for (UVSeg uVSeg : unitEdges) {
            QuantizedUV quantizedUV = QuantizedUV.fromVec2f(uVSeg.a);
            QuantizedUV b = QuantizedUV.fromVec2f(uVSeg.b);
            adjacent.computeIfAbsent(quantizedUV, k -> new ArrayList()).add(b);
            adjacent.computeIfAbsent(b, k -> new ArrayList()).add(quantizedUV);
        }
        HashSet<Long> unused = new HashSet<Long>();
        for (UVSeg uVSeg : unitEdges) {
            unused.add(BlockFaceOverlay.edgeKey(QuantizedUV.fromVec2f(uVSeg.a), QuantizedUV.fromVec2f(uVSeg.b)));
        }
        ArrayList<List<class_241>> arrayList = new ArrayList<List<class_241>>();
        for (Object start : adjacent.keySet()) {
            List<QuantizedUV> chainQ;
            if (((List)adjacent.get(start)).size() == 2 || (chainQ = BlockFaceOverlay.walkChainFrom((QuantizedUV)start, adjacent, unused)).size() < 2) continue;
            arrayList.add(BlockFaceOverlay.toVec2f(chainQ));
        }
        while (!unused.isEmpty()) {
            void var5_14;
            Object var5_12 = null;
            block4: for (QuantizedUV n : adjacent.keySet()) {
                for (QuantizedUV m : adjacent.getOrDefault(n, List.of())) {
                    if (!unused.contains(BlockFaceOverlay.edgeKey(n, m))) continue;
                    QuantizedUV quantizedUV = n;
                    break block4;
                }
            }
            if (var5_14 == null) break;
            List<QuantizedUV> loopQ = BlockFaceOverlay.walkChainFrom((QuantizedUV)var5_14, adjacent, unused);
            if (loopQ.size() < 3) continue;
            loopQ.add(loopQ.getFirst());
            arrayList.add(BlockFaceOverlay.toVec2f(loopQ));
        }
        return arrayList;
    }

    private static List<QuantizedUV> walkChainFrom(QuantizedUV start, Map<QuantizedUV, List<QuantizedUV>> adjacent, Set<Long> unused) {
        ArrayList<QuantizedUV> chain = new ArrayList<QuantizedUV>(64);
        QuantizedUV prev = null;
        QuantizedUV curr = start;
        chain.add(curr);
        while (true) {
            QuantizedUV next = null;
            for (QuantizedUV cand : adjacent.getOrDefault(curr, List.of())) {
                long ek;
                if (cand.equals(prev) || !unused.remove(ek = BlockFaceOverlay.edgeKey(curr, cand))) continue;
                next = cand;
                break;
            }
            if (next == null) break;
            chain.add(next);
            prev = curr;
            curr = next;
        }
        return chain;
    }

    private static List<class_241> toVec2f(List<QuantizedUV> nodes) {
        ArrayList<class_241> out = new ArrayList<class_241>(nodes.size());
        for (QuantizedUV q : nodes) {
            out.add(new class_241((float)q.x / 1024.0f, (float)q.y / 1024.0f));
        }
        return out;
    }

    private static long edgeKey(QuantizedUV a, QuantizedUV b) {
        if (a.x > b.x || a.x == b.x && a.y > b.y) {
            QuantizedUV t = a;
            a = b;
            b = t;
        }
        return (long)a.x << 48 ^ (long)a.y << 32 ^ (long)b.x << 16 ^ (long)b.y;
    }

    public record FaceFrame(class_2350 face, class_243 u, class_243 v, class_243 n) {
        public static FaceFrame create(class_2350 face) {
            return switch (face) {
                default -> throw new MatchException(null, null);
                case class_2350.field_11043 -> new FaceFrame(face, new class_243(1.0, 0.0, 0.0), new class_243(0.0, 1.0, 0.0), new class_243(0.0, 0.0, -1.0));
                case class_2350.field_11035 -> new FaceFrame(face, new class_243(1.0, 0.0, 0.0), new class_243(0.0, 1.0, 0.0), new class_243(0.0, 0.0, 1.0));
                case class_2350.field_11039 -> new FaceFrame(face, new class_243(0.0, 0.0, 1.0), new class_243(0.0, 1.0, 0.0), new class_243(-1.0, 0.0, 0.0));
                case class_2350.field_11034 -> new FaceFrame(face, new class_243(0.0, 0.0, 1.0), new class_243(0.0, 1.0, 0.0), new class_243(1.0, 0.0, 0.0));
                case class_2350.field_11033 -> new FaceFrame(face, new class_243(1.0, 0.0, 0.0), new class_243(0.0, 0.0, 1.0), new class_243(0.0, -1.0, 0.0));
                case class_2350.field_11036 -> new FaceFrame(face, new class_243(1.0, 0.0, 0.0), new class_243(0.0, 0.0, 1.0), new class_243(0.0, 1.0, 0.0));
            };
        }
    }

    private static enum FaceRegion {
        CENTER,
        LEFT,
        RIGHT,
        BOTTOM,
        TOP;

    }

    private record RectUV(double u0, double v0, double u1, double v1) {
        private RectUV(double u0, double v0, double u1, double v1) {
            if (u0 <= u1) {
                this.u0 = u0;
                this.u1 = u1;
            } else {
                this.u0 = u1;
                this.u1 = u0;
            }
            if (v0 <= v1) {
                this.v0 = v0;
                this.v1 = v1;
            } else {
                this.v0 = v1;
                this.v1 = v0;
            }
        }

        boolean isDegenerate() {
            return this.u1 - this.u0 <= 1.0E-6 || this.v1 - this.v0 <= 1.0E-6;
        }
    }

    private static final class EdgeKey {
        public static final int EDGE_Q = 1024;
        final int ax;
        final int ay;
        final int bx;
        final int by;

        public EdgeKey(float ax, float ay, float bx, float by) {
            int qax = EdgeKey.quantize(ax);
            int qay = EdgeKey.quantize(ay);
            int qbx = EdgeKey.quantize(bx);
            int qby = EdgeKey.quantize(by);
            if (qax < qbx || qax == qbx && qay <= qby) {
                this.ax = qax;
                this.ay = qay;
                this.bx = qbx;
                this.by = qby;
            } else {
                this.ax = qbx;
                this.ay = qby;
                this.bx = qax;
                this.by = qay;
            }
        }

        public static int quantize(float v) {
            return Math.round(v * 1024.0f);
        }

        public boolean equals(Object o) {
            if (!(o instanceof EdgeKey)) {
                return false;
            }
            EdgeKey e = (EdgeKey)o;
            return this.ax == e.ax && this.ay == e.ay && this.bx == e.bx && this.by == e.by;
        }

        public int hashCode() {
            int h = this.ax;
            h = 31 * h + this.ay;
            h = 31 * h + this.bx;
            h = 31 * h + this.by;
            return h;
        }
    }

    private static final class UVSeg {
        final class_241 a;
        final class_241 b;
        int count = 1;

        UVSeg(class_241 a, class_241 b) {
            this.a = a;
            this.b = b;
        }
    }

    private record QuantizedUV(int x, int y) {
        public static QuantizedUV fromVec2f(class_241 v) {
            return new QuantizedUV(EdgeKey.quantize(v.field_1343), EdgeKey.quantize(v.field_1342));
        }
    }
}

