/*
 * Decompiled with CFR 0.152.
 */
package dev.micalobia.fullslabs.config;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.networking.NetworkManager;
import dev.micalobia.fullslabs.config.fabric.ControlsImpl;
import dev.micalobia.fullslabs.util.SlabPlacement;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_8710;

public final class Controls {
    private static final Map<UUID, SlabPlacement.Mode> modeMap = new HashMap<UUID, SlabPlacement.Mode>();
    private static boolean overlayActive = true;
    public static class_304.class_11900 MAIN;
    public static class_304 cycleMode;
    public static class_304 toggleOverlay;

    public static SlabPlacement.Mode getPlacementMode(UUID player) {
        return modeMap.computeIfAbsent(player, uuid -> SlabPlacement.Mode.HYBRID);
    }

    private static void cyclePlacementMode(UUID player) {
        modeMap.put(player, Controls.getPlacementMode(player).next());
    }

    private static void setPlacementMode(UUID player, SlabPlacement.Mode mode) {
        modeMap.put(player, mode);
    }

    private static void receivePlacementMode(SlabPlacement.Mode mode, NetworkManager.PacketContext context) {
        Controls.setPlacementMode(context.getPlayer().method_5667(), mode);
    }

    public static boolean isOverlayActive() {
        return overlayActive;
    }

    public static void toggleOverlayActive() {
        overlayActive = !overlayActive;
    }

    public static void serverInit() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, SlabPlacement.Mode.PACKET_TYPE, SlabPlacement.Mode.PACKET_CODEC, Controls::receivePlacementMode);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void clientInit() {
        ControlsImpl.clientInit();
    }

    public static void onClientTick(class_310 client) {
        if (client.field_1724 == null) {
            return;
        }
        UUID uuid = client.field_1724.method_5667();
        boolean sendVerticalPacket = false;
        while (toggleOverlay.method_1436()) {
            Controls.toggleOverlayActive();
        }
        while (cycleMode.method_1436()) {
            Controls.cyclePlacementMode(uuid);
            sendVerticalPacket = true;
        }
        if (sendVerticalPacket) {
            NetworkManager.sendToServer((class_8710)Controls.getPlacementMode(uuid));
        }
    }
}

