/*
 * Decompiled with CFR 0.152.
 */
package dev.micalobia.fullslabs.handlers;

import dev.micalobia.fullslabs.SlabRegistry;
import dev.micalobia.fullslabs.block.MixedSlabBlock;
import dev.micalobia.fullslabs.block.entity.MixedSlabBlockEntity;
import dev.micalobia.fullslabs.handlers.MixedHandler;
import dev.micalobia.fullslabs.handlers.MixedHandlers;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2482;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public sealed interface MixedContext {
    public static final Supplier<RuntimeException> MISSING_BE = () -> new RuntimeException("Missing mixed slab block entity!");

    public class_2680 mixedState();

    public Optional<MixedSlabBlockEntity> blockEntity();

    public boolean replaceBlock(class_2248 var1);

    public Sided sided(boolean var1);

    default public MixedContext requireBlockEntity() {
        if (this.blockEntity().isEmpty()) {
            throw MISSING_BE.get();
        }
        return this;
    }

    default public MixedSlabBlockEntity blockEntityOrThrow() {
        return this.blockEntity().orElseThrow(MISSING_BE);
    }

    public static Sided create(class_1922 world, class_2338 pos, boolean towards) {
        return MixedContext.create(world, pos).sided(towards);
    }

    public static Sideless create(class_1922 world, class_2338 pos) {
        Optional<MixedSlabBlockEntity> optionalEntity;
        MixedSlabBlock block = (MixedSlabBlock)SlabRegistry.MIXED_SLAB.get();
        class_2680 state = world.method_8320(pos);
        if (!state.method_27852((class_2248)block)) {
            throw new IllegalArgumentException("This block isn't a mixed slab!");
        }
        class_2586 entity = world.method_8321(pos);
        if (!(entity instanceof MixedSlabBlockEntity)) {
            optionalEntity = Optional.empty();
        } else {
            MixedSlabBlockEntity mixed = (MixedSlabBlockEntity)entity;
            optionalEntity = Optional.of(mixed);
        }
        return new Sideless(state, optionalEntity);
    }

    public record Sideless(class_2680 mixedState, Optional<MixedSlabBlockEntity> blockEntity) implements MixedContext
    {
        @Override
        public boolean replaceBlock(class_2248 block) {
            return false;
        }

        @Override
        public Sided sided(boolean towards) {
            MixedSlabBlock.MixedType type = (MixedSlabBlock.MixedType)((Object)this.mixedState.method_11654(MixedSlabBlock.TYPE));
            class_2482 slab = this.blockEntity.map(entity -> entity.getBlock(towards)).orElse((class_2482)class_2246.field_10454);
            return new Sided(this.mixedState, this.blockEntity, towards, type.state(slab, towards));
        }
    }

    public record Sided(class_2680 mixedState, Optional<MixedSlabBlockEntity> blockEntity, boolean towards, class_2680 state) implements MixedContext
    {
        @Override
        public boolean replaceBlock(class_2248 block) {
            return this.blockEntity.map(entity -> entity.setBlock(block, this.towards)).orElse(false);
        }

        @Override
        public Sided sided(boolean towards) {
            if (this.towards == towards) {
                return this;
            }
            return new Sideless(this.mixedState, this.blockEntity).sided(towards);
        }

        public class_2248 block() {
            return this.state.method_26204();
        }

        public MixedHandler handler() {
            return MixedHandlers.getOrThrow(this.state.method_26204());
        }
    }
}

