/*
 * Decompiled with CFR 0.152.
 */
package dev.micalobia.fullslabs;

import dev.architectury.platform.Platform;
import dev.micalobia.fullslabs.FullSlabs;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public final class FullSlabsMixinPlugin
implements IMixinConfigPlugin {
    public static final Pattern COMPAT_REGEX = Pattern.compile(".*compat\\.(?<modid>\\w+)\\..*");
    public static final Pattern NAME_REGEX = Pattern.compile("^.*[.$](?<name>\\w+)$");

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        Matcher match;
        Matcher targetMatcher = NAME_REGEX.matcher(targetClassName);
        Matcher mixinMatcher = NAME_REGEX.matcher(mixinClassName);
        if (targetMatcher.matches() && mixinMatcher.matches()) {
            String targetMixin;
            String targetName = targetMatcher.group("name");
            String mixinName = mixinMatcher.group("name");
            if (!mixinName.equals(targetMixin = "%sMixin".formatted(targetName)) && !mixinName.equals("%sAccessor".formatted(targetName))) {
                FullSlabs.LOGGER.warn("Incorrect name: {} should be {}", (Object)mixinName, (Object)targetMixin);
            }
        }
        if ((match = COMPAT_REGEX.matcher(mixinClassName)).matches()) {
            return Platform.isModLoaded((String)match.group("modid"));
        }
        return true;
    }

    public void onLoad(String s) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> set, Set<String> set1) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String s, ClassNode classNode, String s1, IMixinInfo iMixinInfo) {
    }

    public void postApply(String s, ClassNode classNode, String s1, IMixinInfo iMixinInfo) {
    }
}

