/*
 * Decompiled with CFR 0.152.
 */
package dev.micalobia.fullslabs.block;

import com.google.common.collect.ImmutableList;
import dev.micalobia.fullslabs.SlabRegistry;
import dev.micalobia.fullslabs.block.VerticalSlabBlock;
import dev.micalobia.fullslabs.block.entity.MixedSlabBlockEntity;
import dev.micalobia.fullslabs.ducks.MixedSlabBlockDuck;
import dev.micalobia.fullslabs.handlers.MixedConsumer;
import dev.micalobia.fullslabs.handlers.MixedContext;
import dev.micalobia.fullslabs.handlers.MixedFunction;
import dev.micalobia.fullslabs.util.Utility;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6328;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@class_6328
public final class MixedSlabBlock
extends class_2248
implements class_2343,
MixedSlabBlockDuck {
    public static final class_2754<MixedType> TYPE = class_2754.method_11850((String)"type", MixedType.class);
    @ApiStatus.Internal
    @Nullable
    public static class_1657 cachedPlayer = null;

    public MixedSlabBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{TYPE});
    }

    protected boolean method_9542(class_2680 state) {
        return true;
    }

    protected void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        this.forwardSides((class_1922)world, pos, ctx -> ctx.handler().randomTick((MixedContext.Sided)ctx, world, pos, random));
    }

    protected boolean method_9506(class_2680 state) {
        return true;
    }

    public boolean isSignalSource(class_1922 world, class_2338 pos) {
        return this.forwardSidesValue(world, pos, ctx -> ctx.handler().isSignalSource((MixedContext.Sided)ctx), Boolean::logicalOr);
    }

    protected int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return this.forwardSidesValue(world, pos, ctx -> ctx.handler().getSignal((MixedContext.Sided)ctx, world, pos, direction), Math::max);
    }

    protected int method_9603(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return this.forwardSidesValue(world, pos, ctx -> ctx.handler().getDirectSignal((MixedContext.Sided)ctx, world, pos, direction), Math::max);
    }

    protected void method_19286(class_1937 world, class_2680 state, class_3965 hit, class_1676 projectile) {
        this.forwardSide((class_1922)world, hit.method_17777(), hit.method_17784(), (MixedContext.Sided ctx) -> ctx.handler().onProjectileHit((MixedContext.Sided)ctx, world, hit, projectile));
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        this.forwardSide((class_1922)world, pos, entity.method_73189(), (MixedContext.Sided ctx) -> ctx.handler().stepOn((MixedContext.Sided)ctx, world, pos, entity));
    }

    public void method_9554(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, double fallDistance) {
        this.forwardSide((class_1922)world, pos, entity.method_73189(), (MixedContext.Sided ctx) -> ctx.handler().fallOn((MixedContext.Sided)ctx, world, pos, entity, fallDistance));
    }

    public void method_9502(class_1922 world, class_1297 entity) {
        this.forwardSide(world, entity.method_43260(), entity.method_73189(), (MixedContext.Sided ctx) -> ctx.handler().updateEntityMovementAfterFallOn((MixedContext.Sided)ctx, world, entity));
    }

    public void method_9504(class_2680 state, class_1937 world, class_2338 pos, class_1959.class_1963 precipitation) {
        this.forwardSides((class_1922)world, pos, ctx -> ctx.handler().handlePrecipitation((MixedContext.Sided)ctx, world, pos, precipitation));
    }

    protected void method_9606(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        this.forwardSides((class_1922)world, pos, ctx -> ctx.handler().attack((MixedContext.Sided)ctx, world, pos, player));
    }

    public void method_9556(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, class_1799 tool) {
        this.forwardSides((class_1922)world, pos, ctx -> ctx.handler().playerDestroy((MixedContext.Sided)ctx, world, player, pos, blockEntity, tool));
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        this.forwardSides((class_1922)world, pos, ctx -> ctx.handler().tick((MixedContext.Sided)ctx, world, pos, random));
    }

    protected void method_9565(class_2680 state, class_3218 world, class_2338 pos, class_1799 tool, boolean dropExperience) {
        this.forwardSides((class_1922)world, pos, ctx -> ctx.handler().spawnAfterBreak((MixedContext.Sided)ctx, world, pos, tool, dropExperience));
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        return this.forwardSideValue((class_1922)world, pos, hit.method_17784(), (MixedContext.Sided ctx) -> ctx.handler().useWithoutItem((MixedContext.Sided)ctx, world, pos, player, hit));
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        return this.forwardSideValue((class_1922)world, pos, hit.method_17784(), (MixedContext.Sided ctx) -> ctx.handler().useItemOn((MixedContext.Sided)ctx, stack, world, pos, player, hand, hit));
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new MixedSlabBlockEntity(pos, state);
    }

    protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        class_239 crosshair = Utility.crosshair(cachedPlayer, world.method_8608());
        return this.forwardSideValue((class_1922)world, pos, crosshair.method_17784(), (MixedContext.Sided ctx) -> new class_1799((class_1935)ctx.block()));
    }

    protected float method_9594(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        class_239 hit = Utility.crosshair(player, ((class_1937)world).method_8608());
        return this.forwardSideValue(world, pos, hit.method_17784(), (MixedContext.Sided ctx) -> Float.valueOf(ctx.state().method_26165(player, world, pos))).floatValue();
    }

    protected boolean method_9592(class_2680 state, class_1937 world, class_2338 pos, int type, int data) {
        if (type != 0) {
            return false;
        }
        world.method_8413(pos, state, state, 27);
        return true;
    }

    @Override
    public <T> T forward(class_1922 world, class_2338 pos, MixedFunction<T, MixedContext.Sideless> function) {
        return function.apply(MixedContext.create(world, pos));
    }

    @Override
    public <T> T forwardSideValue(class_1922 world, class_2338 pos, boolean towards, MixedFunction<T, MixedContext.Sided> function) {
        return (T)this.forward(world, pos, ctx -> function.apply(ctx.sided(towards)));
    }

    @Override
    public <T> T forwardSideValue(class_1922 world, class_2338 pos, class_243 hit, MixedFunction<T, MixedContext.Sided> function) {
        return (T)this.forward(world, pos, ctx -> {
            MixedType type = (MixedType)((Object)((Object)ctx.mixedState().method_11654(TYPE)));
            boolean towards = type.isAxisTargetTowards(hit, pos);
            return function.apply(ctx.sided(towards));
        });
    }

    @Override
    public void forwardSide(class_1922 world, class_2338 pos, boolean towards, MixedConsumer<MixedContext.Sided> consumer) {
        this.forwardSideValue(world, pos, towards, (MixedContext.Sided ctx) -> {
            consumer.apply((MixedContext.Sided)ctx);
            return null;
        });
    }

    @Override
    public void forwardSide(class_1922 world, class_2338 pos, class_243 hit, MixedConsumer<MixedContext.Sided> consumer) {
        this.forwardSideValue(world, pos, hit, (MixedContext.Sided ctx) -> {
            consumer.apply((MixedContext.Sided)ctx);
            return null;
        });
    }

    @Override
    public <T, R> R forwardSidesValue(class_1922 world, class_2338 pos, MixedFunction<T, MixedContext.Sided> function, BiFunction<T, T, R> selector) {
        return (R)this.forward(world, pos, ctx -> {
            Object towardsValue = function.apply(ctx.sided(true));
            Object awayValue = function.apply(ctx.sided(false));
            return selector.apply(towardsValue, awayValue);
        });
    }

    @Override
    public void forwardSides(class_1922 world, class_2338 pos, MixedConsumer<MixedContext.Sided> consumer) {
        this.forwardSidesValue(world, pos, ctx -> {
            consumer.apply((MixedContext.Sided)ctx);
            return null;
        }, (a, b) -> null);
    }

    public boolean towards(class_2680 state, class_3965 hit) {
        return this.towards(state, hit.method_17784(), hit.method_17777());
    }

    public boolean towards(class_2680 state, class_243 hit, class_2338 pos) {
        return ((MixedType)((Object)state.method_11654(TYPE))).isAxisTargetTowards(hit, pos);
    }

    public static enum MixedType implements class_3542
    {
        NORTH("north", class_2350.field_11043),
        SOUTH("south", class_2350.field_11035),
        EAST("east", class_2350.field_11034),
        WEST("west", class_2350.field_11039),
        VERTICAL("vertical", class_2350.field_11036);

        private static final List<MixedType> CARDINAL;
        public final class_2350 direction;
        private final String name;

        private MixedType(String name, class_2350 direction) {
            this.name = name;
            this.direction = direction;
        }

        public static List<MixedType> cardinal() {
            return CARDINAL;
        }

        public static MixedType fromState(class_2680 state) {
            class_2248 block = state.method_26204();
            if (block instanceof class_2482) {
                return VERTICAL;
            }
            if (block instanceof VerticalSlabBlock) {
                return switch ((class_2350)state.method_11654((class_2769)class_2741.field_12481)) {
                    default -> throw new MatchException(null, null);
                    case class_2350.field_11036, class_2350.field_11033 -> throw new AssertionError();
                    case class_2350.field_11043 -> NORTH;
                    case class_2350.field_11035 -> SOUTH;
                    case class_2350.field_11039 -> WEST;
                    case class_2350.field_11034 -> EAST;
                };
            }
            if (block == SlabRegistry.MIXED_SLAB.get()) {
                return (MixedType)((Object)state.method_11654(TYPE));
            }
            throw new IllegalArgumentException("Not a slab!");
        }

        public String method_15434() {
            return this.name;
        }

        public class_2680 state(class_2482 slab, boolean towards) {
            if (!VerticalSlabBlock.hasVertical(slab)) {
                throw new IllegalArgumentException("%s is missing a vertical".formatted(slab));
            }
            if (this == VERTICAL) {
                return (class_2680)slab.method_9564().method_11657((class_2769)class_2741.field_12485, (Comparable)(towards ? class_2771.field_12679 : class_2771.field_12681));
            }
            return (class_2680)((class_2680)VerticalSlabBlock.getVertical(slab).method_9564().method_11657(VerticalSlabBlock.TYPE, (Comparable)((Object)(towards ? VerticalSlabBlock.VerticalType.TOWARDS : VerticalSlabBlock.VerticalType.AWAY)))).method_11657((class_2769)class_2741.field_12481, (Comparable)this.direction);
        }

        public boolean isAxisTargetTowards(class_243 pos, class_2338 location) {
            return (switch (this.direction.method_10166()) {
                default -> throw new MatchException(null, null);
                case class_2350.class_2351.field_11048 -> {
                    if (pos.field_1352 - (double)location.method_10263() > 0.5) {
                        yield class_2350.field_11034;
                    }
                    yield class_2350.field_11039;
                }
                case class_2350.class_2351.field_11052 -> {
                    if (pos.field_1351 - (double)location.method_10264() > 0.5) {
                        yield class_2350.field_11036;
                    }
                    yield class_2350.field_11033;
                }
                case class_2350.class_2351.field_11051 -> pos.field_1350 - (double)location.method_10260() > 0.5 ? class_2350.field_11035 : class_2350.field_11043;
            }) == this.direction;
        }

        static {
            CARDINAL = ImmutableList.of((Object)((Object)NORTH), (Object)((Object)SOUTH), (Object)((Object)EAST), (Object)((Object)WEST));
        }
    }
}

