/*
 * Decompiled with CFR 0.152.
 */
package dev.micalobia.fullslabs.client.models;

import com.google.common.collect.ImmutableList;
import dev.micalobia.fullslabs.FullSlabs;
import dev.micalobia.fullslabs.block.VerticalSlabBlock;
import dev.micalobia.fullslabs.config.Config;
import dev.micalobia.fullslabs.mixin.client.ModelBakerImplAccessor;
import dev.micalobia.fullslabs.mixin.client.ModelBakeryAccessor;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10419;
import net.minecraft.class_10526;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_10801;
import net.minecraft.class_10813;
import net.minecraft.class_10817;
import net.minecraft.class_10819;
import net.minecraft.class_10820;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_10889;
import net.minecraft.class_10893;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_6328;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

@class_6328
public class VerticalSlabModel
implements class_1087.class_9979 {
    private static final class_2960 ATLAS = class_1059.field_5275;
    public static final VerticalSlabModel INSTANCE = new VerticalSlabModel();
    public static final List<class_2960> TEMPLATES = VerticalSlabModel.templates();

    private VerticalSlabModel() {
    }

    private static VerticalSlabBlock verifyVertical(class_2248 block) {
        if (!(block instanceof VerticalSlabBlock)) {
            throw new IllegalArgumentException();
        }
        VerticalSlabBlock slab = (VerticalSlabBlock)block;
        return slab;
    }

    public static class_2960 templateId(class_2680 state) {
        VerticalSlabBlock slab = VerticalSlabModel.verifyVertical(state.method_26204());
        class_2350 facing = (class_2350)state.method_11654(VerticalSlabBlock.DIRECTION);
        VerticalSlabBlock.VerticalType type = (VerticalSlabBlock.VerticalType)((Object)state.method_11654(VerticalSlabBlock.TYPE));
        boolean tilted = Config.isTilted((class_2248)slab.parent);
        if (tilted) {
            return FullSlabs.id("block/vertical/tilted/%s_%s".formatted(facing.method_15434(), type.method_15434()));
        }
        if (type == VerticalSlabBlock.VerticalType.FULL) {
            return FullSlabs.id("block/vertical/normal/full");
        }
        return FullSlabs.id("block/vertical/normal/%s".formatted((type == VerticalSlabBlock.VerticalType.AWAY ? facing.method_10153() : facing).method_15434()));
    }

    public static class_2680 parentState(class_2680 state) {
        VerticalSlabBlock slab = VerticalSlabModel.verifyVertical(state.method_26204());
        VerticalSlabBlock.VerticalType type = (VerticalSlabBlock.VerticalType)((Object)state.method_11654(VerticalSlabBlock.TYPE));
        class_2680 parentState = slab.parent.method_9564();
        return switch (type) {
            default -> throw new MatchException(null, null);
            case VerticalSlabBlock.VerticalType.AWAY -> (class_2680)parentState.method_11657((class_2769)class_2741.field_12485, (Comparable)class_2771.field_12681);
            case VerticalSlabBlock.VerticalType.TOWARDS -> (class_2680)parentState.method_11657((class_2769)class_2741.field_12485, (Comparable)class_2771.field_12679);
            case VerticalSlabBlock.VerticalType.FULL -> (class_2680)parentState.method_11657((class_2769)class_2741.field_12485, (Comparable)class_2771.field_12682);
        };
    }

    public static class_2960 makeModelId(class_2680 state) {
        VerticalSlabBlock slab = VerticalSlabModel.verifyVertical(state.method_26204());
        return FullSlabs.id("block/%s/%s_%s".formatted(class_7923.field_41175.method_10221((Object)slab).method_12832(), ((class_2350)state.method_11654(VerticalSlabBlock.DIRECTION)).method_15434(), ((VerticalSlabBlock.VerticalType)((Object)state.method_11654(VerticalSlabBlock.TYPE))).method_15434()));
    }

    public class_1087 method_65542(class_2680 state, class_7775 baker) {
        VerticalSlabBlock slab = VerticalSlabModel.verifyVertical(state.method_26204());
        class_2960 parentId = class_7923.field_41175.method_10221((Object)slab.parent);
        class_2960 templateId = VerticalSlabModel.templateId(state);
        class_2680 parentState = VerticalSlabModel.parentState(state);
        class_1088 outer = ((ModelBakerImplAccessor)baker).fullslabs$getOuter();
        class_1087.class_9979 grouped = ((ModelBakeryAccessor)outer).fullslabs$getUnbakedBlockStateModels().get(parentState);
        if (grouped == null) {
            throw new IllegalStateException("Parent slab state wasn't discovered: " + String.valueOf(parentState));
        }
        class_1087 parent = grouped.method_65542(parentState, baker);
        class_1058 particle = parent.method_68511();
        List parts = parent.method_68512(class_5819.method_43049((long)0L));
        List<HasQuads> list = parts.stream().map(x -> arg_0 -> ((class_10889)x).method_68509(arg_0)).toList();
        Boolean useAO = parts.stream().findFirst().map(class_10889::comp_3751).orElse(true);
        Textures textures = Textures.fetch(particle, list);
        class_10419 mapped = VerticalSlabModel.mapped(parentId.toString(), textures);
        class_10819 template = baker.method_45872(templateId);
        class_10820 geometry = template.method_68044();
        class_10817 quads = geometry.bake(mapped, baker, (class_3665)class_1086.field_5350, (class_10813)template);
        class_10801 part = new class_10801(quads, useAO.booleanValue(), particle);
        return new class_10893((class_10889)part);
    }

    public Object method_62332(class_2680 state) {
        class_2960 id = class_7923.field_41175.method_10221((Object)state.method_26204());
        String facing = ((class_2350)state.method_11654(VerticalSlabBlock.DIRECTION)).method_15434();
        String type = ((VerticalSlabBlock.VerticalType)((Object)state.method_11654(VerticalSlabBlock.TYPE))).method_15434();
        return String.valueOf(id) + "|" + facing + "|" + type;
    }

    public void method_62326(class_10526.class_10103 resolver) {
        TEMPLATES.forEach(arg_0 -> ((class_10526.class_10103)resolver).markDependency(arg_0));
    }

    private static List<class_2960> templates() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        class_2350.class_2353.field_11062.forEach(direction -> {
            String str = direction.method_15434();
            builder.add((Object)FullSlabs.id("block/vertical/tilted/%s_towards".formatted(str)));
            builder.add((Object)FullSlabs.id("block/vertical/tilted/%s_away".formatted(str)));
            builder.add((Object)FullSlabs.id("block/vertical/tilted/%s_full".formatted(str)));
            builder.add((Object)FullSlabs.id("block/vertical/normal/%s".formatted(str)));
        });
        builder.add((Object)FullSlabs.id("block/vertical/normal/full"));
        return builder.build();
    }

    public static class_10419 mapped(String simple, Textures textures) {
        return VerticalSlabModel.mapped(simple, textures.particle, textures.side, textures.top, textures.bottom);
    }

    public static class_10419 mapped(String simple, class_1058 particle, class_1058 side, class_1058 top, class_1058 bottom) {
        class_10419.class_10420 table = new class_10419.class_10420.class_10421().method_65548("side", VerticalSlabModel.spriteId(side)).method_65548("top", VerticalSlabModel.spriteId(top)).method_65548("bottom", VerticalSlabModel.spriteId(bottom)).method_65548("particle", VerticalSlabModel.spriteId(particle)).method_65547();
        return new class_10419.class_10423().method_65550(table).method_65551(() -> simple);
    }

    private static class_4730 spriteId(class_1058 sprite) {
        return new class_4730(ATLAS, sprite.method_45851().method_45816());
    }

    public record Textures(class_1058 particle, class_1058 side, class_1058 top, class_1058 bottom) {
        public static Textures fetch(class_1058 particle, List<HasQuads> quads) {
            class_1058 side = class_2350.class_2353.field_11062.method_29716().map(dir -> Textures.fetchFace(dir, quads)).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(particle);
            class_1058 top = Textures.fetchFace(class_2350.field_11036, quads).orElse(side);
            class_1058 bottom = Textures.fetchFace(class_2350.field_11033, quads).orElse(side);
            return new Textures(particle, side, top, bottom);
        }

        public static Optional<class_1058> fetchFace(class_2350 direction, List<HasQuads> parts) {
            return parts.stream().map(hasQuads -> Textures.fetchFace(direction, hasQuads)).findFirst().filter(Optional::isPresent).map(Optional::get).stream().findFirst();
        }

        public static Optional<class_1058> fetchFace(class_2350 direction, HasQuads parent) {
            return parent.getQuads(direction).stream().map(class_777::comp_3724).findFirst().or(() -> parent.getQuads(null).stream().filter(q -> q.comp_3723() == direction).map(class_777::comp_3724).findFirst());
        }
    }

    @FunctionalInterface
    public static interface HasQuads {
        public List<class_777> getQuads(@Nullable class_2350 var1);
    }
}

