/*
 * Decompiled with CFR 0.152.
 */
package dev.micalobia.fullslabs.config;

import com.google.common.collect.Lists;
import eu.midnightdust.lib.config.MidnightConfig;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class Config
extends MidnightConfig {
    public static final String GENERAL = "general";
    public static final String OVERLAY = "overlay";
    @MidnightConfig.Entry(category="general", idMode=1, width=1000)
    public static List<class_2960> tiltedSlabs = Lists.newArrayList((Object[])new class_2960[]{class_2960.method_60656((String)"smooth_stone_slab"), class_2960.method_60655((String)"mo_glass", (String)"glass_slab"), class_2960.method_60655((String)"mo_glass", (String)"white_stained_glass_slab"), class_2960.method_60655((String)"mo_glass", (String)"orange_stained_glass_slab"), class_2960.method_60655((String)"mo_glass", (String)"magenta_stained_glass_slab"), class_2960.method_60655((String)"mo_glass", (String)"light_blue_stained_glass_slab"), class_2960.method_60655((String)"mo_glass", (String)"yellow_stained_glass_slab"), class_2960.method_60655((String)"mo_glass", (String)"lime_stained_glass_slab"), class_2960.method_60655((String)"mo_glass", (String)"pink_stained_glass_slab"), class_2960.method_60655((String)"mo_glass", (String)"gray_stained_glass_slab"), class_2960.method_60655((String)"mo_glass", (String)"light_gray_stained_glass_slab"), class_2960.method_60655((String)"mo_glass", (String)"cyan_stained_glass_slab"), class_2960.method_60655((String)"mo_glass", (String)"purple_stained_glass_slab"), class_2960.method_60655((String)"mo_glass", (String)"blue_stained_glass_slab"), class_2960.method_60655((String)"mo_glass", (String)"brown_stained_glass_slab"), class_2960.method_60655((String)"mo_glass", (String)"green_stained_glass_slab"), class_2960.method_60655((String)"mo_glass", (String)"red_stained_glass_slab"), class_2960.method_60655((String)"mo_glass", (String)"black_stained_glass_slab"), class_2960.method_60655((String)"mo_glass", (String)"tinted_glass_slab")});
    @MidnightConfig.Entry(category="overlay", min=0.0, max=255.0, isSlider=true)
    public static int edgeOpacity = 255;
    @MidnightConfig.Entry(category="overlay", isColor=true)
    public static String edgeColor = "#FFFFFF";
    @MidnightConfig.Entry(category="overlay", min=0.0, max=255.0, isSlider=true)
    public static int fillOpacity = 63;
    @MidnightConfig.Entry(category="overlay", isColor=true)
    public static String fillColor = "#007FFF";
    private static int cachedEdgeColor = -1;
    private static int cachedFillColor = 1056997375;

    public static boolean isTilted(class_2248 block) {
        class_2960 id = class_7923.field_41175.method_10221((Object)block);
        return tiltedSlabs.contains(id);
    }

    public static int edgeColor() {
        return cachedEdgeColor;
    }

    public static int fillColor() {
        return cachedFillColor;
    }

    public void writeChanges() {
        super.writeChanges();
        cachedEdgeColor = this.parseColor(edgeOpacity, edgeColor);
        cachedFillColor = this.parseColor(fillOpacity, fillColor);
    }

    public void loadValuesFromJson() {
        super.loadValuesFromJson();
        cachedEdgeColor = this.parseColor(edgeOpacity, edgeColor);
        cachedFillColor = this.parseColor(fillOpacity, fillColor);
    }

    private int parseColor(int opacity, String color) {
        Object hex = color.replaceAll("[^0-9A-Fa-f]", "");
        if (((String)hex).length() > 6) {
            hex = ((String)hex).substring(0, 6);
        } else if (((String)hex).length() == 3) {
            hex = String.valueOf(((String)hex).charAt(0)) + ((String)hex).charAt(0) + ((String)hex).charAt(1) + ((String)hex).charAt(1) + ((String)hex).charAt(2) + ((String)hex).charAt(2);
        } else if (((String)hex).length() < 6) {
            return -1;
        }
        int r = Integer.parseInt(((String)hex).substring(0, 2), 16);
        int g = Integer.parseInt(((String)hex).substring(2, 4), 16);
        int b = Integer.parseInt(((String)hex).substring(4, 6), 16);
        return opacity << 24 | r << 16 | g << 8 | b;
    }
}

