/*
 * Decompiled with CFR 0.152.
 */
package dev.micalobia.fullslabs.handlers;

import dev.micalobia.fullslabs.block.VerticalSlabBlock;
import dev.micalobia.fullslabs.handlers.MixedHandler;
import dev.micalobia.fullslabs.util.Utility;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2482;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public final class MixedHandlers {
    private static final HashMap<class_2960, MixedHandlerFactory> ID_HANDLERS = new HashMap();
    private static final HashMap<class_2482, MixedHandlerFactory> BLOCK_HANDLERS = new HashMap();
    private static final HashMap<Class<? extends class_2482>, MixedHandlerFactory> CLASS_HANDLERS = new HashMap();
    private static final HashMap<class_2482, MixedHandler> HANDLERS = new HashMap();

    public static boolean hasHandler(class_2248 block) {
        if (!Utility.isSlab(block)) {
            return false;
        }
        Optional<class_2482> slab = VerticalSlabBlock.tryGetRoot(block);
        return slab.filter(slabBlock -> HANDLERS.containsKey(slabBlock) || BLOCK_HANDLERS.containsKey(slabBlock) || CLASS_HANDLERS.containsKey(slabBlock.getClass()) || ID_HANDLERS.containsKey(class_7923.field_41175.method_10221(slabBlock))).isPresent();
    }

    @Nullable
    public static MixedHandler get(class_2248 block) {
        if (!Utility.isSlab(block)) {
            return null;
        }
        class_2482 slab = VerticalSlabBlock.getRoot(block);
        MixedHandler handler = HANDLERS.get(slab);
        if (handler == null) {
            MixedHandlers.resolve(block);
            handler = BLOCK_HANDLERS.getOrDefault(slab, CLASS_HANDLERS.get(slab.getClass())).create(slab);
            if (handler != null) {
                HANDLERS.put(slab, handler);
            }
        }
        return handler;
    }

    public static MixedHandler getOrThrow(class_2248 block) {
        MixedHandler handler = MixedHandlers.get(block);
        if (handler == null) {
            throw new IllegalArgumentException("Missing handler for %s (%s)!".formatted(block, block.getClass().getSimpleName()));
        }
        return handler;
    }

    public static void register(class_2960 identifier, MixedHandler handler) {
        MixedHandlers.register(identifier, (class_2482 slab) -> handler);
    }

    public static void register(class_2960 identifier, MixedHandlerFactory factory) {
        class_7923.field_41175.method_17966(identifier).ifPresentOrElse(block -> MixedHandlers.register(block, factory), () -> ID_HANDLERS.put(identifier, factory));
    }

    public static void register(class_2248 block, MixedHandler handler) {
        MixedHandlers.register(block, (class_2482 slab) -> handler);
    }

    public static void register(class_2248 block, MixedHandlerFactory factory) {
        if (block instanceof class_2482) {
            class_2482 slab = (class_2482)block;
            BLOCK_HANDLERS.put(slab, factory);
        } else if (block instanceof VerticalSlabBlock) {
            VerticalSlabBlock slab = (VerticalSlabBlock)block;
            BLOCK_HANDLERS.put(slab.parent, factory);
        } else {
            throw new IllegalArgumentException("Tried to register a handler for a block that wasn't a slab!");
        }
    }

    public static <T extends class_2482> void register(Class<T> klass, MixedHandler handler) {
        MixedHandlers.register(klass, (class_2482 slab) -> handler);
    }

    public static <T extends class_2482> void register(Class<T> klass, MixedHandlerFactory factory) {
        CLASS_HANDLERS.put(klass, factory);
    }

    private static void resolve(class_2960 id) {
        class_7923.field_41175.method_17966(id).ifPresent(block -> MixedHandlers.resolve(block, id));
    }

    private static void resolve(class_2248 block) {
        MixedHandlers.resolve(block, class_7923.field_41175.method_10221((Object)block));
    }

    private static void resolve(class_2248 block, class_2960 id) {
        if (ID_HANDLERS.containsKey(id)) {
            MixedHandlers.register(block, ID_HANDLERS.remove(id));
        }
    }

    public static interface MixedHandlerFactory {
        public MixedHandler create(class_2482 var1);
    }
}

