/*
 * Decompiled with CFR 0.152.
 */
package dev.micalobia.fullslabs.util;

import com.google.common.collect.BiMap;
import dev.micalobia.fullslabs.SlabRegistry;
import dev.micalobia.fullslabs.block.MixedSlabBlock;
import dev.micalobia.fullslabs.block.VerticalSlabBlock;
import dev.micalobia.fullslabs.block.entity.MixedSlabBlockEntity;
import dev.micalobia.fullslabs.handlers.MixedContext;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_310;
import net.minecraft.class_5953;
import org.jetbrains.annotations.Nullable;

public class Utility {
    private static double wrapToMinus180to180(double value) {
        return value < 0.0 ? 180.0 - Math.abs(value) % 360.0 : value - 180.0;
    }

    public static class_2680 getTargetedState(class_2482 slab, class_2350 blockFace, class_2350 target, double cameraYaw) {
        VerticalSlabBlock vertical = VerticalSlabBlock.getVertical(slab);
        return switch (target) {
            case class_2350.field_11036 -> (class_2680)slab.method_9564().method_11657((class_2769)class_2741.field_12485, (Comparable)class_2771.field_12679);
            case class_2350.field_11033 -> (class_2680)slab.method_9564().method_11657((class_2769)class_2741.field_12485, (Comparable)class_2771.field_12681);
            default -> {
                class_2350.class_2351 faceAxis = blockFace.method_10166();
                if (faceAxis == target.method_10166()) {
                    yield (class_2680)((class_2680)vertical.method_9564().method_11657(VerticalSlabBlock.TYPE, (Comparable)((Object)VerticalSlabBlock.VerticalType.AWAY))).method_11657(VerticalSlabBlock.DIRECTION, (Comparable)target);
                }
                float altYaw = faceAxis.method_10178() ? target.method_10144() : blockFace.method_10144();
                double delta = Utility.wrapToMinus180to180(cameraYaw - (double)altYaw);
                boolean towards = faceAxis.method_10178() ? Math.abs(delta) < 90.0 : delta < 0.0 == (blockFace.method_10160() == target);
                yield (class_2680)((class_2680)vertical.method_9564().method_11657(VerticalSlabBlock.TYPE, (Comparable)((Object)(towards ? VerticalSlabBlock.VerticalType.TOWARDS : VerticalSlabBlock.VerticalType.AWAY)))).method_11657(VerticalSlabBlock.DIRECTION, (Comparable)(towards ? target : target.method_10153()));
            }
        };
    }

    public static boolean isSlabWithVertical(class_1799 stack) {
        return Utility.isSlabWithVertical((class_1935)stack.method_7909());
    }

    public static boolean isSlabWithVertical(class_1935 item) {
        class_1747 blockItem;
        return item instanceof class_1747 && Utility.isSlabWithVertical((blockItem = (class_1747)item).method_7711());
    }

    public static boolean isSlabWithVertical(class_2680 state) {
        return Utility.isSlabWithVertical(state.method_26204());
    }

    public static boolean isSlabWithVertical(class_2248 block) {
        class_2482 slab;
        return block instanceof VerticalSlabBlock || block instanceof class_2482 && VerticalSlabBlock.hasVertical(slab = (class_2482)block);
    }

    public static boolean isSlab(class_1799 stack) {
        return Utility.isSlab((class_1935)stack.method_7909());
    }

    public static boolean isSlab(class_1935 item) {
        class_1747 blockItem;
        return item instanceof class_1747 && Utility.isSlab((blockItem = (class_1747)item).method_7711());
    }

    public static boolean isSlab(class_2680 state) {
        return Utility.isSlab(state.method_26204());
    }

    public static boolean isSlab(class_2248 block) {
        return block instanceof class_2482 || block instanceof VerticalSlabBlock;
    }

    public static boolean isDoubleSlab(class_2680 state) {
        return state.method_26204() instanceof class_2482 && state.method_11654((class_2769)class_2741.field_12485) == class_2771.field_12682 || state.method_26204() instanceof VerticalSlabBlock && state.method_11654(VerticalSlabBlock.TYPE) == VerticalSlabBlock.VerticalType.FULL;
    }

    public static boolean isInsideSlab(class_2680 state, class_2338 pos, class_243 hit) {
        class_2248 block = state.method_26204();
        if (!Utility.isSlab(block)) {
            return false;
        }
        if (block instanceof class_2482) {
            class_2771 type = (class_2771)state.method_11654((class_2769)class_2741.field_12485);
            if (type == class_2771.field_12682) {
                return false;
            }
            double diff = hit.field_1351 - (double)pos.method_10264();
            return type == class_2771.field_12681 ? diff >= 0.5 : diff <= 0.5;
        }
        VerticalSlabBlock.VerticalType type = (VerticalSlabBlock.VerticalType)((Object)state.method_11654(VerticalSlabBlock.TYPE));
        if (type == VerticalSlabBlock.VerticalType.FULL) {
            return false;
        }
        class_2350 dir = (class_2350)state.method_11654(VerticalSlabBlock.DIRECTION);
        dir = type == VerticalSlabBlock.VerticalType.TOWARDS ? dir : dir.method_10153();
        return switch (dir) {
            case class_2350.field_11043 -> {
                if (hit.field_1350 - (double)pos.method_10260() >= 0.5) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11035 -> {
                if (hit.field_1350 - (double)pos.method_10260() <= 0.5) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11039 -> {
                if (hit.field_1352 - (double)pos.method_10263() >= 0.5) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11034 -> {
                if (hit.field_1352 - (double)pos.method_10263() <= 0.5) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public static class_239 crosshair(class_1657 player) {
        return player.method_5745(player.method_55754(), 1.0f, false);
    }

    public static class_239 crosshair(@Nullable class_1657 player, boolean isClient) {
        if (isClient) {
            return class_310.method_1551().field_1765;
        }
        if (player == null) {
            throw new IllegalArgumentException("Player is null on serverside!");
        }
        return Utility.crosshair(player);
    }

    @Nullable
    public static StatePair breakHalf(class_1922 view, class_2680 state, class_2338 pos, class_239 crosshair) {
        Objects.requireNonNull(view);
        Objects.requireNonNull(state);
        Objects.requireNonNull(pos);
        Objects.requireNonNull(crosshair);
        class_243 hit = crosshair.method_17784();
        class_2248 block = state.method_26204();
        MixedSlabBlock mixed = (MixedSlabBlock)SlabRegistry.MIXED_SLAB.get();
        if (state.method_27852((class_2248)mixed)) {
            MixedSlabBlock.MixedType type = (MixedSlabBlock.MixedType)((Object)state.method_11654(MixedSlabBlock.TYPE));
            boolean towards = type.isAxisTargetTowards(hit, pos);
            return mixed.forward(view, pos, ctx -> {
                MixedSlabBlockEntity entity = ctx.blockEntityOrThrow();
                return new StatePair(entity.getState(towards), entity.getState(!towards));
            });
        }
        if (!Utility.isDoubleSlab(state)) {
            return null;
        }
        MixedSlabBlock.MixedType type = MixedSlabBlock.MixedType.fromState(state);
        boolean towards = type.isAxisTargetTowards(hit, pos);
        if (block instanceof class_2482) {
            return new StatePair((class_2680)state.method_11657((class_2769)class_2741.field_12485, (Comparable)(towards ? class_2771.field_12679 : class_2771.field_12681)), (class_2680)state.method_11657((class_2769)class_2741.field_12485, (Comparable)(towards ? class_2771.field_12681 : class_2771.field_12679)));
        }
        if (block instanceof VerticalSlabBlock) {
            return new StatePair((class_2680)state.method_11657(VerticalSlabBlock.TYPE, (Comparable)((Object)(towards ? VerticalSlabBlock.VerticalType.TOWARDS : VerticalSlabBlock.VerticalType.AWAY))), (class_2680)state.method_11657(VerticalSlabBlock.TYPE, (Comparable)((Object)(towards ? VerticalSlabBlock.VerticalType.AWAY : VerticalSlabBlock.VerticalType.TOWARDS))));
        }
        throw new AssertionError();
    }

    public static class_2680 targetedHalf(class_1922 world, class_2680 state, class_2338 pos, class_243 hit) {
        MixedSlabBlock mixed = (MixedSlabBlock)SlabRegistry.MIXED_SLAB.get();
        if (!Utility.isDoubleSlab(state) && !state.method_27852((class_2248)mixed)) {
            return state;
        }
        class_2248 block = state.method_26204();
        if (block == mixed) {
            return mixed.forwardSideValue(world, pos, hit, MixedContext.Sided::state);
        }
        boolean towards = MixedSlabBlock.MixedType.fromState(state).isAxisTargetTowards(hit, pos);
        if (block instanceof class_2482) {
            return (class_2680)state.method_11657((class_2769)class_2741.field_12485, (Comparable)(towards ? class_2771.field_12679 : class_2771.field_12681));
        }
        return (class_2680)state.method_11657(VerticalSlabBlock.TYPE, (Comparable)((Object)(towards ? VerticalSlabBlock.VerticalType.TOWARDS : VerticalSlabBlock.VerticalType.AWAY)));
    }

    public static class_2350 slabDirection(class_2680 state) {
        class_2248 class_22482 = state.method_26204();
        Objects.requireNonNull(class_22482);
        class_2248 class_22483 = class_22482;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2482.class, VerticalSlabBlock.class}, (Object)class_22483, n)) {
            case 0: {
                class_2482 ignored = (class_2482)class_22483;
                class_2771 type = (class_2771)state.method_11654((class_2769)class_2741.field_12485);
                if (type == class_2771.field_12682) {
                    throw new IllegalArgumentException("Not a half-slab!");
                }
                return type == class_2771.field_12679 ? class_2350.field_11036 : class_2350.field_11033;
            }
            case 1: {
                VerticalSlabBlock ignored = (VerticalSlabBlock)class_22483;
                VerticalSlabBlock.VerticalType type = (VerticalSlabBlock.VerticalType)((Object)state.method_11654(VerticalSlabBlock.TYPE));
                if (type == VerticalSlabBlock.VerticalType.FULL) {
                    throw new IllegalArgumentException("Not a half-slab!");
                }
                class_2350 direction = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
                return type == VerticalSlabBlock.VerticalType.TOWARDS ? direction : direction.method_10153();
            }
        }
        throw new IllegalArgumentException("Not a half-slab!");
    }

    public static Optional<class_2248> getWaxed(class_2248 unwaxed) {
        return Optional.ofNullable((class_2248)((BiMap)class_5953.field_29560.get()).get((Object)unwaxed));
    }

    public record StatePair(class_2680 towards, class_2680 away) {
    }
}

