/*
 * Decompiled with CFR 0.152.
 */
package dev.micalobia.fullslabs;

import com.google.common.collect.BiMap;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.micalobia.fullslabs.FullSlabs;
import dev.micalobia.fullslabs.block.MixedSlabBlock;
import dev.micalobia.fullslabs.block.OxidizableVerticalSlabBlock;
import dev.micalobia.fullslabs.block.VerticalSlabBlock;
import dev.micalobia.fullslabs.block.entity.MixedSlabBlockEntity;
import dev.micalobia.fullslabs.handlers.MixedHandler;
import dev.micalobia.fullslabs.handlers.MixedHandlers;
import dev.micalobia.fullslabs.handlers.OxidizableMixedHandler;
import dev.micalobia.fullslabs.handlers.VanillaMixedHandler;
import dev.micalobia.fullslabs.mixin.BlockEntityTypeAccessor;
import dev.micalobia.fullslabs.neoforge.SlabRegistryImpl;
import dev.micalobia.fullslabs.util.Utility;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.WeatheringCopperSlabBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class SlabRegistry {
    private static final Map<Class<? extends SlabBlock>, VerticalFactory> MAPPING = new HashMap<Class<? extends SlabBlock>, VerticalFactory>();
    private static final Map<Class<? extends SlabBlock>, PairConsumer> POST_INIT = new HashMap<Class<? extends SlabBlock>, PairConsumer>();
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"fullslabs", (ResourceKey)Registries.BLOCK);
    private static final DeferredRegister<Block> GENERATED = DeferredRegister.create((String)"fullslabs", (ResourceKey)Registries.BLOCK);
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((String)"fullslabs", (ResourceKey)Registries.BLOCK_ENTITY_TYPE);
    public static final RegistrySupplier<MixedSlabBlock> MIXED_SLAB = SlabRegistry.registerBlock("mixed_slab", MixedSlabBlock::new);
    public static final RegistrySupplier<BlockEntityType<MixedSlabBlockEntity>> MIXED_SLAB_ENTITY = BLOCK_ENTITIES.register(FullSlabs.id("mixed_slab"), () -> BlockEntityTypeAccessor.constructor(MixedSlabBlockEntity::new, Set.of((Block)MIXED_SLAB.get())));

    private SlabRegistry() {
    }

    private static <T extends Block> RegistrySupplier<T> registerBlock(String id, Function<BlockBehaviour.Properties, T> func) {
        return SlabRegistry.registerBlock(id, func, BlockBehaviour.Properties::of);
    }

    private static <T extends Block> RegistrySupplier<T> registerBlock(String id, Function<BlockBehaviour.Properties, T> func, Supplier<BlockBehaviour.Properties> settings) {
        return BLOCKS.register(id, () -> (Block)func.apply(((BlockBehaviour.Properties)settings.get()).setId(SlabRegistry.generateKey(id))));
    }

    public static void init() {
        SlabRegistry.registerVanilla();
        SlabRegistry.initSlabListener();
        SlabRegistry.seedExistingSlabs();
        BLOCKS.register();
        BLOCK_ENTITIES.register();
        GENERATED.register();
        LifecycleEvent.SETUP.register(() -> VerticalSlabBlock.MAP_VIEW.keySet().stream().filter(slab -> POST_INIT.containsKey(slab.getClass())).forEach(slab -> POST_INIT.get(slab.getClass()).consume(slab, VerticalSlabBlock.getVertical(slab))));
    }

    private static void registerVanilla() {
        SlabRegistry.registerVertical(SlabBlock.class, VerticalSlabBlock::new);
        MixedHandlers.register(SlabBlock.class, (MixedHandler)VanillaMixedHandler.INSTANCE);
        SlabRegistry.registerVertical(WeatheringCopperSlabBlock.class, OxidizableVerticalSlabBlock::new, SlabRegistry::registerOxidizableSlabs);
        MixedHandlers.register(WeatheringCopperSlabBlock.class, (MixedHandler)OxidizableMixedHandler.INSTANCE);
    }

    private static void registerDebug() {
        SlabRegistry.registerBlock("debug", Block::new);
        SlabRegistry.registerBlock("debug_slab", SlabBlock::new);
    }

    private static ResourceKey<Block> generateKey(String path) {
        return SlabRegistry.generateKey(FullSlabs.id(path));
    }

    private static ResourceKey<Block> generateKey(ResourceLocation id) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)id);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void initSlabListener() {
        SlabRegistryImpl.initSlabListener();
    }

    public static void registerOxidizableBlockPair(Block less, Block more) {
        Objects.requireNonNull(less, "Oxidizable block cannot be null!");
        Objects.requireNonNull(more, "Oxidizable block cannot be null!");
        ((BiMap)WeatheringCopper.NEXT_BY_BLOCK.get()).forcePut((Object)less, (Object)more);
    }

    public static void registerWaxableBlockPair(Block unwaxed, Block waxed) {
        Objects.requireNonNull(unwaxed, "Unwaxed block cannot be null!");
        Objects.requireNonNull(waxed, "Waxed block cannot be null!");
        ((BiMap)HoneycombItem.WAXABLES.get()).forcePut((Object)unwaxed, (Object)waxed);
    }

    private static void registerOxidizableSlabs(SlabBlock slab, VerticalSlabBlock vertical) {
        Optional less = WeatheringCopper.getPrevious((Block)slab);
        Optional more = WeatheringCopper.getNext((Block)slab);
        Optional lessWaxed = less.flatMap(Utility::getWaxed);
        Optional<Block> slabWaxed = Utility.getWaxed((Block)slab);
        Optional moreWaxed = more.flatMap(Utility::getWaxed);
        Optional lessVertical = less.flatMap(VerticalSlabBlock::tryGetVertical);
        Optional moreVertical = more.flatMap(VerticalSlabBlock::tryGetVertical);
        Optional lessWaxedVertical = lessWaxed.flatMap(VerticalSlabBlock::tryGetVertical);
        Optional slabWaxedVertical = slabWaxed.flatMap(VerticalSlabBlock::tryGetVertical);
        Optional moreWaxedVertical = moreWaxed.flatMap(VerticalSlabBlock::tryGetVertical);
        lessVertical.ifPresent(_less -> {
            SlabRegistry.registerOxidizableBlockPair(_less, vertical);
            lessWaxedVertical.ifPresent(_waxed -> {
                SlabRegistry.registerWaxableBlockPair(_less, _waxed);
                MixedHandlers.register((Block)_waxed, (MixedHandler)OxidizableMixedHandler.INSTANCE);
            });
        });
        moreVertical.ifPresent(_more -> {
            SlabRegistry.registerOxidizableBlockPair(vertical, _more);
            moreWaxedVertical.ifPresent(_waxed -> {
                SlabRegistry.registerWaxableBlockPair(_more, _waxed);
                MixedHandlers.register((Block)_waxed, (MixedHandler)OxidizableMixedHandler.INSTANCE);
            });
        });
        slabWaxedVertical.ifPresent(_waxed -> {
            SlabRegistry.registerWaxableBlockPair(vertical, _waxed);
            MixedHandlers.register((Block)_waxed, (MixedHandler)OxidizableMixedHandler.INSTANCE);
        });
    }

    public static <S extends SlabBlock, V extends VerticalSlabBlock> void registerVertical(Class<S> slabClass, VerticalFactory<S, V> factory) {
        SlabRegistry.registerVertical(slabClass, factory, null);
    }

    public static <S extends SlabBlock, V extends VerticalSlabBlock> void registerVertical(Class<S> slabClass, VerticalFactory<S, V> factory, @Nullable PairConsumer<S, V> listener) {
        VerticalFactory<S, V> old = MAPPING.putIfAbsent(slabClass, factory);
        if (old != null) {
            throw new IllegalArgumentException("That slab class has already been registered!");
        }
        if (listener != null) {
            POST_INIT.put(slabClass, listener);
        }
    }

    private static void seedExistingSlabs() {
        List<Block> slabs = BuiltInRegistries.BLOCK.stream().filter(SlabBlock.class::isInstance).toList();
        for (Block block : slabs) {
            SlabRegistry.tryRegisterVertical(BuiltInRegistries.BLOCK.getKey((Object)block), block);
        }
    }

    @ApiStatus.Internal
    public static void tryRegisterVertical(ResourceLocation id, Block block) {
        if (!(block instanceof SlabBlock)) {
            return;
        }
        SlabBlock slab = (SlabBlock)block;
        VerticalFactory factory = MAPPING.get(slab.getClass());
        if (factory == null) {
            FullSlabs.LOGGER.warn("{} ({}) failed to register a vertical!", (Object)slab, (Object)slab.getClass().getSimpleName());
            return;
        }
        ResourceLocation verticalId = FullSlabs.id(FullSlabs.verticalPath(id));
        RegistrySupplier b = GENERATED.register(verticalId, () -> {
            BlockBehaviour.Properties settings = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)slab).setId(SlabRegistry.generateKey(verticalId)).overrideLootTable(slab.getLootTable());
            return factory.create(slab, settings);
        });
    }

    public static interface VerticalFactory<S extends SlabBlock, V extends VerticalSlabBlock> {
        public V create(S var1, BlockBehaviour.Properties var2);
    }

    public static interface PairConsumer<S extends SlabBlock, V extends VerticalSlabBlock> {
        public void consume(S var1, V var2);
    }
}

