/*
 * Decompiled with CFR 0.152.
 */
package dev.micalobia.fullslabs.block;

import com.google.common.collect.ImmutableList;
import dev.micalobia.fullslabs.SlabRegistry;
import dev.micalobia.fullslabs.block.VerticalSlabBlock;
import dev.micalobia.fullslabs.block.entity.MixedSlabBlockEntity;
import dev.micalobia.fullslabs.ducks.MixedSlabBlockDuck;
import dev.micalobia.fullslabs.handlers.MixedConsumer;
import dev.micalobia.fullslabs.handlers.MixedContext;
import dev.micalobia.fullslabs.handlers.MixedFunction;
import dev.micalobia.fullslabs.util.Utility;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class MixedSlabBlock
extends Block
implements EntityBlock,
MixedSlabBlockDuck {
    public static final EnumProperty<MixedType> TYPE = EnumProperty.create((String)"type", MixedType.class);
    @ApiStatus.Internal
    @Nullable
    public static Player cachedPlayer = null;

    public MixedSlabBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TYPE});
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    protected void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.forwardSides((BlockGetter)world, pos, ctx -> ctx.handler().randomTick((MixedContext.Sided)ctx, world, pos, random));
    }

    protected boolean isSignalSource(BlockState state) {
        return true;
    }

    public boolean emitsRedstonePower(BlockGetter world, BlockPos pos) {
        return this.forwardSidesValue(world, pos, ctx -> ctx.handler().emitsRedstonePower((MixedContext.Sided)ctx), Boolean::logicalOr);
    }

    protected int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return this.forwardSidesValue(world, pos, ctx -> ctx.handler().getWeakRedstonePower((MixedContext.Sided)ctx, world, pos, direction), Math::max);
    }

    protected int getDirectSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return this.forwardSidesValue(world, pos, ctx -> ctx.handler().getStrongRedstonePower((MixedContext.Sided)ctx, world, pos, direction), Math::max);
    }

    protected void onProjectileHit(Level world, BlockState state, BlockHitResult hit, Projectile projectile) {
        this.forwardSide((BlockGetter)world, hit.getBlockPos(), hit.getLocation(), (MixedContext.Sided ctx) -> ctx.handler().onProjectileHit((MixedContext.Sided)ctx, world, hit, projectile));
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
        this.forwardSide((BlockGetter)world, pos, entity.position(), (MixedContext.Sided ctx) -> ctx.handler().onSteppedOn((MixedContext.Sided)ctx, world, pos, entity));
    }

    public void fallOn(Level world, BlockState state, BlockPos pos, Entity entity, double fallDistance) {
        this.forwardSide((BlockGetter)world, pos, entity.position(), (MixedContext.Sided ctx) -> ctx.handler().onLandedUpon((MixedContext.Sided)ctx, world, pos, entity, fallDistance));
    }

    public void updateEntityMovementAfterFallOn(BlockGetter world, Entity entity) {
        this.forwardSide(world, entity.getOnPosLegacy(), entity.position(), (MixedContext.Sided ctx) -> ctx.handler().onEntityLand((MixedContext.Sided)ctx, world, entity));
    }

    public void handlePrecipitation(BlockState state, Level world, BlockPos pos, Biome.Precipitation precipitation) {
        this.forwardSides((BlockGetter)world, pos, ctx -> ctx.handler().precipitationTick((MixedContext.Sided)ctx, world, pos, precipitation));
    }

    protected void attack(BlockState state, Level world, BlockPos pos, Player player) {
        this.forwardSides((BlockGetter)world, pos, ctx -> ctx.handler().onBlockBreakStart((MixedContext.Sided)ctx, world, pos, player));
    }

    public void playerDestroy(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        this.forwardSides((BlockGetter)world, pos, ctx -> ctx.handler().afterBreak((MixedContext.Sided)ctx, world, player, pos, blockEntity, tool));
    }

    protected void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.forwardSides((BlockGetter)world, pos, ctx -> ctx.handler().scheduledTick((MixedContext.Sided)ctx, world, pos, random));
    }

    protected void spawnAfterBreak(BlockState state, ServerLevel world, BlockPos pos, ItemStack tool, boolean dropExperience) {
        this.forwardSides((BlockGetter)world, pos, ctx -> ctx.handler().onStacksDropped((MixedContext.Sided)ctx, world, pos, tool, dropExperience));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        return this.forwardSideValue((BlockGetter)world, pos, hit.getLocation(), (MixedContext.Sided ctx) -> ctx.handler().onUse((MixedContext.Sided)ctx, world, pos, player, hit));
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.forwardSideValue((BlockGetter)world, pos, hit.getLocation(), (MixedContext.Sided ctx) -> ctx.handler().onUseWithItem((MixedContext.Sided)ctx, stack, world, pos, player, hand, hit));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MixedSlabBlockEntity(pos, state);
    }

    protected ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state, boolean includeData) {
        HitResult crosshair = Utility.crosshair(cachedPlayer, world.isClientSide());
        return this.forwardSideValue((BlockGetter)world, pos, crosshair.getLocation(), (MixedContext.Sided ctx) -> new ItemStack((ItemLike)ctx.block()));
    }

    protected float getDestroyProgress(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        HitResult hit = Utility.crosshair(player, ((Level)world).isClientSide());
        return this.forwardSideValue(world, pos, hit.getLocation(), (MixedContext.Sided ctx) -> Float.valueOf(ctx.state().getDestroyProgress(player, world, pos))).floatValue();
    }

    protected boolean triggerEvent(BlockState state, Level world, BlockPos pos, int type, int data) {
        if (type != 0) {
            return false;
        }
        world.sendBlockUpdated(pos, state, state, 27);
        return true;
    }

    @Override
    public <T> T forward(BlockGetter world, BlockPos pos, MixedFunction<T, MixedContext.Sideless> function) {
        return function.apply(MixedContext.create(world, pos));
    }

    @Override
    public <T> T forwardSideValue(BlockGetter world, BlockPos pos, boolean towards, MixedFunction<T, MixedContext.Sided> function) {
        return (T)this.forward(world, pos, ctx -> function.apply(ctx.sided(towards)));
    }

    @Override
    public <T> T forwardSideValue(BlockGetter world, BlockPos pos, Vec3 hit, MixedFunction<T, MixedContext.Sided> function) {
        return (T)this.forward(world, pos, ctx -> {
            MixedType type = (MixedType)((Object)((Object)ctx.mixedState().getValue(TYPE)));
            boolean towards = type.isAxisTargetTowards(hit, pos);
            return function.apply(ctx.sided(towards));
        });
    }

    @Override
    public void forwardSide(BlockGetter world, BlockPos pos, boolean towards, MixedConsumer<MixedContext.Sided> consumer) {
        Void ignored = this.forwardSideValue(world, pos, towards, (MixedContext.Sided ctx) -> {
            consumer.apply((MixedContext.Sided)ctx);
            return null;
        });
    }

    @Override
    public void forwardSide(BlockGetter world, BlockPos pos, Vec3 hit, MixedConsumer<MixedContext.Sided> consumer) {
        this.forwardSideValue(world, pos, hit, (MixedContext.Sided ctx) -> {
            consumer.apply((MixedContext.Sided)ctx);
            return null;
        });
    }

    @Override
    public <T, R> R forwardSidesValue(BlockGetter world, BlockPos pos, MixedFunction<T, MixedContext.Sided> function, BiFunction<T, T, R> selector) {
        return (R)this.forward(world, pos, ctx -> {
            Object towardsValue = function.apply(ctx.sided(true));
            Object awayValue = function.apply(ctx.sided(false));
            return selector.apply(towardsValue, awayValue);
        });
    }

    @Override
    public void forwardSides(BlockGetter world, BlockPos pos, MixedConsumer<MixedContext.Sided> consumer) {
        this.forwardSidesValue(world, pos, ctx -> {
            consumer.apply((MixedContext.Sided)ctx);
            return null;
        }, (a, b) -> null);
    }

    public boolean towards(BlockState state, BlockHitResult hit) {
        return this.towards(state, hit.getLocation(), hit.getBlockPos());
    }

    public boolean towards(BlockState state, Vec3 hit, BlockPos pos) {
        return ((MixedType)((Object)state.getValue(TYPE))).isAxisTargetTowards(hit, pos);
    }

    public static enum MixedType implements StringRepresentable
    {
        NORTH("north", Direction.NORTH),
        SOUTH("south", Direction.SOUTH),
        EAST("east", Direction.EAST),
        WEST("west", Direction.WEST),
        VERTICAL("vertical", Direction.UP);

        private static final List<MixedType> CARDINAL;
        public final Direction direction;
        private final String name;

        private MixedType(String name, Direction direction) {
            this.name = name;
            this.direction = direction;
        }

        public static List<MixedType> cardinal() {
            return CARDINAL;
        }

        public static MixedType fromState(BlockState state) {
            Block block = state.getBlock();
            if (block instanceof SlabBlock) {
                return VERTICAL;
            }
            if (block instanceof VerticalSlabBlock) {
                return switch ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    default -> throw new MatchException(null, null);
                    case Direction.UP, Direction.DOWN -> throw new AssertionError();
                    case Direction.NORTH -> NORTH;
                    case Direction.SOUTH -> SOUTH;
                    case Direction.WEST -> WEST;
                    case Direction.EAST -> EAST;
                };
            }
            if (block == SlabRegistry.MIXED_SLAB.get()) {
                return (MixedType)((Object)state.getValue(TYPE));
            }
            throw new IllegalArgumentException("Not a slab!");
        }

        public String getSerializedName() {
            return this.name;
        }

        public BlockState state(SlabBlock slab, boolean towards) {
            if (!VerticalSlabBlock.hasVertical(slab)) {
                throw new IllegalArgumentException("%s is missing a vertical".formatted(slab));
            }
            if (this == VERTICAL) {
                return (BlockState)slab.defaultBlockState().setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)(towards ? SlabType.TOP : SlabType.BOTTOM));
            }
            return (BlockState)((BlockState)VerticalSlabBlock.getVertical(slab).defaultBlockState().setValue(VerticalSlabBlock.TYPE, (Comparable)((Object)(towards ? VerticalSlabBlock.VerticalType.TOWARDS : VerticalSlabBlock.VerticalType.AWAY)))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)this.direction);
        }

        public boolean isAxisTargetTowards(Vec3 hit, BlockPos pos) {
            return (switch (this.direction.getAxis()) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> {
                    if (hit.x - (double)pos.getX() > 0.5) {
                        yield Direction.EAST;
                    }
                    yield Direction.WEST;
                }
                case Direction.Axis.Y -> {
                    if (hit.y - (double)pos.getY() > 0.5) {
                        yield Direction.UP;
                    }
                    yield Direction.DOWN;
                }
                case Direction.Axis.Z -> hit.z - (double)pos.getZ() > 0.5 ? Direction.SOUTH : Direction.NORTH;
            }) == this.direction;
        }

        static {
            CARDINAL = ImmutableList.of((Object)((Object)NORTH), (Object)((Object)SOUTH), (Object)((Object)EAST), (Object)((Object)WEST));
        }
    }
}

