/*
 * Decompiled with CFR 0.152.
 */
package dev.micalobia.fullslabs.block;

import dev.micalobia.fullslabs.handlers.MixedHandlers;
import dev.micalobia.fullslabs.util.Utility;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class VerticalSlabBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final Map<SlabBlock, VerticalSlabBlock> MAP = new HashMap<SlabBlock, VerticalSlabBlock>();
    public static final EnumProperty<Direction> DIRECTION = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<VerticalType> TYPE = EnumProperty.create((String)"type", VerticalType.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final VoxelShape NORTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    public static final VoxelShape EAST_SHAPE = Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape SOUTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape WEST_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    public static final Map<SlabBlock, VerticalSlabBlock> MAP_VIEW = Collections.unmodifiableMap(MAP);
    public final SlabBlock parent;

    public VerticalSlabBlock(SlabBlock block, BlockBehaviour.Properties settings) {
        super(settings);
        this.parent = block;
        MAP.put(block, this);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(DIRECTION, (Comparable)Direction.WEST)).setValue(TYPE, (Comparable)((Object)VerticalType.TOWARDS))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return state.getValue(TYPE) != VerticalType.FULL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DIRECTION, TYPE, WATERLOGGED});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        VerticalType type = (VerticalType)((Object)state.getValue(TYPE));
        if (type == VerticalType.FULL) {
            return Shapes.block();
        }
        boolean towards = type == VerticalType.TOWARDS;
        return switch ((Direction)state.getValue(DIRECTION)) {
            case Direction.NORTH -> {
                if (towards) {
                    yield NORTH_SHAPE;
                }
                yield SOUTH_SHAPE;
            }
            case Direction.EAST -> {
                if (towards) {
                    yield EAST_SHAPE;
                }
                yield WEST_SHAPE;
            }
            case Direction.SOUTH -> {
                if (towards) {
                    yield SOUTH_SHAPE;
                }
                yield NORTH_SHAPE;
            }
            case Direction.WEST -> {
                if (towards) {
                    yield WEST_SHAPE;
                }
                yield EAST_SHAPE;
            }
            default -> throw new IllegalArgumentException();
        };
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        ItemStack stack = context.getItemInHand();
        VerticalType type = (VerticalType)((Object)state.getValue(TYPE));
        if (type == VerticalType.FULL) {
            return false;
        }
        Block block = ((BlockItem)stack.getItem()).getBlock();
        if (!(block instanceof SlabBlock)) {
            return false;
        }
        if (!(block == this.parent || MixedHandlers.hasHandler(block) && MixedHandlers.hasHandler(this))) {
            return false;
        }
        if (context.replacingClickedOnBlock()) {
            return Utility.isInsideSlab(state, context.getClickedPos(), context.getClickLocation());
        }
        return true;
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean placeLiquid(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidState) {
        return state.getValue(TYPE) != VerticalType.FULL && super.placeLiquid(world, pos, state, fluidState);
    }

    public boolean canPlaceLiquid(@Nullable LivingEntity filler, BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return state.getValue(TYPE) != VerticalType.FULL && super.canPlaceLiquid(filler, world, pos, state, fluid);
    }

    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            tickView.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(world));
        }
        return super.updateShape(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return type == PathComputationType.WATER && state.getFluidState().is(FluidTags.WATER);
    }

    public Item asItem() {
        return this.parent.asItem();
    }

    public static VerticalSlabBlock getVertical(SlabBlock block) {
        return MAP.get(block);
    }

    public static Optional<VerticalSlabBlock> tryGetVertical(Block block) {
        if (block instanceof SlabBlock) {
            SlabBlock slab = (SlabBlock)block;
            return Optional.ofNullable(MAP.get(slab));
        }
        if (block instanceof VerticalSlabBlock) {
            VerticalSlabBlock slab = (VerticalSlabBlock)block;
            return Optional.of(slab);
        }
        return Optional.empty();
    }

    public static SlabBlock getRoot(Block block) {
        return VerticalSlabBlock.tryGetRoot(block).orElseThrow(() -> new IllegalArgumentException("Not a slab or missing vertical!"));
    }

    public static Optional<SlabBlock> tryGetRoot(Block block) {
        Object slab;
        if (block instanceof SlabBlock && VerticalSlabBlock.hasVertical(slab = (SlabBlock)block)) {
            return Optional.of(slab);
        }
        if (block instanceof VerticalSlabBlock) {
            slab = (VerticalSlabBlock)block;
            return Optional.of(slab.parent);
        }
        return Optional.empty();
    }

    public static boolean hasVertical(SlabBlock block) {
        return MAP.containsKey(block);
    }

    public static enum VerticalType implements StringRepresentable
    {
        TOWARDS("towards"),
        AWAY("away"),
        FULL("full");

        private final String name;

        private VerticalType(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

