/*
 * Decompiled with CFR 0.152.
 */
package dev.micalobia.fullslabs.client.models;

import com.google.common.collect.ImmutableList;
import dev.micalobia.fullslabs.FullSlabs;
import dev.micalobia.fullslabs.block.VerticalSlabBlock;
import dev.micalobia.fullslabs.config.Config;
import dev.micalobia.fullslabs.mixin.client.BakerImplOuterAccessor;
import dev.micalobia.fullslabs.mixin.client.ModelBakerAccessor;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.block.model.SingleVariant;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.UnbakedGeometry;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import org.jetbrains.annotations.Nullable;

public class VerticalSlabModel
implements BlockStateModel.UnbakedRoot {
    private static final ResourceLocation ATLAS = TextureAtlas.LOCATION_BLOCKS;
    public static final VerticalSlabModel INSTANCE = new VerticalSlabModel();
    public static final List<ResourceLocation> TEMPLATES = VerticalSlabModel.templates();

    private VerticalSlabModel() {
    }

    private static VerticalSlabBlock verifyVertical(Block block) {
        if (!(block instanceof VerticalSlabBlock)) {
            throw new IllegalArgumentException();
        }
        VerticalSlabBlock slab = (VerticalSlabBlock)block;
        return slab;
    }

    public static ResourceLocation templateId(BlockState state) {
        VerticalSlabBlock slab = VerticalSlabModel.verifyVertical(state.getBlock());
        Direction facing = (Direction)state.getValue(VerticalSlabBlock.DIRECTION);
        VerticalSlabBlock.VerticalType type = (VerticalSlabBlock.VerticalType)((Object)state.getValue(VerticalSlabBlock.TYPE));
        boolean tilted = Config.isTilted((Block)slab.parent);
        if (tilted) {
            return FullSlabs.id("block/vertical/tilted/%s_%s".formatted(facing.getSerializedName(), type.getSerializedName()));
        }
        if (type == VerticalSlabBlock.VerticalType.FULL) {
            return FullSlabs.id("block/vertical/normal/full");
        }
        return FullSlabs.id("block/vertical/normal/%s".formatted((type == VerticalSlabBlock.VerticalType.AWAY ? facing.getOpposite() : facing).getSerializedName()));
    }

    public static BlockState parentState(BlockState state) {
        VerticalSlabBlock slab = VerticalSlabModel.verifyVertical(state.getBlock());
        VerticalSlabBlock.VerticalType type = (VerticalSlabBlock.VerticalType)((Object)state.getValue(VerticalSlabBlock.TYPE));
        BlockState parentState = slab.parent.defaultBlockState();
        return switch (type) {
            default -> throw new MatchException(null, null);
            case VerticalSlabBlock.VerticalType.AWAY -> (BlockState)parentState.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.BOTTOM);
            case VerticalSlabBlock.VerticalType.TOWARDS -> (BlockState)parentState.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.TOP);
            case VerticalSlabBlock.VerticalType.FULL -> (BlockState)parentState.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.DOUBLE);
        };
    }

    public static ResourceLocation makeModelId(BlockState state) {
        VerticalSlabModel.verifyVertical(state.getBlock());
        return FullSlabs.id("block/%s/%s_%s".formatted(BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).getPath(), ((Direction)state.getValue(VerticalSlabBlock.DIRECTION)).getSerializedName(), ((VerticalSlabBlock.VerticalType)((Object)state.getValue(VerticalSlabBlock.TYPE))).getSerializedName()));
    }

    public BlockStateModel bake(BlockState state, ModelBaker baker) {
        VerticalSlabBlock slab = VerticalSlabModel.verifyVertical(state.getBlock());
        ResourceLocation parentId = BuiltInRegistries.BLOCK.getKey((Object)slab.parent);
        ResourceLocation templateId = VerticalSlabModel.templateId(state);
        BlockState parentState = VerticalSlabModel.parentState(state);
        ModelBakery outer = ((BakerImplOuterAccessor)baker).fullslabs$getOuter();
        BlockStateModel.UnbakedRoot grouped = ((ModelBakerAccessor)outer).fullslabs$getBlockModels().get(parentState);
        if (grouped == null) {
            throw new IllegalStateException("Parent slab state wasn't discovered: " + String.valueOf(parentState));
        }
        BlockStateModel parent = grouped.bake(parentState, baker);
        TextureAtlasSprite particle = parent.particleIcon();
        List parts = parent.collectParts(RandomSource.create((long)0L));
        List<HasQuads> list = parts.stream().map(x -> arg_0 -> ((BlockModelPart)x).getQuads(arg_0)).toList();
        Boolean useAO = parts.stream().findFirst().map(BlockModelPart::useAmbientOcclusion).orElse(true);
        Textures textures = Textures.fetch(particle, list);
        TextureSlots mapped = VerticalSlabModel.mapped(parentId.toString(), textures);
        ResolvedModel template = baker.getModel(templateId);
        UnbakedGeometry geometry = template.getTopGeometry();
        QuadCollection quads = geometry.bake(mapped, baker, (ModelState)BlockModelRotation.X0_Y0, (ModelDebugName)template);
        SimpleModelWrapper part = new SimpleModelWrapper(quads, useAO.booleanValue(), particle);
        return new SingleVariant((BlockModelPart)part);
    }

    public Object visualEqualityGroup(BlockState state) {
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
        String facing = ((Direction)state.getValue(VerticalSlabBlock.DIRECTION)).getSerializedName();
        String type = ((VerticalSlabBlock.VerticalType)((Object)state.getValue(VerticalSlabBlock.TYPE))).getSerializedName();
        return String.valueOf(id) + "|" + facing + "|" + type;
    }

    public void resolveDependencies(ResolvableModel.Resolver resolver) {
        TEMPLATES.forEach(arg_0 -> ((ResolvableModel.Resolver)resolver).markDependency(arg_0));
    }

    private static List<ResourceLocation> templates() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        Direction.Plane.HORIZONTAL.forEach(direction -> {
            String str = direction.getSerializedName();
            builder.add((Object)FullSlabs.id("block/vertical/tilted/%s_towards".formatted(str)));
            builder.add((Object)FullSlabs.id("block/vertical/tilted/%s_away".formatted(str)));
            builder.add((Object)FullSlabs.id("block/vertical/tilted/%s_full".formatted(str)));
            builder.add((Object)FullSlabs.id("block/vertical/normal/%s".formatted(str)));
        });
        builder.add((Object)FullSlabs.id("block/vertical/normal/full"));
        return builder.build();
    }

    public static TextureSlots mapped(String simple, Textures textures) {
        return VerticalSlabModel.mapped(simple, textures.particle, textures.side, textures.top, textures.bottom);
    }

    public static TextureSlots mapped(String simple, TextureAtlasSprite particle, TextureAtlasSprite side, TextureAtlasSprite top, TextureAtlasSprite bottom) {
        TextureSlots.Data table = new TextureSlots.Data.Builder().addTexture("side", VerticalSlabModel.spriteId(side)).addTexture("top", VerticalSlabModel.spriteId(top)).addTexture("bottom", VerticalSlabModel.spriteId(bottom)).addTexture("particle", VerticalSlabModel.spriteId(particle)).build();
        return new TextureSlots.Resolver().addLast(table).resolve(() -> simple);
    }

    private static Material spriteId(TextureAtlasSprite sprite) {
        return new Material(ATLAS, sprite.contents().name());
    }

    public record Textures(TextureAtlasSprite particle, TextureAtlasSprite side, TextureAtlasSprite top, TextureAtlasSprite bottom) {
        public static Textures fetch(TextureAtlasSprite particle, List<HasQuads> quads) {
            TextureAtlasSprite side = Direction.Plane.HORIZONTAL.stream().map(dir -> Textures.fetchFace(dir, quads)).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(particle);
            TextureAtlasSprite top = Textures.fetchFace(Direction.UP, quads).orElse(side);
            TextureAtlasSprite bottom = Textures.fetchFace(Direction.DOWN, quads).orElse(side);
            return new Textures(particle, side, top, bottom);
        }

        public static Optional<TextureAtlasSprite> fetchFace(Direction direction, List<HasQuads> parts) {
            return parts.stream().map(hasQuads -> Textures.fetchFace(direction, hasQuads)).findFirst().filter(Optional::isPresent).map(Optional::get).stream().findFirst();
        }

        public static Optional<TextureAtlasSprite> fetchFace(Direction direction, HasQuads parent) {
            return parent.getQuads(direction).stream().map(BakedQuad::sprite).findFirst().or(() -> parent.getQuads(null).stream().filter(q -> q.direction() == direction).map(BakedQuad::sprite).findFirst());
        }
    }

    @FunctionalInterface
    public static interface HasQuads {
        public List<BakedQuad> getQuads(@Nullable Direction var1);
    }
}

