/*
 * Decompiled with CFR 0.152.
 */
package dev.micalobia.fullslabs.client.models.neoforge;

import dev.micalobia.fullslabs.FullSlabs;
import dev.micalobia.fullslabs.block.entity.MixedSlabBlockEntity;
import dev.micalobia.fullslabs.neoforge.FullSlabsNeoForge;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.model.data.ModelData;

public class MixedSlabModelImpl {
    public static BlockStateModel create(BlockState state, ModelBaker baker) {
        return Model.INSTANCE;
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    public static final class Model
    implements BlockStateModel {
        public static Model INSTANCE = new Model();

        public void collectParts(RandomSource random, List<BlockModelPart> parts) {
        }

        public void collectParts(BlockAndTintGetter world, BlockPos pos, BlockState state, RandomSource random, List<BlockModelPart> parts) {
            ModelData data = world.getModelData(pos);
            MixedSlabBlockEntity.ModelContext ctx = (MixedSlabBlockEntity.ModelContext)data.get(FullSlabsNeoForge.MIXED_CONTEXT_MODEL_PROPERTY);
            if (ctx == null) {
                FullSlabs.LOGGER.warn("Mixed slab didn't send model data!");
                return;
            }
            BlockState towards = ctx.towardsState();
            BlockState away = ctx.awayState();
            Minecraft client = Minecraft.getInstance();
            BlockRenderDispatcher manager = client.getBlockRenderer();
            BlockStateModel towardsModel = manager.getBlockModel(towards);
            BlockStateModel awayModel = manager.getBlockModel(away);
            towardsModel.collectParts(world, pos, state, random, parts);
            awayModel.collectParts(world, pos, state, random, parts);
        }

        public TextureAtlasSprite particleIcon() {
            return Minecraft.getInstance().getModelManager().getMissingBlockStateModel().particleIcon();
        }

        public TextureAtlasSprite particleIcon(BlockAndTintGetter level, BlockPos pos, BlockState state) {
            return Minecraft.getInstance().getModelManager().getMissingBlockStateModel().particleIcon(level, pos, state);
        }
    }
}

