/*
 * Decompiled with CFR 0.152.
 */
package dev.micalobia.fullslabs.config;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.networking.NetworkManager;
import dev.micalobia.fullslabs.config.neoforge.ControlsImpl;
import dev.micalobia.fullslabs.util.SlabPlacement;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public final class Controls {
    private static final Map<UUID, SlabPlacement.Mode> modeMap = new HashMap<UUID, SlabPlacement.Mode>();
    private static boolean overlayActive = true;
    public static KeyMapping.Category MAIN;
    public static KeyMapping cycleMode;
    public static KeyMapping toggleOverlay;

    public static SlabPlacement.Mode getPlacementMode(UUID player) {
        return modeMap.computeIfAbsent(player, uuid -> SlabPlacement.Mode.HYBRID);
    }

    private static void cyclePlacementMode(UUID player) {
        modeMap.put(player, Controls.getPlacementMode(player).next());
    }

    private static void setPlacementMode(UUID player, SlabPlacement.Mode mode) {
        modeMap.put(player, mode);
    }

    private static void receivePlacementMode(SlabPlacement.Mode mode, NetworkManager.PacketContext context) {
        Controls.setPlacementMode(context.getPlayer().getUUID(), mode);
    }

    public static boolean isOverlayActive() {
        return overlayActive;
    }

    public static void toggleOverlayActive() {
        overlayActive = !overlayActive;
    }

    public static void serverInit() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, SlabPlacement.Mode.PACKET_TYPE, SlabPlacement.Mode.PACKET_CODEC, Controls::receivePlacementMode);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void clientInit() {
        ControlsImpl.clientInit();
    }

    public static void onClientTick(Minecraft client) {
        if (client.player == null) {
            return;
        }
        UUID uuid = client.player.getUUID();
        boolean sendVerticalPacket = false;
        while (toggleOverlay.consumeClick()) {
            Controls.toggleOverlayActive();
        }
        while (cycleMode.consumeClick()) {
            Controls.cyclePlacementMode(uuid);
            sendVerticalPacket = true;
        }
        if (sendVerticalPacket) {
            NetworkManager.sendToServer((CustomPacketPayload)Controls.getPlacementMode(uuid));
        }
    }
}

